/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLEmail
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIEmail email = null;

    public WXMLEmail(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof BIEmail;
        if (result) {
            this.email = (BIEmail)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.email != null) {
            String designName = this.email.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("emailPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof BIEmail) {
            BIEmail email = (BIEmail)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("address", String.valueOf(StringUtilities.encodeAttributeValue(email.getEmailAddress())));
            map.put("type", String.valueOf(StringUtilities.encodeAttributeValue(email.getType())));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

