/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.Map;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIResponsibleParty;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLParty
extends AbstractRXMLDesignObject
implements BIConstants {
    public RXMLParty(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getBusinessInfoDesign().getResPartySet().createParty(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        BIResponsibleParty party = (BIResponsibleParty)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        party.setResponsibility(StringUtilities.decodeAttributeValue((String)map.get("responsibility")));
        Map objMap = this.getProperties(objInfo, "contacts");
        Object[] objects = objMap.keySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            BIContact contact = (BIContact)party.getDesign().getBusinessInfoDesign().getContactSet().getObjectByID(aID);
            if (contact == null) continue;
            party.addContact(contact);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(party.getObjectID())).append(".dmd");
        party.setFilePath(buffer.toString());
        return party;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("partyPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == BIResponsibleParty.class;
    }
}

