/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.List;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLTableView
extends AbstractWXMLDesignObject {
    TableView view = null;

    public WXMLTableView(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof TableView;
        if (result) {
            this.view = (TableView)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.view != null) {
            String designName = this.view.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("rel").append('/').append(this.view.getDesignPart().getPathIDString()).append('/');
        }
        buffer.append(this.getConfiguration().get("tableViewPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element parentNode, DesignObject object) {
        if (object instanceof TableView) {
            String where;
            TableView view = (TableView)object;
            Document doc = parentNode.getOwnerDocument();
            if (view.getBasedOnStructuredType() != null) {
                parentNode.setAttribute("structuredType", StringUtilities.encodeAttributeValue(view.getBasedOnStructuredType().getObjectID()));
                if (view.getOidText() != null && !"".equalsIgnoreCase(view.getOidText())) {
                    parentNode.setAttribute("oid_text", StringUtilities.encodeAttributeValue(view.getOidText()));
                }
            }
            parentNode.setAttribute("allow_type_substitution", String.valueOf(view.isAllowTypeSubstitution()));
            Element containerInfo = doc.createElement("containers");
            parentNode.appendChild(containerInfo);
            for (AbstractView.ContainerHolder ch : view.getUsedContainers()) {
                this.appendContainerInfo(doc, containerInfo, StringUtilities.encodeAttributeValue(ch.getContainer().getObjectID()), StringUtilities.encodeAttributeValue(ch.getAlias()));
            }
            String userDefined = "" + view.getUserDefined();
            Element child = doc.createElement("userDefined");
            Text content = doc.createTextNode(StringUtilities.encodeAttributeValue(userDefined));
            child.appendChild(content);
            parentNode.appendChild(child);
            String userDefinedSQL = view.getUserDefinedSQL();
            if (userDefinedSQL != null) {
                child = doc.createElement("userDefinedSQL");
                content = doc.createTextNode(StringUtilities.encodeAttributeValue(userDefinedSQL));
                child.appendChild(content);
                parentNode.appendChild(child);
            }
            if ((where = view.getWhere()) != null) {
                child = doc.createElement("where");
                content = doc.createTextNode(StringUtilities.encodeAttributeValue(where));
                child.appendChild(content);
                parentNode.appendChild(child);
            }
            child = doc.createElement("groupby");
            this.appendGroupBy(parentNode, child, view.getGroupByList());
            String having = view.getHaving();
            if (having != null) {
                child = doc.createElement("having");
                content = doc.createTextNode(StringUtilities.encodeAttributeValue(having));
                child.appendChild(content);
                parentNode.appendChild(child);
            }
            Element objectInfo = doc.createElement("orderby");
            parentNode.appendChild(objectInfo);
            for (ContainedObject col : view.getOrderByList()) {
                String colObjId = StringUtilities.encodeAttributeValue(col.getObjectID());
                String colName = StringUtilities.encodeAttributeValue(col.getName());
                String sort = view.getSortOrder(colObjId);
                if (sort == "") {
                    sort = "ASC";
                }
                if (((ColumnView)col).getTable() != null) {
                    this.appendOrderByInfo(doc, objectInfo, colObjId, colName, StringUtilities.encodeAttributeValue(((ColumnView)col).getTable().getObjectID()), sort);
                    continue;
                }
                if (((ColumnView)col).getView() != null) {
                    this.appendOrderByInfo(doc, objectInfo, colObjId, colName, StringUtilities.encodeAttributeValue(((ColumnView)col).getView().getObjectID()), sort);
                    continue;
                }
                this.appendOrderByInfo(doc, objectInfo, colObjId, colName, StringUtilities.encodeAttributeValue(((ColumnView)col).getContainer().getObjectID()), sort);
            }
            this.appendScriptInfo(parentNode, "beforeDrop", view.getBeforeDrop());
            this.appendScriptInfo(parentNode, "beforeCreate", view.getBeforeCreate());
            this.appendScriptInfo(parentNode, "beforeAlter", view.getBeforeAlter());
            this.appendScriptInfo(parentNode, "afterCreate", view.getAfterCreate());
            this.appendScriptInfo(parentNode, "afterAlter", view.getAfterAlter());
            this.appendScriptInfo(parentNode, "endOfScript", view.getEndOfScript());
        }
    }

    protected final Element appendOrderByInfo(Document doc, Element containerNode, String objectID, String name, String containerID, String sortOrder) {
        Element objectInfo = doc.createElement("columnview");
        objectInfo.setAttribute("objectid", StringUtilities.encodeAttributeValue(objectID));
        objectInfo.setAttribute("name", StringUtilities.encodeAttributeValue(name));
        objectInfo.setAttribute("cid", StringUtilities.encodeAttributeValue(containerID));
        objectInfo.setAttribute("sortorder", sortOrder);
        containerNode.appendChild(objectInfo);
        return objectInfo;
    }

    protected final Element appendContainerInfo(Document doc, Element containerNode, String objectID, String alias) {
        Element objectInfo = doc.createElement("container");
        objectInfo.setAttribute("alias", StringUtilities.encodeAttributeValue(alias));
        objectInfo.setAttribute("cid", StringUtilities.encodeAttributeValue(objectID));
        containerNode.appendChild(objectInfo);
        return objectInfo;
    }

    @Override
    protected void appendContainedObjectInfo(Element parentNode, ContainedObject object) {
        String dataType;
        String expression;
        String view;
        String table;
        String refColumn;
        String tableAlias;
        Text content;
        Element child;
        ColumnView columnView = (ColumnView)object;
        Document doc = parentNode.getOwnerDocument();
        parentNode.setAttribute("tableid", StringUtilities.encodeAttributeValue(columnView.getContainer().getObjectID()));
        parentNode.setAttribute("reference", String.valueOf(columnView.isReference()));
        parentNode.setAttribute("dttype", columnView.getStructuredType() != null ? StringUtilities.encodeAttributeValue(columnView.getStructuredType().getObjectID()) : "");
        this.appendScopeInfo(parentNode, columnView);
        String alias = columnView.getAlias();
        if (alias != null) {
            child = doc.createElement("alias");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(alias));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if ((tableAlias = columnView.getTableAlias()) != null) {
            child = doc.createElement("tableAlias");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(tableAlias));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if (columnView.getReferencedColumn() != null && (refColumn = columnView.getReferencedColumn().getObjectID()) != null) {
            child = doc.createElement("refcolumn");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(refColumn));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if (columnView.getReferencedColumnView() != null && (refColumn = columnView.getReferencedColumnView().getObjectID()) != null) {
            child = doc.createElement("ref_column_view");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(refColumn));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if (columnView.getTable() != null && (table = columnView.getTable().getObjectID()) != null) {
            child = doc.createElement("table");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(table));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if (columnView.getView() != null && (view = columnView.getView().getObjectID()) != null) {
            child = doc.createElement("view");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(view));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if ((expression = columnView.getExpression()) != null) {
            child = doc.createElement("expression");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(expression));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
        if ((dataType = columnView.getDataTypeString()) != null) {
            child = doc.createElement("datatype");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(dataType));
            child.appendChild(content);
            parentNode.appendChild(child);
        }
    }

    private void appendGroupBy(Element mappingNode, Element element, List list) {
        if (list.size() > 0) {
            for (ColumnView cv : list) {
                if (cv == null) continue;
                Element node = mappingNode.getOwnerDocument().createElement("cv_id");
                node.setAttribute("value", cv.getObjectID());
                element.appendChild(node);
            }
            mappingNode.appendChild(element);
        }
    }
}

