/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLRelation
extends AbstractWXMLDesignObject {
    Relation relation = null;

    public WXMLRelation(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result;
        boolean bl = result = object.getClass() == Relation.class;
        if (result) {
            this.relation = (Relation)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.relation != null) {
            String designName = this.relation.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("relationPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element parentNode, DesignObject object) {
        if (object instanceof Relation) {
            Relation rel = (Relation)object;
            this.appendConnectionInfo(parentNode, rel.getSourceConnection(), "source");
            this.appendConnectionInfo(parentNode, rel.getTargetConnection(), "target");
            Element dominantRole = parentNode.getOwnerDocument().createElement("dominant_role");
            Text content = parentNode.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(rel.getDominantRole().getObjectID()));
            dominantRole.appendChild(content);
            parentNode.appendChild(dominantRole);
            Element identifyingNode = parentNode.getOwnerDocument().createElement("identifying");
            Text contentid = rel.isIdentifying() ? parentNode.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(VALUE_TRUE)) : parentNode.getOwnerDocument().createTextNode(StringUtilities.encodeAttributeValue(VALUE_FALSE));
            identifyingNode.appendChild(contentid);
            parentNode.appendChild(identifyingNode);
        }
    }

    private void appendConnectionInfo(Element parentNode, Relation.Connection connection, String label) {
        Element connectionNode = parentNode.getOwnerDocument().createElement("connection");
        parentNode.appendChild(connectionNode);
        connectionNode.setAttribute("endpoint", label);
        connectionNode.setAttribute("card", connection.getCardinality().toString());
        connectionNode.setAttribute("entity", StringUtilities.encodeAttributeValue(connection.getEntity().getObjectID()));
        connectionNode.setAttribute("allownull", String.valueOf(connection.isOptional()));
    }
}

