/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLForeignKey
extends AbstractWXMLDesignObject {
    FKIndexAssociation fkey = null;

    public WXMLForeignKey(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result;
        boolean bl = result = object.getClass() == FKIndexAssociation.class;
        if (result) {
            this.fkey = (FKIndexAssociation)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.fkey != null) {
            String designName = this.fkey.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("rel").append('/').append(this.fkey.getDesignPart().getPathIDString()).append('/');
        }
        buffer.append(this.getConfiguration().get("fkeyPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element parentNode, DesignObject object) {
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fkAssociation = (FKIndexAssociation)object;
            parentNode.setAttribute("tableid", StringUtilities.encodeAttributeValue(fkAssociation.getTable().getObjectID()));
            parentNode.setAttribute("reftableid", StringUtilities.encodeAttributeValue(fkAssociation.getOriginalContainer().getObjectID()));
            parentNode.setAttribute("references", StringUtilities.encodeAttributeValue(fkAssociation.getKeyObject().getObjectID()));
            parentNode.setAttribute("localindexid", StringUtilities.encodeAttributeValue(fkAssociation.getLocalFKIndex().getObjectID()));
            parentNode.setAttribute("delrule", fkAssociation.getDeleteRule());
            parentNode.setAttribute("mandatory", String.valueOf(fkAssociation.isMandatory()));
            parentNode.setAttribute("transferable", String.valueOf(fkAssociation.isTransferable()));
        }
    }
}

