/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.InputStream;
import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLSubview
extends AbstractXMLReader {
    private static final Logger LOGGER = new Logger(RXMLSubview.class);

    public RXMLSubview(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("subviews");
        }
        return buffer.toString();
    }

    @Override
    public String getRelativePath(Object object) {
        if (object instanceof DesignPart) {
            DesignPart dp = (DesignPart)object;
            StringBuffer buffer = new StringBuffer();
            if (this.getPersistenceManager().getAppView() != null) {
                String designName = StringUtilities.decodeAttributeValue(this.getPersistenceManager().getAppView().getDesignName());
                String dpid = StringUtilities.decodeAttributeValue(dp.getObjectID());
                String dpPath = "";
                if (dp instanceof RelationalDesign) {
                    if (this.isOldDesign()) {
                        dpPath = "relational";
                    } else {
                        dpid = dp.getPathIDString();
                        dpPath = "rel";
                    }
                } else if (dp instanceof LogicalDesign) {
                    dpPath = "logical";
                } else if (dp instanceof DataTypesDesign) {
                    dpPath = "datatypes";
                }
                buffer.append(designName).append('/').append(dpPath);
                if (dp instanceof RelationalDesign) {
                    buffer.append('/').append(dpid);
                }
                buffer.append('/').append("subviews");
            }
            return buffer.toString();
        }
        return this.getRelativePath();
    }

    public Object recreateObject(Object id, DesignPart dp, boolean tryReadWriteLocking) {
        InputStream is = this.getInputStreamFor(dp, id);
        if (is != null) {
            try {
                Design design = dp != null ? dp.getDesign() : null;
                Document doc = RXMLSubview.parse(is, this.getFilename(id), design);
                return this.recreateObject(doc, dp, tryReadWriteLocking);
            }
            catch (Throwable th) {
                Design.openFailed();
                LOGGER.error("RXMLSubview - Error recreating object from XML: " + id + " \n" + th.toString());
                return null;
            }
        }
        return null;
    }

    public InputStream getInputStreamFor(DesignPart dp, Object name) {
        String location = this.getRelativePath(dp);
        InputStream is = this.getPersistenceManager().getInputStreamFor(location, this.getFilename(name));
        if (is == null) {
            LOGGER.error("Data inputstream is null (path: " + location + " name: " + this.getFilename(name) + ")");
        }
        return is;
    }

    public Object recreateObject(Document doc, DesignPart dp, boolean tryReadWriteLocking) {
        try {
            Element objInfo = doc.getDocumentElement();
            return this.recreateObject(objInfo, dp, tryReadWriteLocking);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Object recreateObject(Element objInfo, DesignPart dp, boolean tryReadWriteLocking) {
        DesignPartViewPlaceHolder dph;
        String value;
        DesignPartView dpv;
        Element subview_elm = RXMLSubview.getFirstChildByTagName(objInfo, "sub_view");
        String dpvName = subview_elm.getAttribute("subview_name");
        String dpvId = subview_elm.getAttribute("id");
        String generatorId = subview_elm.getAttribute("generator");
        String sv_type = subview_elm.getAttribute("sv_type");
        if ("main_view".equalsIgnoreCase(sv_type)) {
            dpv = dp.getMainView();
            dp.getMainDPVPlaceHolder().setDesignPartView(dpv);
        } else {
            dpv = dp.createDesignPartSubView();
        }
        dpv.setName(StringUtilities.decodeAttributeValue(dpvName));
        this.readDisplayProperties(subview_elm, dpv);
        dpv.setVisible(false);
        String visible = subview_elm.getAttribute("visible");
        if (dpvId != null && !"".equalsIgnoreCase(dpvId) && !"null".equalsIgnoreCase(dpvId)) {
            dpv.setDPVId(dpvId);
        }
        if (generatorId != null && !"".equalsIgnoreCase(generatorId) && !"null".equalsIgnoreCase(generatorId)) {
            dpv.setGeneratorId(generatorId);
        }
        if (!"".equalsIgnoreCase(value = subview_elm.getAttribute("rep_oid")) && !"null".equalsIgnoreCase(value)) {
            dpv.setRepositoryOID(value);
        }
        if (!"".equalsIgnoreCase(value = subview_elm.getAttribute("rep_ovid")) && !"null".equalsIgnoreCase(value)) {
            dpv.setRepositoryOVID(value);
        }
        if (!"".equalsIgnoreCase(value = subview_elm.getAttribute("is_checkedout"))) {
            dpv.setCheckedOut(Boolean.valueOf(value));
        }
        value = subview_elm.getAttribute("checkedout_by");
        dpv.setCheckedOutBy(value);
        this.readMainDisplay(subview_elm, dpv);
        int ind = dpv.getTabbedPane().indexOfComponent(dpv);
        if (ind < 0) {
            dpv.getTabbedPane().setName(dpv.getName());
            dpv.getTabbedPane().add(dpv);
        }
        this.readSubordinateDisplays(subview_elm, dpv);
        dpv.setMustBeVisible(visible.equalsIgnoreCase("true"));
        String comment = subview_elm.getAttribute("comment");
        ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setComment(StringUtilities.decodeAttributeValue(comment));
        String notes = subview_elm.getAttribute("notes");
        ((DesignPartViewPlaceHolder)dpv.getPlaceHolder()).setNotes(StringUtilities.decodeAttributeValue(notes));
        dpv.getTabbedPane().setSelectedComponent(dpv);
        dpv.getWorkSpace().updateSettings();
        if (dpv.isMasterDPV() && (dph = (DesignPartViewPlaceHolder)dpv.getPlaceHolder()) != null) {
            StringBuffer buffer = new StringBuffer();
            if (this.getPersistenceManager().getAppView() != null) {
                buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
            }
            buffer.append(this.getRelativePath(dp)).append('/').append(dpv.getDPVId()).append(".dmd");
            dph.setFilePath(buffer.toString());
        }
        return dpv;
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        return null;
    }

    public void readExtSubViews(Element parentNode, DesignPart dp) {
        ApplicationView.log(MessageFormat.format(Messages.getString("RXMLSubview.ReadSubViewsFor"), dp.getName()));
        Element subviews = RXMLSubview.getFirstChildByTagName(parentNode, "ext_sub_views_collection");
        if (subviews != null) {
            NodeList objectElements = subviews.getElementsByTagName("sub_view");
            int length = objectElements.getLength();
            for (int i = 0; i < length; ++i) {
                String dpvId;
                Object obj;
                Element subview_elm = (Element)objectElements.item(i);
                if (subview_elm.getParentNode() != subviews || !((obj = this.recreateObject((Object)(dpvId = subview_elm.getAttribute("id")), dp, false)) instanceof DesignPartView)) continue;
                DesignPartView dpv = (DesignPartView)obj;
                dpv.setVisible(false);
                String visible = subview_elm.getAttribute("visible");
                dpv.setMustBeVisible(visible.equalsIgnoreCase("true"));
                dpv.setDirty(false);
            }
        }
    }
}

