/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RXMLEntityView
extends AbstractRXMLDesignObject {
    public RXMLEntityView(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("logical").append('/');
        }
        buffer.append(this.getConfiguration().get("tableViewPath"));
        return buffer.toString();
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("tableview id prefix");
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getLogicalDesign().getEntityViewSet().createEntityView(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof EntityView) {
            String having;
            Node textNode;
            Element havingElm;
            String where;
            Node textNode2;
            Element whereElm;
            String userDefinedSQL;
            Node textNode3;
            Element userDefinedSQLElm;
            String userDefined;
            Node textNode4;
            Element userDefinedElm;
            String typesubst;
            String structuredTypeID;
            EntityView view = (EntityView)desObject;
            String viewType = objInfo.getAttribute("viewtype");
            if (viewType != null) {
                view.setViewType(viewType);
            }
            if ((structuredTypeID = objInfo.getAttribute("structuredType")) != null) {
                StructuredType structuredType = (StructuredType)desObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(structuredTypeID);
                view.setBasedOnStructuredType(structuredType);
            }
            if ((typesubst = objInfo.getAttribute("allow_type_substitution")) != null) {
                view.setAllowTypeSubstitution(Boolean.valueOf(typesubst));
            }
            if ((userDefinedElm = RXMLEntityView.getFirstChildByTagName(objInfo, "userDefined")) != null && (textNode4 = userDefinedElm.getFirstChild()) != null && (userDefined = textNode4.getNodeValue()) != null) {
                view.setUserDefined(Boolean.valueOf(StringUtilities.decodeAttributeValue(userDefined)));
            }
            if ((userDefinedSQLElm = RXMLEntityView.getFirstChildByTagName(objInfo, "userDefinedSQL")) != null && (textNode3 = userDefinedSQLElm.getFirstChild()) != null && (userDefinedSQL = textNode3.getNodeValue()) != null) {
                view.setUserDefinedSQL(StringUtilities.decodeAttributeValue(userDefinedSQL));
            }
            if ((whereElm = RXMLEntityView.getFirstChildByTagName(objInfo, "where")) != null && (textNode2 = whereElm.getFirstChild()) != null && (where = textNode2.getNodeValue()) != null) {
                view.setWhere(StringUtilities.decodeAttributeValue(where));
            }
            if ((havingElm = RXMLEntityView.getFirstChildByTagName(objInfo, "having")) != null && (textNode = havingElm.getFirstChild()) != null && (having = textNode.getNodeValue()) != null) {
                view.setHaving(StringUtilities.decodeAttributeValue(having));
            }
            NodeList contElms = objInfo.getElementsByTagName("container");
            int clength = contElms.getLength();
            for (int i = 0; i < clength; ++i) {
                Element containElm = (Element)contElms.item(i);
                String alias = containElm.getAttribute("alias");
                String objectId = containElm.getAttribute("cid");
                if (objectId == null || alias == null) continue;
                view.addToContainers(StringUtilities.decodeAttributeValue(objectId), StringUtilities.decodeAttributeValue(alias));
            }
        }
    }

    @Override
    protected void readContainedObjectInfo(Element objInfo, ContainerObject container, ContainedObject contObject, boolean tryReadWriteLocking) {
        String dataType;
        Node textNode;
        Element dataTypeElm;
        String expression;
        Node textNode2;
        Element expressionElm;
        String viewID;
        Node textNode3;
        Element viewElm;
        String tID;
        Node textNode4;
        Element tableElm;
        String refColumnID;
        Node textNode5;
        Element refColumnElm;
        String alias;
        Node textNode6;
        Element tableAliasElm;
        String alias2;
        Node textNode7;
        Element aliasElm;
        String oid;
        Element scopeElm;
        StructuredType st;
        DesignObject table;
        AttributeView adapter = (AttributeView)contObject;
        String tableID = objInfo.getAttribute("tableid");
        if (tableID != null && (table = container.getDesign().getDesignObject(tableID)) != null) {
            adapter.setContainer((ContainerObject)table);
        }
        String reference = objInfo.getAttribute("reference");
        adapter.setReference(Boolean.valueOf(reference));
        String stID = objInfo.getAttribute("dttype");
        if (!"".equalsIgnoreCase(stID) && (st = (StructuredType)container.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(stID)) != null) {
            adapter.setStructuredType(st);
        }
        if ((scopeElm = RXMLEntityView.getFirstChildByTagName(objInfo, "scope")) != null && (oid = scopeElm.getAttribute("objectid")) != null) {
            adapter.setScopeId(oid);
        }
        if ((aliasElm = RXMLEntityView.getFirstChildByTagName(objInfo, "alias")) != null && (textNode7 = aliasElm.getFirstChild()) != null && (alias2 = textNode7.getNodeValue()) != null) {
            adapter.setAlias(StringUtilities.decodeAttributeValue(alias2));
        }
        if ((tableAliasElm = RXMLEntityView.getFirstChildByTagName(objInfo, "tableAlias")) != null && (textNode6 = tableAliasElm.getFirstChild()) != null && (alias = textNode6.getNodeValue()) != null) {
            adapter.setTableAlias(StringUtilities.decodeAttributeValue(alias));
        }
        if ((refColumnElm = RXMLEntityView.getFirstChildByTagName(objInfo, "refcolumn")) != null && (textNode5 = refColumnElm.getFirstChild()) != null && (refColumnID = textNode5.getNodeValue()) != null) {
            Attribute attribute = (Attribute)container.getDesign().getDesignObject(refColumnID);
            adapter.setReferencedColumn(attribute);
        }
        if ((tableElm = RXMLEntityView.getFirstChildByTagName(objInfo, "table")) != null && (textNode4 = tableElm.getFirstChild()) != null && (tID = textNode4.getNodeValue()) != null) {
            Entity entity = (Entity)container.getDesign().getDesignObject(tID);
            adapter.setEntity(entity);
        }
        if ((viewElm = RXMLEntityView.getFirstChildByTagName(objInfo, "view")) != null && (textNode3 = viewElm.getFirstChild()) != null && (viewID = textNode3.getNodeValue()) != null) {
            EntityView view = (EntityView)container.getDesign().getDesignObject(viewID);
            adapter.setView(view);
        }
        if ((expressionElm = RXMLEntityView.getFirstChildByTagName(objInfo, "expression")) != null && (textNode2 = expressionElm.getFirstChild()) != null && (expression = textNode2.getNodeValue()) != null) {
            adapter.setExpression(StringUtilities.decodeAttributeValue(expression));
        }
        if ((dataTypeElm = RXMLEntityView.getFirstChildByTagName(objInfo, "datatype")) != null && (textNode = dataTypeElm.getFirstChild()) != null && (dataType = textNode.getNodeValue()) != null) {
            adapter.setDataType(StringUtilities.decodeAttributeValue(dataType));
        }
        if (!container.contains(contObject)) {
            container.add(contObject);
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        EntityView view = (EntityView)super.recreateObject(objInfo, design, tryReadWriteLocking);
        if (view.getGroupBy().length() > 0) {
            StringTokenizer st = new StringTokenizer(view.getGroupBy(), ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                AttributeView cv = view.getAttributeViewByLongName(token);
                if (cv == null) continue;
                view.addGroupByList(cv);
            }
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(view.getObjectID())).append(".dmd");
        view.setFilePath(buffer.toString());
        return view;
    }

    @Override
    protected void readGroupBy(Element mappingElement, String id, ContainerObject obj, List list) {
        EntityView view = (EntityView)obj;
        Element node = RXMLEntityView.getFirstChildByTagName(mappingElement, id);
        if (node != null) {
            NodeList propList = node.getElementsByTagName("cv_id");
            int l = propList.getLength();
            for (int j = 0; j < l; ++j) {
                Element param = (Element)propList.item(j);
                String cid = param.getAttribute("value");
                AttributeView cv = view.getAttributeByObjectID(cid);
                if (list.contains(cv)) continue;
                list.add(cv);
            }
        }
    }

    @Override
    protected void readOrderBy(Element parent, ContainerObject object) {
        EntityView view = (EntityView)object;
        Element orderByEl = RXMLEntityView.getFirstChildByTagName(parent, "orderby");
        HashMap<String, String> sortMap = new HashMap<String, String>();
        NodeList columnElms = orderByEl.getElementsByTagName("columnview");
        int length = columnElms.getLength();
        for (int i = 0; i < length; ++i) {
            Element containElm = (Element)columnElms.item(i);
            String objectId = containElm.getAttribute("objectid");
            String sortType = containElm.getAttribute("sortorder");
            String containerID = containElm.getAttribute("cid");
            String name = containElm.getAttribute("name");
            for (AttributeView attrView : view.getElementsCollection()) {
                if (!attrView.getName().equalsIgnoreCase(name)) continue;
                view.addToOrderBy(attrView, sortType);
                sortMap.put(objectId, sortType);
            }
            if (view.getElementByName(name) != null) continue;
            AttributeView newAttrView = new AttributeView(view.getDesignPart());
            newAttrView.setObjectID(StringUtilities.decodeAttributeValue(objectId));
            newAttrView.setName(name);
            if ((Entity)((LogicalDesign)view.getDesignPart()).getEntitySet().getObjectByID(containerID) != null) {
                newAttrView.setTableAlias(((Entity)((LogicalDesign)view.getDesignPart()).getEntitySet().getObjectByID(containerID)).getName());
            }
            view.addToOrderBy(newAttrView, sortType);
        }
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == EntityView.class;
    }
}

