/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RDBMSTypeSet;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RXMLDefaultRDBMSSiteSet
implements XMLConstants {
    private static final Logger LOGGER = new Logger(RXMLDefaultRDBMSSiteSet.class);

    public Object readDefaultRDBMSSites(String path, Design design) {
        return this.readDefaultRDBMSSites(path, design, new RDBMSSiteSet(design));
    }

    public Object readDefaultRDBMSSites(String path, Design design, RDBMSSiteSet set) {
        File file = new File(path);
        try {
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputSource inputSource = new InputSource(new InputStreamReader((InputStream)fis, "UTF-8"));
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                RDBMSTypeSet typeSet = Design.getDefaultRDBMSTypeSet();
                Element root = doc.getDocumentElement();
                NodeList siteList = root.getElementsByTagName("site");
                int length = siteList.getLength();
                for (int i = 0; i < length; ++i) {
                    this.recreateSite((Element)siteList.item(i), set, typeSet);
                }
                return set;
            }
        }
        catch (Exception e) {
            LOGGER.error(e);
        }
        return set;
    }

    public RDBMSSite recreateSite(Element siteElm, RDBMSSiteSet set, RDBMSTypeSet typeSet) {
        String name = this.getEncoded(siteElm, "name");
        String typeStr = siteElm.getAttribute("type");
        String siteID = this.getEncoded(siteElm, "oid");
        String pathIDStr = siteElm.getAttribute("pathid");
        RDBMSSite site = set.getByObjectID(siteID);
        if (site != null) {
            return site;
        }
        site = set.createSite(name, set.getDesign());
        site.setIsDefault(true);
        site.setDesignLevel(false);
        int type = 8;
        try {
            type = Integer.parseInt(typeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        RDBMSType rdbmsType = typeSet.get(type);
        site.setType(rdbmsType);
        site.setObjectID(siteID);
        int pathID = 0;
        try {
            pathID = Integer.parseInt(pathIDStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            type = Integer.parseInt(typeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pathID > 0) {
            site.setPathID(pathID);
            set.updateMaxIndex(pathID);
        } else {
            site.setPathID(set.nextIndex());
        }
        if (rdbmsType == null) {
            LOGGER.error("Unknown RDBMS type: " + type);
        }
        return site;
    }

    private String getEncoded(Element siteElement, String name) {
        return StringUtilities.decodeAttributeValue(siteElement.getAttribute(name));
    }
}

