/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;

public class RepositoryFactory {
    OracleRepositoryManager repositoryManager;
    private static final Logger LOGGER = new Logger(RepositoryFactory.class);

    public RepositoryFactory(OracleRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRepository(Connection connection, String name, String version, String softVersion, String owner) throws SQLException {
        try (Statement st = connection.createStatement();){
            String query = "CREATE TABLE Repository(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , version NUMBER , software_version NUMBER , Owner VARCHAR2 (30) )";
            st.execute(query);
            String oid = new GUID().toString();
            st.execute("insert into repository (name, oid, version, software_version, owner) values('" + name + "', '" + oid + "', '" + version + "', '" + softVersion + "', '" + owner + "')");
            query = "CREATE TABLE DMR_Packages(Name VARCHAR2 (256)  NOT NULL , Type VARCHAR2 (30)  NOT NULL ,OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE , Short_description VARCHAR2 (2000) ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB )";
            st.execute(query);
            query = "CREATE TABLE DMR_Package_Members(Type VARCHAR2 (30)  NOT NULL ,OID VARCHAR2 (36)  NOT NULL ,Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE , Ownership_Flag CHAR (1)  NOT NULL ,Parent_OID VARCHAR2 (36)  NOT NULL , Parent_OVID VARCHAR2 (36)  NOT NULL )";
            st.execute(query);
            query = "CREATE TABLE Object_Register(OID VARCHAR2 (36) ,last_version VARCHAR2 (36) ,check_out_version VARCHAR2 (36) ,Checkout_by VARCHAR2 (30))";
            st.execute(query);
            query = "CREATE TABLE DMR_Tables(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Entities(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Views(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Arcs(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_FKArcs(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_EntViews(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Relations(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Source VARCHAR2 (36)  NOT NULL , Target VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_HRelations(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Source VARCHAR2 (36)  NOT NULL , Target VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Users (Name varchar2(30) not null, Viewer_Mode char(1) default 'N', Logical_Only char(1) default 'N',Deleted char(1) default 'N')";
            st.execute(query);
            st.execute("insert into DMR_users (name,Viewer_Mode,Logical_Only, Deleted) values (user,'N','N','N')");
            query = "CREATE TABLE DMR_FKeys(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Source VARCHAR2 (36)  NOT NULL , Target VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_LOGICAL_DATATYPES(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_RDBMS_SITES(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Domains(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Mappings(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Source VARCHAR2 (36)  NOT NULL , Target VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_PhysModels(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Reational_Model VARCHAR2 (36)  NOT NULL , DB_Site VARCHAR2 (36)  NOT NULL , DB_Type NUMBER (3)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE PM_Object_Register(OID VARCHAR2 (36) ,last_version VARCHAR2 (36) ,check_out_version VARCHAR2 (36) ,Checkout_by VARCHAR2 (30))";
            st.execute(query);
            query = "CREATE TABLE DMR_PhysModels_Members(Type VARCHAR2 (30)  NOT NULL ,OID VARCHAR2 (36)  NOT NULL ,Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE , Ownership_Flag CHAR (1)  NOT NULL ,Parent_OID VARCHAR2 (36)  NOT NULL , Parent_OVID VARCHAR2 (36)  NOT NULL )";
            st.execute(query);
            query = "CREATE TABLE DMR_Physical_Objects(Name VARCHAR2 (256)  NOT NULL , Type VARCHAR2 (30)  NOT NULL ,OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_StructuredTypes(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_DistinctTypes(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_CollectionTypes(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_RecordStructures(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_InfoStructures(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Events(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Roles(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_InfoStores(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_ExternalDatas(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_ExternalAgents(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_TransformationPackages(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Processes(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Transformations(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Flows(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Source VARCHAR2 (36)  NOT NULL , Target VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_TransformationFlows(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Source VARCHAR2 (36)  NULL , Target VARCHAR2 (36)  NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_BIEmails(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_BILocations(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_BIPhones(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_BIResourceLocators(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_BIContacts(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_BIResponsibleParties(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_BIDocuments(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Notes(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_ChangeRequests(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_SelectionCriterias(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Levels(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_RollupLinks(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Dimensions(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Measures(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Slices(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_FactEntitiesJoins(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Cubes(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Hierarchies(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_MeasureFolders(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_SQLAccessToAWs(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_Links(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Source VARCHAR2 (36)  NOT NULL , Target VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_RaggedHLinks(Name VARCHAR2 (256)  NOT NULL , OID VARCHAR2 (36)  NOT NULL , OVID VARCHAR2 (36)  NOT NULL , Source VARCHAR2 (36)  NOT NULL , Target VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "CREATE TABLE DMR_DL_Settings(Type VARCHAR2 (30)  NOT NULL ,Design_OID VARCHAR2 (36)  NOT NULL , Design_OVID VARCHAR2 (36)  NOT NULL , Created_by VARCHAR2 (30) , Date_Created DATE , Changed_by VARCHAR2 (30) ,Date_Changed DATE ,Check_Status CHAR (1) ,V_Sequence NUMBER , XML_Content BLOB)";
            st.execute(query);
            query = "create index DMR_DL_Settings_ix1 on DMR_DL_Settings (Design_OVID)";
            st.execute(query);
            query = "create index PM_OBJECT_REGISTER_ix1 on PM_OBJECT_REGISTER (oid,check_out_version,checkout_by,last_version)";
            st.execute(query);
            query = "create index DMR_PHYSICAL_OBJECTS_ix1 on DMR_PHYSICAL_OBJECTS(ovid)";
            st.execute(query);
            query = "create index Object_register_x1 on Object_register(oid,check_out_version,checkout_by,last_version)";
            st.execute(query);
            query = "create index DMR_Package_Members_ix1 on DMR_Package_Members(type,parent_ovid)";
            st.execute(query);
            query = "create index DMR_tables_ix1 on DMR_Tables(ovid)";
            st.execute(query);
            query = "create index DMR_Entities_ix1 on DMR_Entities(ovid)";
            st.execute(query);
            query = "create index DMR_Relations_ix1 on DMR_Relations(ovid)";
            st.execute(query);
            query = "create index DMR_FKeys_ix1 on DMR_FKeys(ovid)";
            st.execute(query);
            query = "create index DMR_HRelations_ix1 on DMR_HRelations(ovid)";
            st.execute(query);
            query = "create index DMR_Packages_ix1 on DMR_Packages(ovid)";
            st.execute(query);
            query = "create index DMR_FKArcs_ix1 on DMR_FKArcs(ovid)";
            st.execute(query);
            query = "create index DMR_Arcs_ix1 on DMR_Arcs(ovid)";
            st.execute(query);
            query = "create index DMR_Mappings_ix1 on DMR_Mappings(ovid)";
            st.execute(query);
            query = "create index DMR_EntViews_ix1 on DMR_EntViews(ovid)";
            st.execute(query);
            query = "create index DMR_Views_ix1 on DMR_Views(ovid)";
            st.execute(query);
            query = "create index DMR_Domains_ix1 on DMR_Domains(ovid)";
            st.execute(query);
            query = "create index DMR_LOGICAL_DATATYPES_ix1 on DMR_LOGICAL_DATATYPES(ovid)";
            st.execute(query);
            query = "create index DMR_StructuredTypes_ix1 on DMR_StructuredTypes(ovid)";
            st.execute(query);
            query = "create index DMR_DistinctTypes_ix1 on DMR_DistinctTypes(ovid)";
            st.execute(query);
            query = "create index DMR_CollectionTypes_ix1 on DMR_CollectionTypes(ovid)";
            st.execute(query);
            query = "create index DMR_RDBMS_SITES_ix1 on DMR_RDBMS_SITES(ovid)";
            st.execute(query);
            query = "create index DMR_RecordStructures_IX1 on DMR_RecordStructures(ovid)";
            st.execute(query);
            query = "create index DMR_InfoStructures_IX1 on DMR_InfoStructures(ovid)";
            st.execute(query);
            query = "create index DMR_Events_IX1 on DMR_Events(ovid)";
            st.execute(query);
            query = "create index DMR_Roles_IX1 on DMR_Roles(ovid)";
            st.execute(query);
            query = "create index DMR_InfoStores_IX1 on DMR_InfoStores(ovid)";
            st.execute(query);
            query = "create index DMR_ExternalDatas_IX1 on DMR_ExternalDatas(ovid)";
            st.execute(query);
            query = "create index DMR_ExternalAgents_IX1 on DMR_ExternalAgents(ovid)";
            st.execute(query);
            query = "create index DMR_TransformPackages_IX1 on DMR_TransformationPackages(ovid)";
            st.execute(query);
            query = "create index DMR_Processes_IX1 on DMR_Processes(ovid)";
            st.execute(query);
            query = "create index DMR_Transformations_IX1 on DMR_Transformations(ovid)";
            st.execute(query);
            query = "create index DMR_Flows_IX1 on DMR_Flows(ovid)";
            st.execute(query);
            query = "create index DMR_TransformationFlows_IX1 on DMR_TransformationFlows(ovid)";
            st.execute(query);
            query = "create index DMR_BIEmails_ix1 on DMR_BIEmails(ovid)";
            st.execute(query);
            query = "create index DMR_BILocations_ix1 on DMR_BILocations(ovid)";
            st.execute(query);
            query = "create index DMR_BIPhones_ix1 on DMR_BIPhones(ovid)";
            st.execute(query);
            query = "create index DMR_BIResourceLocators_ix1 on DMR_BIResourceLocators(ovid)";
            st.execute(query);
            query = "create index DMR_BIContacts_ix1 on DMR_BIContacts(ovid)";
            st.execute(query);
            query = "create index DMR_BIResponsibleParties_ix1 on DMR_BIResponsibleParties(ovid)";
            st.execute(query);
            query = "create index DMR_BIDocuments_ix1 on DMR_BIDocuments(ovid)";
            st.execute(query);
            query = "create index DMR_ChangeRequests_ix1 on DMR_ChangeRequests(ovid)";
            st.execute(query);
            query = "create index DMR_Notes_ix1 on DMR_Notes(ovid)";
            st.execute(query);
            query = "create index DMR_SelectionCriterias_IX1 on DMR_SelectionCriterias(ovid)";
            st.execute(query);
            query = "create index DMR_Levels_IX1 on DMR_Levels(ovid)";
            st.execute(query);
            query = "create index DMR_RollupLinks_IX1 on DMR_RollupLinks(ovid)";
            st.execute(query);
            query = "create index DMR_RaggedHLinks_IX1 on DMR_RaggedHLinks(ovid)";
            st.execute(query);
            query = "create index DMR_Dimensions_IX1 on DMR_Dimensions(ovid)";
            st.execute(query);
            query = "create index DMR_Measures_IX1 on DMR_Measures(ovid)";
            st.execute(query);
            query = "create index DMR_Slices_IX1 on DMR_Slices(ovid)";
            st.execute(query);
            query = "create index DMR_FactEntitiesJoins_IX1 on DMR_FactEntitiesJoins(ovid)";
            st.execute(query);
            query = "create index DMR_Cubes_IX1 on DMR_Cubes(ovid)";
            st.execute(query);
            query = "create index DMR_Links_IX1 on DMR_Links(ovid)";
            st.execute(query);
            query = "create index DMR_Hierarchies_IX1 on DMR_Hierarchies(ovid)";
            st.execute(query);
            query = "create index DMR_MeasureFolders_IX1 on DMR_MeasureFolders(ovid)";
            st.execute(query);
            query = "create index DMR_SQLAccessToAWs_IX1 on DMR_SQLAccessToAWs(ovid)";
            st.execute(query);
            AbstractRepositoryManager.INITIAL_WRITE_TODB = true;
            try {
                this.repositoryManager.writeRDBMSSites(this.repositoryManager.getDesign());
                this.repositoryManager.writeLogicalDatatypes(this.repositoryManager.getDesign());
                this.repositoryManager.writeRLDomains(this.repositoryManager.getDesign());
            }
            finally {
                AbstractRepositoryManager.INITIAL_WRITE_TODB = false;
            }
        }
    }

    public List getTableNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("DMR_Packages");
        list.add("DMR_Package_Members");
        list.add("DMR_Tables");
        list.add("DMR_Views");
        list.add("Object_register");
        list.add("Repository");
        list.add("DMR_FKeys");
        list.add("DMR_Relations");
        list.add("DMR_HRelations");
        list.add("DMR_Entities");
        list.add("DMR_EntViews");
        list.add("DMR_FKArcs");
        list.add("DMR_Arcs");
        list.add("DMR_Users");
        list.add("DMR_Mappings");
        list.add("DMR_Domains");
        list.add("DMR_PhysModels");
        list.add("PM_Object_Register");
        list.add("DMR_PhysModels_Members");
        list.add("DMR_Physical_Objects");
        list.add("DMR_LOGICAL_DATATYPES");
        list.add("DMR_RDBMS_SITES");
        list.add("DMR_StructuredTypes");
        list.add("DMR_DistinctTypes");
        list.add("DMR_CollectionTypes");
        list.add("DMR_RecordStructures");
        list.add("DMR_InfoStructures");
        list.add("DMR_Events");
        list.add("DMR_Roles");
        list.add("DMR_InfoStores");
        list.add("DMR_ExternalDatas");
        list.add("DMR_ExternalAgents");
        list.add("DMR_TransformationPackages");
        list.add("DMR_Processes");
        list.add("DMR_Transformations");
        list.add("DMR_Flows");
        list.add("DMR_TransformationFlows");
        list.add("DMR_BIEmails");
        list.add("DMR_BILocations");
        list.add("DMR_BIPhones");
        list.add("DMR_BIResourceLocators");
        list.add("DMR_BIContacts");
        list.add("DMR_BIResponsibleParties");
        list.add("DMR_BIDocuments");
        list.add("DMR_Notes");
        list.add("DMR_ChangeRequests");
        list.add("DMR_SelectionCriterias");
        list.add("DMR_Levels");
        list.add("DMR_RollupLinks");
        list.add("DMR_RaggedHLinks");
        list.add("DMR_Dimensions");
        list.add("DMR_Measures");
        list.add("DMR_Slices");
        list.add("DMR_FactEntitiesJoins");
        list.add("DMR_Cubes");
        list.add("DMR_Links");
        list.add("DMR_Hierarchies");
        list.add("DMR_MeasureFolders");
        list.add("DMR_SQLAccessToAWs");
        list.add(OracleRepositoryManager.T_DL_SETTINGS);
        return list;
    }

    public void dropRepository(Connection connection) {
        this.clearUsers(connection);
        try {
            for (String tbName : this.getTableNames()) {
                try {
                    String query = "drop table " + tbName + " CASCADE CONSTRAINTS";
                    PreparedStatement stmt = connection.prepareStatement(query);
                    stmt.execute();
                    stmt.close();
                }
                catch (SQLException e) {
                    System.out.println(tbName + " - " + e.getMessage());
                    LOGGER.error("RepositoryFactory.dropRepository: ", e);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            LOGGER.error("RepositoryFactory.dropRepository: ", e);
        }
    }

    public void upgradeRepository(Connection connection) {
    }

    public boolean canUpgradeRepository() {
        return false;
    }

    private void clearUsers(Connection connection) {
        block8: {
            try {
                Statement stmt = null;
                ResultSet resultSet = null;
                String query = "select name, viewer_mode, logical_only from DMR_Users";
                try {
                    stmt = connection.createStatement();
                    resultSet = stmt.executeQuery(query);
                }
                catch (SQLException e1) {
                    System.out.println(e1.getMessage());
                    LOGGER.error("RepositoryFactory.clearUsers: ", e1);
                }
                if (resultSet == null) break block8;
                try {
                    while (resultSet.next()) {
                        String name = resultSet.getString(1);
                        if (this.repositoryManager.getUser().trim().equalsIgnoreCase(name.trim())) continue;
                        this.dropSynonymsFor(name, connection);
                        this.revokePrivilegesFrom(name, connection);
                    }
                }
                catch (SQLException e) {
                    System.out.println(e.getMessage());
                    LOGGER.error("RepositoryFactory.clearUsers: ", e);
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                LOGGER.error("RepositoryFactory.clearUsers: ", ex);
            }
        }
    }

    public void revokePrivilegesFrom(String fromName, Connection sqlConnection) {
        try {
            Iterator it = this.getTableNames().iterator();
            String userName = this.repositoryManager.getUser();
            while (it.hasNext()) {
                String tbName = (String)it.next();
                try {
                    String query = "revoke select, insert, delete, update on " + userName + "." + tbName + " from " + fromName;
                    String selQuery = "revoke select on " + userName + "." + tbName + " from " + fromName;
                    PreparedStatement stmt = tbName.equalsIgnoreCase("Repository") || tbName.equalsIgnoreCase("DMR_Users") ? sqlConnection.prepareStatement(selQuery) : sqlConnection.prepareStatement(query);
                    stmt.execute();
                    stmt.close();
                }
                catch (SQLException e) {
                    System.out.println(tbName + " - " + e.getMessage());
                    LOGGER.error("RepositoryFactory.revokePrivilegesFrom: ", e);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            LOGGER.error("RepositoryFactory.revokePrivilegesFrom: ", e);
        }
    }

    public void dropSynonymsFor(String userName, Connection sqlConnection) {
        try {
            for (String tbName : this.getTableNames()) {
                try {
                    String query = "drop synonym " + userName + "." + tbName;
                    PreparedStatement stmt = sqlConnection.prepareStatement(query);
                    stmt.execute();
                    stmt.close();
                }
                catch (SQLException e) {
                    System.out.println(tbName + " - " + e.getMessage());
                    LOGGER.error("RepositoryFactory.dropSynonymsFor: ", e);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            LOGGER.error("RepositoryFactory.dropSynonymsFor: ", e);
        }
    }
}

