/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyTableSpace
extends AbstractDRStorageDesign {
    private final String RULE_ID = "25E8DDE0-DEF7-729D-14DE-2DCF1FE09F4E";

    public DRTableProxyTableSpace(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyTableSpace.CheckTablespace"));
        this.setDescription(Messages.getString("DRTableProxyTableSpace.TablespaceMustBeAssignedTotable"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxyUDB tableProxy = (TableProxyUDB)object;
        if (tableProxy.getTableSpace() == null || tableProxy.getTableSpace().isNullInstance()) {
            return CheckResult.createFailed(tableProxy, this, Messages.getString("DRTableProxyTableSpace.TablespaceMustBeAssignedToTable"));
        }
        if (tableProxy.getTableSpace().usedForDataBaseCreation()) {
            return CheckResult.createFailed(tableProxy, this, Messages.getString("DRTableProxyTableSpace.CatalogUserTemporaryTablespaceMayNotAssignedTotable"));
        }
        return CheckResult.createOk(tableProxy, this, Messages.getString("DRTableProxyTableSpace.TablespaceIsAssignedToTable"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "25E8DDE0-DEF7-729D-14DE-2DCF1FE09F4E";
    }
}

