/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.udb;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyReplication
extends AbstractDRStorageDesign {
    private final String RULE_ID = "D3B900B4-092B-F59B-3C63-D7468587824F";

    public DRTableProxyReplication(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyReplication.ReplicatedTableShouldHaveUK"));
        this.setDescription(Messages.getString("DRTableProxyReplication.ReplicatedTableShouldHaveUK"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxyUDB table = (TableProxyUDB)object;
        if ("YES".equalsIgnoreCase(table.getReplicated())) {
            IndexProxy[] indexes = table.getIndexProxies();
            boolean hasUnique = false;
            for (int i = 0; i < indexes.length; ++i) {
                if (!indexes[i].getIndex().isUnique()) continue;
                hasUnique = true;
                break;
            }
            if (!hasUnique) {
                return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyReplication.ReplicatedTableShouldHaveUK"));
            }
            return CheckResult.createOk(object, this, Messages.getString("DRTableProxyReplication.ReplicatedTableHasUK"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyReplication.CurrentTableIsNotReplicated"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "D3B900B4-092B-F59B-3C63-D7468587824F";
    }
}

