/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyUserSet
extends AbstractDRStorageDesign {
    private final String RULE_ID = "92407932-7700-A406-D0B5-84F54914D996";

    public DRTableProxyUserSet(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyUserSet.CheckWhetherUserIsSet"));
        this.setDescription(Messages.getString("DRTableProxyUserSet.TableProxyShouldHaveUserSet"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxySqlServer table = (TableProxySqlServer)object;
        if (table.getSchema() == null) {
            return CheckResult.createWarning(object, this, Messages.getString("DRTableProxyUserSet.SchemaIsNotSetToTheTable"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyUserSet.SchemaSetToTheTable"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "92407932-7700-A406-D0B5-84F54914D996";
    }
}

