/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.ColumnProxySqlServerv2k;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRDefaultAssignedColumns
extends AbstractDRStorageDesign {
    private final String RULE_ID = "297288BC-E64C-31EC-C434-4A188B46A1DB";

    public DRDefaultAssignedColumns(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRDefaultAssignedColumns.CheckForAssignedColumns"));
        this.setDescription(Messages.getString("DRDefaultAssignedColumns.DefaultObjectShouldBeAssigned1Column"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        DefaultSqlServer def = (DefaultSqlServer)object;
        boolean used = false;
        Iterator it = def.getStorageDesign().getColumnProxySet().iterator();
        while (it.hasNext()) {
            ColumnProxySqlServerv2k column = (ColumnProxySqlServerv2k)it.next();
            if (!column.getDefineDefault() || column.getDefaultObject() != def) continue;
            used = true;
            break;
        }
        if (used) {
            return CheckResult.createOk(object, this, Messages.getString("DRDefaultAssignedColumns.TheDefaultObjectHasAssignedColumns"));
        }
        return CheckResult.createWarning(object, this, Messages.getString("DRDefaultAssignedColumns.DefaultObjectDoesNotHaveColumnsAssigned"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "297288BC-E64C-31EC-C434-4A188B46A1DB";
    }
}

