/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRIndexProxySetBitmapIndexOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "ADBE5DDA-034D-79D0-F741-3F6AEC184536";

    public DRIndexProxySetBitmapIndexOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRIndexProxySetBitmapIndexOracle.SetBitmapIndex"));
        this.setDescription(Messages.getString("DRIndexProxySetBitmapIndexOracle.BITMAPIndexCannotBeSpecified"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        IndexProxyOracle index = (IndexProxyOracle)object;
        if (index.getBitmapIndex()) {
            if ("GLOBAL".equalsIgnoreCase(index.getIndexPartitioned())) {
                return CheckResult.createFailed(object, this, Messages.getString("DRIndexProxySetBitmapIndexOracle.BITMAPIndexCannotBeSpecifiedGlobalPartIndex"));
            }
            if ("INDEX".equalsIgnoreCase(((TableProxyOracle)index.getTableProxy()).getOrganization())) {
                return CheckResult.createFailed(object, this, Messages.getString("DRIndexProxySetBitmapIndexOracle.BITMAPIndexCannotBeSpecifiedIdxOrgTable"));
            }
            return CheckResult.createOk(object, this, Messages.getString("DRIndexProxySetBitmapIndexOracle.BITMAPIndexCannotBeSpecifiedGlobalPartIdx"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRIndexProxySetBitmapIndexOracle.IndexNotBITMAPSpecified"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "ADBE5DDA-034D-79D0-F741-3F6AEC184536";
    }
}

