/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2.v70;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRPartitionTablespaceWithoutPartIndex
extends AbstractDRStorageDesign {
    private final String RULE_ID = "1FAADF97-CADE-1096-CC78-38F60942F524";

    public DRPartitionTablespaceWithoutPartIndex(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRPartitionTablespaceWithoutPartIndex.CheckForPartitionedtablespacesWithoutPartitioningIndex"));
        this.setDescription(Messages.getString("DRPartitionTablespaceWithoutPartIndex.PartitionedTablespacesShouldHavePartitioningIndex"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableSpaceDB2 tablespace = (TableSpaceDB2)object;
        if ("PARTITIONED".equalsIgnoreCase(tablespace.getType())) {
            if (tablespace.getPartIndex() == null) {
                return CheckResult.createFailed(tablespace, this, Messages.getString("DRPartitionTablespaceWithoutPartIndex.PartitionedTablespaceDoesNothavePartitioningIndex"));
            }
            return CheckResult.createOk(tablespace, this, Messages.getString("DRPartitionTablespaceWithoutPartIndex.PartitionedTablespaceHasPartitioningIndex"));
        }
        return CheckResult.createOk(tablespace, this, Messages.getString("DRPartitionTablespaceWithoutPartIndex.CurrentTablespaceNotPartitioned"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "1FAADF97-CADE-1096-CC78-38F60942F524";
    }
}

