/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyIdentifyPK
extends AbstractDRStorageDesign {
    private final String RULE_ID = "1A6EB6D0-0129-76DF-7943-C852EF99DF01";

    public DRTableProxyIdentifyPK(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyIdentifyPK.IdentifyPK"));
        this.setDescription(Messages.getString("DRTableProxyIdentifyPK.RuleIdentifiesPKCandidates"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxy proxy = (TableProxy)object;
        Table table = (Table)proxy.getObject();
        StringBuffer message = new StringBuffer(Messages.getString("DRTableProxyIdentifyPK.TableHasNoPK"));
        KeyObject key = table.getPK();
        if (key == null) {
            boolean containsUnique = false;
            KeyObject[] keys = table.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                IndexProxy indexProxy = (IndexProxy)this.getProxyFor(keys[i]);
                if (indexProxy == null || !indexProxy.isClustered()) continue;
                message.append(keys[i].getName());
                if (keys[i].isUnique()) {
                    message.append(Messages.getString("DRTableProxyIdentifyPK.ClusteredUnique"));
                } else {
                    message.append(Messages.getString("DRTableProxyIdentifyPK.ClusteredNonunique"));
                }
                message.append("; ");
                containsUnique = true;
            }
            if (containsUnique) {
                return CheckResult.createWarning(object, this, message.toString());
            }
            return CheckResult.createOk(object, this, Messages.getString("DRTableProxyIdentifyPK.TableHasNoPKNoClustIndex"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyIdentifyPK.TableHasPKNoPKCandidatesPresented"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "1A6EB6D0-0129-76DF-7943-C852EF99DF01";
    }
}

