/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRSpatialTable
extends DesignRule {
    private final String RULE_ID = "2E60E441-23BD-1E46-1B57-8AEF6DB70E4C";

    public DRSpatialTable() {
        this.setName(Messages.getString("DRSpatialTable.IdentifyCorrectCreationOfSpatialTables"));
        this.setDescription(Messages.getString("DRSpatialTable.ForSpatialTablesDefineSpatialColumn"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Table table = (Table)object;
        if (table.isSpatialTable()) {
            if (table.getSpatialDefinitions().isEmpty()) {
                return CheckResult.createFailed(object, this, Messages.getString("DRSpatialTable.ForSpatialTablesDefineSpatialDefinition"));
            }
            for (SpatialColumnDefObject spObject : table.getSpatialDefinitions()) {
                if (spObject.getSpatialColumn() == null && !spObject.isFunction() && spObject.getTableDimensions().size() < 2) {
                    return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRSpatialTable.DefineSpatialColumnMinTwoTableDimensions"), spObject.getName()));
                }
                if (spObject.getTableDimensions().size() < 2) {
                    return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRSpatialTable.DefineTwoTableDimensions"), spObject.getName()));
                }
                if (spObject.isFunction() && spObject.getFuncExpression().trim().equals("")) {
                    return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRSpatialTable.DefineFunctionExpression"), spObject.getName()));
                }
                if (spObject.isFunction() || spObject.getSpatialColumn() != null) continue;
                return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRSpatialTable.DefineSpatialColumn"), spObject.getName()));
            }
        }
        return CheckResult.createOk(object, this, Messages.getString("DRSpatialTable.CorrectCreationOfSpatialTable"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "2E60E441-23BD-1E46-1B57-8AEF6DB70E4C";
    }
}

