/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRProcessWithoutTriggeringEvent
extends DesignRule {
    private final String RULE_ID = "36BF36C4-B7F1-9609-A916-0661E75AA50F";

    public DRProcessWithoutTriggeringEvent() {
        this.setName(Messages.getString("DRProcessWithoutTriggeringEvent.IdentifyPrimitiveProcessesWithoutTriggeringEvent"));
        this.setDescription(Messages.getString("DRProcessWithoutTriggeringEvent.PrimitiveProcessShouldHavetriggeringEvent"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Process process = (Process)object;
        if (!process.isComposite() && process.getEvents().size() < 1 && process.getFlowEvents().size() < 1) {
            return CheckResult.createWarning(object, this, Messages.getString("DRProcessWithoutTriggeringEvent.ProcessDoesntHaveTriggeringEvent"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRProcessWithoutTriggeringEvent.ProcessHasTriggeringEvent"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "36BF36C4-B7F1-9609-A916-0661E75AA50F";
    }
}

