/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRCompositeProcessWithoutSubProcesses
extends DesignRule {
    private final String RULE_ID = "89DA96F1-ABCC-DC13-A2B3-5C8947E83930";

    public DRCompositeProcessWithoutSubProcesses() {
        this.setName(Messages.getString("DRCompositeProcessWithoutSubProcesses.IdentifyCompositeProcessesWithoutSubprocesses"));
        this.setDescription(Messages.getString("DRCompositeProcessWithoutSubProcesses.CompositeProcessShouldHaveSubprocesses"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Process process = (Process)object;
        if (process.isComposite() && process.getDiagram().getProcessSet().size() < 1) {
            return CheckResult.createWarning(object, this, Messages.getString("DRCompositeProcessWithoutSubProcesses.ProcessDoesntHaveSubprocesses"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRCompositeProcessWithoutSubProcesses.ProcessHasSubprocesses"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "89DA96F1-ABCC-DC13-A2B3-5C8947E83930";
    }
}

