/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.logical;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.logical.DREntity;

public class DREntityNoRelation
extends DREntity {
    private final String RULE_ID = "DF577A80-6905-2C49-B330-25F59377A00B";

    public DREntityNoRelation() {
        this.setName(Messages.getString("DREntityNoRelation.IdentifyEntitiesWithoutRelationships"));
        this.setDescription(Messages.getString("DREntityNoRelation.EntitiesWithoutRelationshipsNotRecommended"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Entity entity = (Entity)object;
        this.setEntityToCheck(entity);
        Entity entityToCheck = this.getEntityToCheck();
        if (entity.getNumberOfNormalRelationConnections() > 0) {
            this.clearEntityToCheck();
            return CheckResult.createOk(entityToCheck, this, Messages.getString("DREntityNoRelation.EntityHasAtLeastOneRelationship"));
        }
        Entity superEntity = entity.getHierarchicalParent();
        if (superEntity != null) {
            return this.doCheck(superEntity);
        }
        this.clearEntityToCheck();
        return CheckResult.createWarning(entityToCheck, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "DF577A80-6905-2C49-B330-25F59377A00B";
    }
}

