/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.Collection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.RuleNode;

public abstract class DesignRule
implements RuleNode {
    public static final int TYPE_ERROR = 0;
    public static final int TYPE_WARNING = 1;
    public static final int TYPE_INFO = 2;
    private String contextString = "";
    private RuleHandler ruleHandler;
    private String name;
    private String description;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDescription(StringBuffer description) {
        this.setDescription(description.toString());
    }

    public String getDescription() {
        return this.description;
    }

    public abstract CheckResult doCheck(Object var1);

    public void collectCheckResults(Collection collection, Object object) {
        try {
            CheckResult result = this.doCheck(object);
            if (result != null && !result.isOk()) {
                collection.add(result);
            }
        }
        catch (Throwable t) {
            collection.add(CheckResult.createFailed(object, this, t.toString()));
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Object getElement(int index) {
        return null;
    }

    @Override
    public int getIndexFor(Object child) {
        return -1;
    }

    protected CheckResult createNoImplementationWarning(Object affected) {
        return CheckResult.createWarning(affected, this, new StringBuffer().append(this.getClass().getName()).append(Messages.getString("DesignRule.NotYetImplemented")).toString());
    }

    public void setContextString(String string) {
        this.contextString = string;
    }

    public String getContextString() {
        return this.contextString;
    }

    public abstract int getType();

    public RuleHandler getRuleHandler() {
        return this.ruleHandler;
    }

    public void setRuleHandler(RuleHandler ruleHandler) {
        this.ruleHandler = ruleHandler;
    }

    public abstract String getRuleId();

    public void init() {
    }
}

