/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import org.mozilla.javascript.Undefined;

public class DRCustomValidationScript
extends DRCustomScript {
    private RuleHandler ruleHandler;
    private Map<String, CompiledScript> m = new HashMap<String, CompiledScript>();

    public DRCustomValidationScript(String name, String ruleId, String purp) {
        super(name, ruleId, purp);
        this.ruleHandler = this.getRuleHandler();
    }

    public DRCustomValidationScript(String name, String ruleId, String purp, String object, String engine, String script, String variable, String resultType, RuleHandler ruleHandler, ScriptEngineManager scriptEngineManager, DRLibrary library, String function) {
        this(name, ruleId, purp);
        this.object = object;
        this.engineName = engine;
        this.script = script;
        this.variable = variable;
        this.resultType = resultType;
        this.ruleHandler = ruleHandler;
        this.scriptEngineManager = scriptEngineManager;
        this.library = library;
        this.function = function;
    }

    @Override
    public void init() {
        this.m.clear();
        this.eval = false;
        this.hasEvalError = false;
        this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CheckResult doCheck(Object object) {
        String string;
        Boolean valid = false;
        Object obj = null;
        Object ruleMessage = null;
        Object errType = null;
        try {
            CompiledScript script;
            if (this.engine == null) {
                this.engine = this.scriptEngineManager.getEngineByName(this.getEngineName());
            }
            if (this.engine == null) {
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EngineNotExist"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                return null;
            }
            this.engine.put(this.getVariable(), object);
            if (this.getLibrary() == null) {
                if (this.engine instanceof Compilable) {
                    script = this.m.get("cs");
                    if (script == null) {
                        this.compilingEngine = (Compilable)((Object)this.engine);
                        script = this.compilingEngine.compile(this.getScript());
                        this.m.put("cs", script);
                    }
                    obj = script.eval();
                } else {
                    obj = this.engine.eval(this.getScript());
                }
            } else if (this.engine instanceof Compilable) {
                script = this.m.get("cs");
                if (script == null) {
                    this.compilingEngine = (Compilable)((Object)this.engine);
                    script = this.compilingEngine.compile(this.getLibrary().getScript());
                    this.m.put("cs", script);
                }
                if (!(this.engine instanceof Invocable)) {
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EnginNotSupportingInvocable"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                    this.hasEvalError = true;
                    return null;
                }
                if (!this.eval) {
                    this.engine.eval(this.getLibrary().getScript());
                    this.eval = true;
                }
                Invocable invokeEngine = (Invocable)((Object)this.engine);
                obj = invokeEngine.invokeFunction(this.getFunction(), object);
            } else {
                if (!(this.engine instanceof Invocable)) {
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.EnginNotSupportingInvocable"), this.getEngineName()), Messages.getString("DRCustomScript.Error"), 0);
                    this.hasEvalError = true;
                    return null;
                }
                this.engine.eval(this.getLibrary().getScript());
                Invocable invokeEngine = (Invocable)((Object)this.engine);
                obj = invokeEngine.invokeFunction(this.getFunction(), object);
            }
            ruleMessage = this.engine.get("ruleMessage");
            errType = this.engine.get("errType");
        }
        catch (ScriptException ex) {
            JOptionPane.showMessageDialog(null, Messages.getString("DRCustomScript.EvaluateError") + "\n\nName     : " + this.getName() + "\n\nLine        : " + ex.getLineNumber() + "\nColumn   : " + ex.getColumnNumber() + "\nMessage : " + ex.getMessage(), Messages.getString("DRCustomScript.Error"), 0);
            this.hasEvalError = true;
            return null;
        }
        catch (NoSuchMethodException e) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("DRCustomScript.NoSuchMethod"), this.getFunction()), Messages.getString("DRCustomScript.Error"), 0);
            this.hasEvalError = true;
            return null;
        }
        if (obj instanceof Boolean) {
            valid = (Boolean)obj;
        }
        if (valid.booleanValue()) {
            return CheckResult.createOk(object, this, Messages.getString("DRCustomScript.ValidationOK"));
        }
        String rMsg = null;
        if (ruleMessage != null && ruleMessage instanceof String && !(ruleMessage instanceof Undefined)) {
            String string2 = rMsg = ((String)ruleMessage).trim().length() > 0 ? ((String)ruleMessage).trim() : null;
        }
        if (errType != null && errType instanceof String) {
            String string3;
            String eType = (String)errType;
            if (eType.equalsIgnoreCase("Warning")) {
                String string4;
                if (rMsg != null) {
                    string4 = rMsg;
                    return CheckResult.createWarning(object, this, string4);
                }
                string4 = this.getName();
                return CheckResult.createWarning(object, this, string4);
            }
            if (eType.equalsIgnoreCase("Error")) {
                String string5;
                if (rMsg != null) {
                    string5 = rMsg;
                    return CheckResult.createFailed(object, this, string5);
                }
                string5 = this.getName();
                return CheckResult.createFailed(object, this, string5);
            }
            if (rMsg != null) {
                string3 = rMsg;
                return CheckResult.createCustom(object, this, string3, eType);
            }
            string3 = this.getName();
            return CheckResult.createCustom(object, this, string3, eType);
        }
        if (this.getResultType().equals("Error")) {
            String string6;
            if (rMsg != null) {
                string6 = rMsg;
                return CheckResult.createFailed(object, this, string6);
            }
            string6 = this.getName();
            return CheckResult.createFailed(object, this, string6);
        }
        if (rMsg != null) {
            string = rMsg;
            return CheckResult.createWarning(object, this, string);
        }
        string = this.getName();
        return CheckResult.createWarning(object, this, string);
    }

    @Override
    public RuleHandler getRuleHandler() {
        return this.ruleHandler;
    }

    @Override
    public void setRuleHandler(RuleHandler ruleHandler) {
        this.ruleHandler = ruleHandler;
    }

    @Override
    public DRCustomValidationScript copy() {
        return new DRCustomValidationScript(this.name, this.ruleId, this.purpose, this.object, this.engineName, this.script, this.variable, this.resultType, this.ruleHandler, this.scriptEngineManager, this.library, this.function);
    }

    @Override
    public void collectCheckResults(Collection collection, Object object) {
        try {
            CheckResult result = this.doCheck(object);
            if (result != null && !result.isOk()) {
                collection.add(result);
            }
            if (result == null) {
                this.ruleHandler.hasEvalErr = true;
            }
        }
        catch (Throwable t) {
            collection.add(CheckResult.createFailed(object, this, t.toString()));
        }
    }
}

