/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.RuleHandler;

public class CompositeRuleHandler
extends RuleHandler {
    private static final Object[] RULEHANDLER_PROTO = new RuleHandler[0];
    private List composedList = new ArrayList();

    @Override
    public void addRule(DesignRule rule) {
        throw new IllegalArgumentException("CompositeRuleHandler just groups RuleHandlers, does not accept Rules");
    }

    public void add(RuleHandler ruleHandler) {
        if (!this.composedList.contains(ruleHandler)) {
            this.composedList.add(ruleHandler);
        }
    }

    public void remove(RuleHandler ruleHandler) {
        this.composedList.remove(ruleHandler);
    }

    public void clear() {
        this.composedList.clear();
    }

    @Override
    protected boolean canHandle(Object object) {
        RuleHandler[] handlers = (RuleHandler[])this.composedList.toArray(RULEHANDLER_PROTO);
        for (int i = 0; i < handlers.length; ++i) {
            if (!handlers[i].canHandle(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doHandle(Object object, Collection results) {
        RuleHandler[] handlers = (RuleHandler[])this.composedList.toArray(RULEHANDLER_PROTO);
        for (int i = 0; i < handlers.length; ++i) {
            if (!handlers[i].canHandle(object)) continue;
            handlers[i].doHandle(object, results);
        }
    }

    @Override
    public int size() {
        return this.composedList.size();
    }

    @Override
    public int getIndexFor(Object child) {
        return this.composedList.indexOf(child);
    }

    @Override
    public Object getElement(int index) {
        return this.composedList.get(index);
    }

    @Override
    public Collection applyRulesToSubject(Collection checkResults) {
        super.applyRulesToSubject(checkResults);
        for (RuleHandler rh : this.composedList) {
            rh.hasEvalErr = false;
            rh.applyRulesToSubject(checkResults);
            this.hasEvalErr = rh.hasEvalErr;
            if (!rh.hasEvalErr) continue;
            break;
        }
        return checkResults;
    }
}

