/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.undo.RemoveDO_Edit;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;

public class TopViewRemoveEdit
extends RemoveDO_Edit {
    protected DesignPartView dpv;
    protected DesignObject table;
    protected Rectangle rect;
    protected String viewID = "-200";
    protected Map settings;
    protected TopView topView;
    private int viewNumber;
    protected AbstractCellView cellView;
    private List savedConnectors = new ArrayList();

    public TopViewRemoveEdit(TopView topView) {
        super(topView.getModel());
        this.topView = topView;
        this.viewNumber = topView.getModel().getViewNumber(topView);
        this.table = topView.getModel();
        topView.synchronizeBoundsWithCellView();
        this.rect = topView.getBounds();
        this.dpv = topView.getDesignPartView();
        this.settings = this.dpv.getApplicationView().getGraphicalPropsFor(topView);
        this.viewID = topView.getViewID();
        this.cellView = topView.getCellView();
        if (topView.getModel() instanceof MultiShapedDesignObject) {
            this.saveConnectorTopViews(topView.getDesignPartView().getTVConnectorsFor(topView), this.savedConnectors);
        }
    }

    @Override
    public String getRedoPresentationName() {
        return MessageFormat.format(Messages.getString("TopViewRemoveEdit.RedoRemoveViewFor"), this.topView.getModel().getLongName());
    }

    @Override
    public String getUndoPresentationName() {
        return MessageFormat.format(Messages.getString("TopViewRemoveEdit.UndoRemoveViewFor"), this.topView.getModel().getLongName());
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    protected void removeObject() {
        if (this.topView instanceof ContainerView) {
            ((ContainerView)this.topView).remove(false);
        }
    }

    @Override
    protected void restoreObject() {
        if (this.topView.getCellView() == null) {
            this.topView.setCellView(this.cellView);
        }
        this.dpv.getApplicationView().setGraphicalPropsFor(this.topView, this.settings);
        this.dpv.restoreTopview(this.topView, this.table);
        if (this.table instanceof MultiShapedDesignObject) {
            ((MultiShapedDesignObject)this.table).moveViewToPosition(this.topView, this.viewNumber);
        }
        this.topView.setViewID(this.viewID);
        if (this.topView.getModel() instanceof MultiShapedDesignObject) {
            this.restoreConnectorTopViews(this.savedConnectors);
        }
    }

    public static void addUndoableRemoveEditForObject(CompoundEdit target, TopView object) {
        TopViewRemoveEdit edit = null;
        if (object instanceof ContainerView) {
            edit = new TopViewRemoveEdit(object);
        }
        if (edit != null) {
            if (edit instanceof CompoundEdit) {
                ((CompoundEdit)edit).end();
            }
            target.addEdit(edit);
        }
    }
}

