/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.undo.UpdateDO_Edit;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;

public class ShowHideElementsEdit
extends UpdateDO_Edit {
    Object[] topViews;
    List dpvs = new ArrayList();
    List savedItems = new ArrayList();
    List hiddenElements;
    boolean hideElementsInCurrentViewOnly;

    public ShowHideElementsEdit(Object[] topViews, boolean hideElementsInCurrentViewOnly, List hiddenElements) {
        super(((TopView)topViews[0]).getModel());
        this.topViews = hideElementsInCurrentViewOnly ? topViews : this.getAllTopViews(topViews);
        this.hiddenElements = hiddenElements;
        this.hideElementsInCurrentViewOnly = hideElementsInCurrentViewOnly;
        this.saveState();
    }

    @Override
    protected void restoreObject() {
        for (TVWrap wr : this.savedItems) {
            wr.tv.setHideElementsInCurrentOnly(wr.hideElementsInCurrentViewOnly);
            wr.tv.getHiddenElements().clear();
            wr.tv.getHiddenElements().addAll(wr.hiddenElements);
        }
    }

    private void saveState() {
        for (int i = 0; i < this.topViews.length; ++i) {
            TopView topView = (TopView)this.topViews[i];
            TVWrap wr = new TVWrap();
            wr.tv = topView;
            wr.hideElementsInCurrentViewOnly = topView.isHideElementsInCurrentOnly();
            wr.hiddenElements = topView.getHiddenElements();
            this.savedItems.add(wr);
        }
    }

    @Override
    public void applyUpdates() {
        TopView topView;
        int i;
        if (this.hideElementsInCurrentViewOnly) {
            for (i = 0; i < this.topViews.length; ++i) {
                topView = (TopView)this.topViews[i];
                topView.setHideElementsInCurrentOnly(true);
                topView.getHiddenElements().clear();
                topView.getHiddenElements().addAll(this.hiddenElements);
            }
        } else {
            for (i = 0; i < this.topViews.length; ++i) {
                topView = (TopView)this.topViews[i];
                topView.setHideElementsInCurrentOnly(false);
                topView.getHiddenElements().clear();
                topView.getHiddenElements().addAll(this.hiddenElements);
            }
        }
        if (this.topViews.length > 0) {
            for (DesignPartView dpv : this.dpvs) {
                dpv.repaint();
            }
        }
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo Show / Hide Elements in " + ((TopView)this.topViews[0]).getModel().toString();
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo Show / Hide Elements in " + ((TopView)this.topViews[0]).getModel().toString();
    }

    private Object[] getAllTopViews(Object[] tviews) {
        ArrayList<TopView> list = new ArrayList<TopView>();
        for (int i = 0; i < tviews.length; ++i) {
            TopView topView = (TopView)tviews[i];
            DesignObject dobj = topView.getModel();
            if (dobj instanceof MultiShapedDesignObject) {
                list.addAll(((MultiShapedDesignObject)dobj).getAllTopViews());
                continue;
            }
            list.add(topView);
        }
        for (TopView topView : list) {
            if (this.dpvs.contains(topView.getDesignPartView())) continue;
            this.dpvs.add(topView.getDesignPartView());
        }
        return list.toArray();
    }

    class TVWrap {
        TopView tv;
        List hiddenElements = new ArrayList();
        boolean hideElementsInCurrentViewOnly;

        TVWrap() {
        }
    }
}

