/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.undo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CompoundEdit;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.relational.FKColumnPreserver;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultPort;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class DesignObjectEdit
extends CompoundEdit {
    public static boolean UNDOABLE_ADD = false;
    private static final Logger LOGGER = new Logger(DesignObjectEdit.class);

    @Override
    public boolean isSignificant() {
        return true;
    }

    protected void saveShapedTopViews(MultiShapedDesignObject object, List savedItems) {
        for (TopView tv : object.getAllTopViews()) {
            ShapedStore store = this.backupShapedTopView(tv);
            savedItems.add(store);
        }
    }

    protected ShapedStore backupShapedTopView(TopView tv) {
        ShapedStore store = new ShapedStore();
        store.hasCellview = tv.getCellView() != null;
        store.celView = tv.getCellView();
        tv.synchronizeBoundsWithCellView();
        store.settings = tv.getApplicationView().getGraphicalPropsFor(tv);
        store.topView = tv;
        store.viewID = tv.getViewID();
        return store;
    }

    protected void restoreShapedTopViews(MultiShapedDesignObject object, List savedItems) {
        for (ShapedStore store : savedItems) {
            this.restoreShapedTopView(store);
        }
    }

    protected void restoreShapedTopView(ShapedStore store) {
        MultiShapedDesignObject object = (MultiShapedDesignObject)store.topView.getModel();
        store.topView.getApplicationView().setGraphicalPropsFor(store.topView, store.settings);
        store.topView.synchronizeBoundsWithCellView();
        store.topView.setViewID(store.viewID);
        store.topView.getDesignPartView().restoreTopview(store.topView, object);
    }

    public void saveFonts(TopView tv, List savedItems) {
        for (FontObject fo : tv.getEditableFonts()) {
            FontStore fs = new FontStore();
            fs.objectType = fo.getType();
            fs.fontName = fo.getFont().getName();
            fs.fontSize = fo.getFont().getSize();
            fs.fontStyle = fo.getFont().getStyle();
            fs.fontColor = fo.getColor().getRGB();
            fs.fontEnabled = fo.isFontEnabled();
            savedItems.add(fs);
        }
    }

    public void restoreFonts(TopView tv, List savedItems) {
        Iterator it = savedItems.iterator();
        List efonts = tv.getEditableFonts();
        efonts.clear();
        while (it.hasNext()) {
            FontStore fs = (FontStore)it.next();
            Font font = new Font(fs.fontName, fs.fontStyle, fs.fontSize);
            FontObject fo = new FontObject(fs.objectType, font, new Color(fs.fontColor), fs.fontEnabled);
            efonts.add(fo);
        }
    }

    public void saveConnectorTopViews(ConnectionInterface ci, List savedItems) {
        for (TVConnector tv : ci.getAllViews()) {
            ConnectorStore cs = this.backupTVConnector(tv);
            savedItems.add(cs);
        }
    }

    public void saveConnectorTopViews(List tvConnectors, List savedItems) {
        for (TVConnector tv : tvConnectors) {
            ConnectorStore cs = this.backupTVConnector(tv);
            savedItems.add(cs);
        }
    }

    public ConnectorStore backupTVConnector(TVConnector tv) {
        ConnectorStore cs = new ConnectorStore();
        cs.topView = tv;
        cs.sourceTV = tv.getSourceTopView();
        cs.targetTV = tv.getTargetTopView();
        if (tv != null && tv.getEdge() != null && tv.getEdge().getCellView() != null) {
            cs.edge = tv.getEdge();
            cs.sourceP = (DefaultPort)tv.getEdge().getSource();
            cs.targetP = (DefaultPort)tv.getEdge().getTarget();
            cs.hasCell = true;
            Hashtable map = new Hashtable(tv.getEdge().getCellView().getAttributes());
            cs.attributes = new Hashtable();
            cs.attributes.put(cs.edge, map);
            List edgePoints = ((EdgeView)tv.getEdge().getCellView()).getPoints();
            for (int i = 1; i < edgePoints.size() - 1; ++i) {
                Point2D p = (Point2D)edgePoints.get(i);
                cs.points.add(DiagramConstants.createPoint(p.getX(), p.getY()));
            }
        } else if (tv != null) {
            List edgePoints = tv.getEdgePoints();
            for (int i = 0; i < edgePoints.size(); ++i) {
                Point2D p = (Point2D)edgePoints.get(i);
                cs.points.add(DiagramConstants.createPoint(p.getX(), p.getY()));
            }
        }
        this.backupLabels(tv, cs.labels);
        cs.restoreLabels = true;
        return cs;
    }

    private void backupLabels(TVConnector tv, List savedItems) {
        for (Label label : tv.getLabels()) {
            LabelStore ls = new LabelStore();
            ls.label = label;
            ls.topView = label.getFirstViewForDPV(tv.getDesignPartView());
            if (ls.topView != null) {
                ls.topView.synchronizeBoundsWithCellView();
            }
            ls.site = label.getSite();
            ls.bounds = new Rectangle(tv.getLabelBoundsFor(ls.site));
            ls.useDefaultColor = label.useDefaultColor();
            ls.fgColor = label.getForegroundColor();
            ls.bgColor = label.getBackgroundColor();
            this.saveFonts(label.getTopView(), ls.fonts);
            savedItems.add(ls);
        }
    }

    private void restoreLabels(TVConnector tv, List savedItems) {
        for (LabelStore ls : savedItems) {
            tv.setLabel(ls.label, ls.site);
            tv.setLabelBoundsFor(ls.bounds, ls.site);
            if (ls.useDefaultColor) {
                ls.label.setUseDefaultColor(true);
                ls.label.setBackgroundColor(null);
                ls.label.setForegroundColor(null);
            } else {
                ls.label.setUseDefaultColor(false);
                ls.label.setBackgroundColor(ls.bgColor);
                ls.label.setForegroundColor(ls.fgColor);
            }
            if (ls.topView != null) {
                ls.topView.setModel(ls.label);
            }
            if (ls.topView == null || ls.topView.getCellView() == null || ls.topView.getCellView().getCell() == null) continue;
            DefaultDiagramCell cell = (DefaultDiagramCell)ls.topView.getCellView().getCell();
            if (ls.topView.getDesignPartView().getWorkSpace().getModel().contains(cell)) continue;
            ls.topView.getDesignPartView().getWorkSpace().addContainer(cell, ls.bounds);
        }
        tv.displayLabels();
    }

    public void restoreConnectorTopViews(ConnectionInterface ci, List savedItems) {
        for (ConnectorStore cs : savedItems) {
            this.restoreConnectorTopView(ci, cs);
        }
    }

    public void restoreConnectorTopViews(List savedItems) {
        for (ConnectorStore cs : savedItems) {
            this.restoreConnectorTopView((ConnectionInterface)((Object)cs.topView.getModel()), cs);
        }
    }

    public void restoreConnectorTopView(ConnectionInterface ci, ConnectorStore cs) {
        ci.restoreTopView(cs.topView, cs.sourceTV, cs.targetTV);
        if (cs.topView.getCellView() != null) {
            cs.topView.getDesignPartView().getWorkSpace().removeCells(new Object[]{cs.topView.getCellView().getCell()});
            for (Label label : cs.topView.getLabels()) {
                cs.topView.getDesignPartView().getWorkSpace().removeLabel(label);
            }
        }
        if (cs.edge != null && cs.sourceTV.getCellView() != null && cs.targetTV.getCellView() != null) {
            boolean str = false;
            ((DefaultDiagramCell)cs.sourceTV.getCellView().getCell()).add(cs.sourceP);
            ((DefaultDiagramCell)cs.targetTV.getCellView().getCell()).add(cs.targetP);
            if (cs.topView.getDesignPartView().isAutoRoute()) {
                cs.topView.getDesignPartView().getWorkSpace().restoreConnection(cs.edge, cs.sourceP, cs.targetP, cs.attributes);
            } else {
                cs.topView.getDesignPartView().getWorkSpace().restoreConnection(cs.edge, cs.sourceP, cs.targetP, cs.attributes);
                if (cs.points.size() == 0) {
                    str = true;
                }
            }
            cs.topView.setCellView(cs.edge.getCellView());
            if (str) {
                cs.edge.straightLine(false);
            }
        }
        this.restoreLabels(cs.topView, cs.labels);
    }

    public void saveMappings(DesignObject object, List savediItems) {
        MappingWr wr = new MappingWr();
        wr.object = object;
        savediItems.add(wr);
        DesignPart dp = object.getDesignPart();
        if (dp instanceof RelationalDesign) {
            wr.mappings.addAll(((RelationalDesign)dp).getRMExtendedMap().getOrCreateCollector(object).getAllMappings());
        } else {
            wr.mappings.addAll(object.getDesign().getExtendedMap().getOrCreateCollector(object).getAllMappings());
        }
    }

    public void restoreMappings(List savediItems) {
        for (MappingWr wr : savediItems) {
            for (XtdMapping mapping : wr.mappings) {
                boolean a;
                if (wr.object.getObjectID().equals(mapping.getDeletedID())) {
                    DesignPart dp = wr.object.getDesignPart();
                    if (dp instanceof RelationalDesign) {
                        ((RelationalDesign)dp).getRMExtendedMap().restoreDeletedMapping(mapping, wr.object);
                        continue;
                    }
                    wr.object.getDesign().getExtendedMap().restoreDeletedMapping(mapping, wr.object);
                    continue;
                }
                boolean b = a = false;
            }
        }
    }

    public FKProperties backupFK(FKIndexAssociation fk, boolean savearc) {
        FKProperties props = new FKProperties();
        props.fk = fk;
        props.name = fk.getName();
        props.comments = fk.getComment();
        props.notes = fk.getNotes();
        props.mandatory = fk.isMandatory();
        props.generate_in_DDL = fk.isMarkedGenerate();
        props.transferable = fk.isTransferable();
        props.table = (FKContainer)fk.getContainerWithKeyObject();
        props.remoteTable = fk.getRemoteTable();
        try {
            props.remoteKey = fk.getRemoteIndex().getObjectID();
        }
        catch (Exception e) {
            LOGGER.error("No remote Index for foreign key " + fk.getName(), e);
        }
        props.deleteRule = fk.getDeleteRule();
        props.id = fk.getObjectID();
        props.index_id = fk.getLocalFKIndex().getObjectID();
        props.index_name = fk.getLocalFKIndex().getName();
        if (savearc) {
            props.arc = fk.getArc();
            if (props.arc != null && props.arc.getFkeys().size() == 2) {
                props.arcBackup = this.backupFKArc(props.arc);
            }
        }
        this.backupFKColumns(fk, props.columns);
        this.saveConnectorTopViews(fk, (List)props.views);
        this.saveMappings(fk, props.fk_mappings);
        return props;
    }

    protected void backupFKColumns(FKIndexAssociation fk, List savedItems) {
        for (FKElement col : fk.getLocalFKIndex().getElementsCollection()) {
            FKElement refcol = col.getReferencedColumn(fk);
            if (col == null || refcol == null) continue;
            DelegateWr wr = new DelegateWr();
            wr.columnID = col.getObjectID();
            wr.delegateID = refcol.getObjectID();
            if (fk.canRemoveColumnAutomaticaly(col)) {
                wr.preserver = new FKColumnPreserver();
                wr.preserver.preserve(col);
            }
            savedItems.add(wr);
        }
    }

    public FKIndexAssociation restoreFK(FKProperties props) {
        FKIndexAssociation fk = props.fk;
        fk.setName(props.name);
        fk.setComment(props.comments);
        fk.setNotes(props.notes);
        fk.setMarkedGenerate(props.generate_in_DDL);
        fk.setDeleteRule(props.deleteRule);
        fk.setObjectID(props.id);
        fk.setKeyObject((KeyObject)props.remoteTable.getKeySet().getObjectByID(props.remoteKey));
        props.table.restoreFKAssociation(fk, props.index_id);
        fk.getLocalFKIndex().setName(props.index_name);
        this.restoreFKColumns(fk, props.table, props.remoteTable, props.columns);
        fk.setMandatory(props.mandatory);
        this.restoreConnectorTopViews(fk, props.views);
        if (props.arc != null) {
            props.arc.addFkey(fk);
            if (props.arcBackup != null && props.table instanceof FKContainer) {
                this.restoreFKArc(props.arcBackup, props.table);
            }
        }
        this.restoreMappings(props.fk_mappings);
        fk.addToAllDPVs();
        this.changeSavedDeleteStatus(fk);
        return fk;
    }

    protected void restoreFKColumns(FKIndexAssociation fk, FKContainer table, FKContainer remoteTable, List savedItems) {
        for (DelegateWr wr : savedItems) {
            FKElement col = (FKElement)table.getElementByID(wr.columnID);
            if (col == null && wr.preserver != null) {
                wr.preserver.restore();
                col = (FKElement)table.getElementByID(wr.columnID);
            }
            FKElement refcol = (FKElement)remoteTable.getElementByID(wr.delegateID);
            if (col == null) continue;
            if (refcol != null) {
                col.addFKAssociation(refcol, fk);
            }
            fk.getLocalFKIndex().add(col);
        }
    }

    public FKArcProps backupFKArc(FKArc arc) {
        FKArcProps wr = new FKArcProps();
        wr.arc = arc;
        wr.id = arc.getObjectID();
        wr.comments = arc.getComment();
        wr.notes = arc.getNotes();
        wr.inDDL = arc.isMarkedGenerate();
        wr.mandatory = arc.isMandatory();
        wr.isReverse = arc.isReverse();
        for (DesignObject dob : arc.getFkeys()) {
            wr.used_fkeys.add(dob.getObjectID());
        }
        this.saveShapedTopViews(arc, wr.arcViews);
        this.saveMappings(arc, wr.mappings);
        return wr;
    }

    public void restoreFKArc(FKArcProps wr, FKContainer table) throws RuntimeException {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        for (String fkid : wr.used_fkeys) {
            FKIndexAssociation fk = (FKIndexAssociation)((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getObjectByID(fkid);
            if (fk != null) {
                if (wr.arc.isReverse()) {
                    if (fk.getRemoteTable() != table) continue;
                    list.add(fk);
                    continue;
                }
                if (fk.getContainerWithKeyObject() == table) {
                    list.add(fk);
                    continue;
                }
                throw new RuntimeException(MessageFormat.format(Messages.getString("DesignObjectEdit.ForeignKeyDoesntBelongToTable"), fk.getLongName(), table.getName()));
            }
            throw new RuntimeException(MessageFormat.format(Messages.getString("DesignObjectEdit.MissingFK"), fkid));
        }
        if (list.size() < 2) {
            throw new RuntimeException(Messages.getString("DesignObjectEdit.NotEnoughFKToCreateArc"));
        }
        FKArc arc = wr.arc;
        arc.setObjectID(wr.id);
        arc.setComment(wr.comments);
        arc.setNotes(wr.notes);
        arc.setMandatory(wr.mandatory);
        arc.setMarkedGenerate(wr.inDDL);
        table.addArc(arc);
        arc.setReverse(wr.isReverse);
        for (FKIndexAssociation fkey : list) {
            arc.addFkey(fkey);
        }
        table.getDesign().addDesignObject(arc);
        ((RelationalDesign)table.getDesignPart()).getArcSet().add(arc);
        this.restoreShapedTopViews(arc, wr.arcViews);
        this.restoreMappings(wr.mappings);
    }

    public TableProps backupTable(Table table) {
        TableProps pr = new TableProps();
        pr.phdes = (RelationalDesign)table.getDesignPart();
        pr.created = table;
        pr.removed = new Table(table.getDesignPart());
        pr.created.backupTo(pr.removed);
        this.saveShapedTopViews(pr.created, pr.topViews);
        this.saveFKeys(pr.created, pr.fkeys, pr.mappings);
        this.saveArcs(pr.created, pr.arcs);
        for (DesignObject object : this.getTableObjects(pr.created)) {
            this.saveMappings(object, pr.mappings);
        }
        this.saveFonts(table.getTopView(), pr.fonts);
        return pr;
    }

    private List getTableObjects(Table table) {
        ArrayList<ContainerObject> list = new ArrayList<ContainerObject>();
        list.add(table);
        list.addAll(table.getElementsCollectionImmutable());
        Iterator it = table.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            list.add(index);
        }
        return list;
    }

    public void restoreTable(TableProps pr) {
        pr.phdes.getDesign().addDesignObject(pr.created);
        pr.created.setDesignObjectSet(pr.phdes.getTableSet());
        pr.removed.restoreTo(pr.created);
        this.restoreShapedTopViews(pr.created, pr.topViews);
        this.restoreFKeys(pr.created, pr.fkeys);
        this.restoreArcs(pr.arcs, pr.created);
        this.restoreContainedInMappingWrs(pr.created, pr.mappings);
        this.restoreMappings(pr.mappings);
        this.restoreFonts(pr.created.getTopView(), pr.fonts);
        pr.phdes.getTableSet().add(pr.created);
    }

    private void restoreContainedInMappingWrs(Table table, List mappings) {
        for (MappingWr wr : mappings) {
            if (wr.object instanceof Table) continue;
            DesignObject obj = (DesignObject)table.getLocalObject(wr.object.getObjectID());
            if (obj == null && wr.object instanceof KeyObject) {
                obj = table.getKeySet().getObjectByID(wr.object.getObjectID());
            }
            if (obj == null) continue;
            wr.object = obj;
        }
    }

    private void saveFKeys(FKContainer table, List fkeys, List mappings) {
        for (FKIndexAssociation fk : ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(table)) {
            FKProperties props = this.backupFK(fk, true);
            FKContainer cont = fk.getTable();
            KeyObject index = fk.getLocalFKIndex();
            props.indexPos = cont.getKeySet().getIndexOf(index);
            fkeys.add(props);
            this.saveMappings(fk, mappings);
        }
        FKIndexAssociation[] fks = table.getFKAssociations();
        for (int i = 0; i < fks.length; ++i) {
            FKIndexAssociation fk = fks[i];
            FKProperties props = this.backupFK(fk, false);
            FKContainer cont = fk.getTable();
            KeyObject index = fk.getLocalFKIndex();
            props.indexPos = cont.getKeySet().getIndexOf(index);
            fkeys.add(props);
            this.saveMappings(fks[i], mappings);
        }
    }

    private void restoreFKeys(FKContainer table, List savedItems) {
        FKProperties props;
        int i;
        for (i = 0; i < savedItems.size(); ++i) {
            props = (FKProperties)savedItems.get(i);
            this.restoreFK(props);
        }
        for (i = 0; i < savedItems.size(); ++i) {
            props = (FKProperties)savedItems.get(i);
            if (props.indexPos <= -1) continue;
            KeyObject index = props.fk.getLocalFKIndex();
            props.table.getKeySet().moveElementTo(index, props.indexPos);
        }
    }

    private void saveArcs(FKContainer table, List savedItems) {
        for (FKArc arc : table.getArcs()) {
            FKArcProps wr = this.backupFKArc(arc);
            savedItems.add(wr);
        }
    }

    private void restoreArcs(List savedItems, FKContainer table) {
        for (FKArcProps wr : savedItems) {
            this.restoreFKArc(wr, table);
        }
    }

    private void saveSQLNames(List savedSQLNames, AbstractView view) {
        savedSQLNames.clear();
        for (SQLNameHelper hlp : view.getSQLNames()) {
            savedSQLNames.add(hlp.clone());
        }
    }

    private void restoreSQLNames(List savedSQLNames, AbstractView view) {
        List targetSQLNames = view.getSQLNames();
        targetSQLNames.clear();
        for (SQLNameHelper hlp : savedSQLNames) {
            targetSQLNames.add(hlp.clone());
        }
    }

    public TableViewProps backupTableView(TableView tableView) {
        TableViewProps pr = new TableViewProps();
        pr.phdes = (RelationalDesign)tableView.getDesignPart();
        pr.created = tableView;
        pr.removed = new TableView(tableView.getDesignPart());
        pr.created.backupTo(pr.removed);
        this.saveFKeys(pr.created, pr.fkeys, pr.mappings);
        this.saveArcs(pr.created, pr.arcs);
        this.saveMappings(tableView, pr.mappings);
        this.saveShapedTopViews(pr.created, pr.topViews);
        this.saveSQLNames(pr.sqlNames, tableView);
        return pr;
    }

    public void restoreTableView(TableViewProps pr) {
        pr.phdes.getDesign().addDesignObject(pr.created);
        pr.phdes.getTableViewSet().add(pr.created);
        pr.removed.restoreTo(pr.created);
        this.restoreShapedTopViews(pr.created, pr.topViews);
        this.restoreFKeys(pr.created, pr.fkeys);
        this.restoreArcs(pr.arcs, pr.created);
        this.restoreMappings(pr.mappings);
        this.restoreShapedTopViews(pr.created, pr.topViews);
        this.restoreSQLNames(pr.sqlNames, pr.created);
    }

    protected void changeSavedDeleteStatus(ModelIDObject obj) {
        DesignPart dp;
        if (obj instanceof DesignObject && (dp = ((DesignObject)obj).getDesignPart()) != null && !dp.existsInFilesMap(obj.getObjectID())) {
            obj.setRestoredFromSavedDelete(true);
        }
    }

    public class MappingWr {
        public List mappings = new ArrayList();
        public DesignObject object;
    }

    public class TableViewProps {
        public TableView removed;
        public TableView created;
        public RelationalDesign phdes;
        public List topViews = new ArrayList();
        public List mappings = new ArrayList();
        public List fkeys = new ArrayList();
        public List arcs = new ArrayList();
        public List sqlNames = new ArrayList();
    }

    public class FKArcProps {
        List arcViews = new ArrayList();
        public FKArc arc;
        String id;
        boolean mandatory;
        boolean inDDL;
        boolean isReverse;
        String comments;
        String notes;
        List used_fkeys = new ArrayList();
        List mappings = new ArrayList();
    }

    public class TableProps {
        public Table removed;
        public Table created;
        public RelationalDesign phdes;
        public List topViews = new ArrayList();
        public List fkeys = new ArrayList();
        public List mappings = new ArrayList();
        public List arcs = new ArrayList();
        List fonts = new ArrayList();
    }

    class DelegateWr {
        String columnID;
        String delegateID;
        FKElement backup;
        FKColumnPreserver preserver;

        DelegateWr() {
        }
    }

    public class FKProperties {
        FKIndexAssociation fk;
        String comments = "";
        String notes = "";
        String name;
        String index_name;
        String id;
        String index_id;
        boolean mandatory;
        boolean transferable;
        boolean generate_in_DDL;
        FKContainer table;
        FKContainer remoteTable;
        String remoteKey;
        List columns = new ArrayList();
        String deleteRule = "";
        ArrayList views = new ArrayList();
        ArrayList fk_mappings = new ArrayList();
        FKArc arc;
        FKArcProps arcBackup;
        int indexPos = -1;
    }

    protected class LabelStore {
        Label label;
        TopView topView;
        int site;
        boolean useDefaultColor;
        Color fgColor;
        Color bgColor;
        Rectangle bounds;
        List fonts = new ArrayList();

        protected LabelStore() {
        }
    }

    public class ConnectorStore {
        TVConnector topView;
        TopView sourceTV;
        TopView targetTV;
        String sourceVID;
        String targetVID;
        List points = new ArrayList();
        List labels = new ArrayList();
        Map attributes;
        DefaultEdge edge;
        ConnectionSet cset;
        DefaultPort sourceP;
        DefaultPort targetP;
        boolean hasCell = false;
        boolean restoreLabels = false;
    }

    protected class FontStore {
        String objectType;
        String fontName;
        int fontColor;
        int fontSize;
        int fontStyle;
        boolean fontEnabled;

        protected FontStore() {
        }
    }

    protected class ShapedStore {
        TopView topView;
        Map settings;
        boolean hasCellview = false;
        String viewID = "-200";
        AbstractCellView celView;

        protected ShapedStore() {
        }
    }
}

