/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.ContainerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableSpacePropertyDialogUDBv81;

public class TableSpaceUDBv81
extends TableSpaceUDB {
    public static final String AUTOMATIC_STORAGE = "AUTOMATIC STORAGE";
    private static String[] availableManagedByTypes = new String[]{"SYSTEM", "DATABASE", "AUTOMATIC STORAGE"};
    public static final String DATATYPE_LARGE = "LARGE";
    protected static String[] availableDataTypes = new String[]{"REGULAR", "LARGE", "SYSTEM TEMPORARY", "USER TEMPORARY"};

    public TableSpaceUDBv81(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public static Object[] getAvailableManagedByTypes() {
        return availableManagedByTypes;
    }

    public static String[] getAvailableDataTypes() {
        return availableDataTypes;
    }

    @Override
    public void setPrefetchSize(String numberOfPages) {
        if (this.checkPrefetchSize(numberOfPages)) {
            this.prefetchSize = numberOfPages;
        }
    }

    @Override
    protected boolean checkPrefetchSize(String prefetch) {
        if ("AUTOMATIC".equalsIgnoreCase(prefetch)) {
            return true;
        }
        return super.checkPrefetchSize(prefetch);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableSpacePropertyDialogUDBv81 dialog = new TableSpacePropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableSpaceUDBv81 tableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                tableSpace = (TableSpaceUDBv81)stObject;
            }
        } else {
            tableSpace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpace != null) {
            tableSpace.setName(this.getName());
            for (int i = 0; i < this.getContainers().length; ++i) {
                ContainerUDBv81 container = (ContainerUDBv81)this.getContainers()[i];
                ContainerUDBv81 targetContainer = (ContainerUDBv81)((StorageDesignUDBv81)targetDesign).getContainerSet().getByName(container.getName());
                if (targetContainer == null) {
                    ContainerUDBv81 newContainer = (ContainerUDBv81)((StorageDesignUDBv81)targetDesign).getContainerSet().createContainer();
                    newContainer.setName(container.getName());
                    newContainer.setTableSpace(tableSpace);
                    newContainer.setRawObject(true);
                    ((StorageDesignUDBv81)targetDesign).getContainerSet().add(newContainer);
                    tableSpace.addContainersFromDesign(((StorageDesignUDBv81)targetDesign).getContainerSet());
                    continue;
                }
                targetContainer.setTableSpace(tableSpace);
                ((StorageDesignUDBv81)targetDesign).getContainerSet().add(container);
                tableSpace.addContainersFromDesign(((StorageDesignUDBv81)targetDesign).getContainerSet());
            }
            tableSpace.setDBDefOnly(this.getDBDefOnly());
            tableSpace.setManagedBy(this.getManagedBy());
            tableSpace.setAutoResize(this.getAutoResize());
            tableSpace.setInitialSize(this.getInitialSize());
            tableSpace.setIncreaseSize(this.getIncreaseSize());
            tableSpace.setMaxSize(this.getMaxSize());
            tableSpace.setDataType(this.getDataType());
            if (this.getNodeGroup() != null) {
                NodeGroupUDB nodeGroup = (NodeGroupUDB)((StorageDesignUDBv81)targetDesign).getNodeGroupSet().getByName(this.getNodeGroup().getName());
                if (nodeGroup == null) {
                    NodeGroupUDB newNodeGroup = ((StorageDesignUDBv81)targetDesign).getNodeGroupSet().createNodeGroup();
                    newNodeGroup.setName(this.getNodeGroup().getName());
                    newNodeGroup.setRawObject(true);
                    tableSpace.setNodeGroup(newNodeGroup);
                } else {
                    tableSpace.setNodeGroup(nodeGroup);
                }
            }
            tableSpace.setPageSize(this.getPageSize());
            tableSpace.setExtentSize(this.getExtentSize());
            tableSpace.setPrefetchSize(this.getPrefetchSize());
            if (this.getBufferPool() != null) {
                BufferPoolUDBv81 bufferPool = (BufferPoolUDBv81)((StorageDesignUDBv81)targetDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (bufferPool == null) {
                    BufferPoolUDBv81 newBufferPool = (BufferPoolUDBv81)((StorageDesignUDBv81)targetDesign).getBufferPoolSet().createBufferPool();
                    newBufferPool.setName(this.getBufferPool().getName());
                    newBufferPool.setRawObject(true);
                    tableSpace.setBufferPool(newBufferPool);
                } else {
                    tableSpace.setBufferPool(bufferPool);
                }
            }
            tableSpace.setOverhead(this.getOverhead());
            tableSpace.setTransferRate(this.getTransferRate());
            tableSpace.setDroppedTableRecovery(this.getDroppedTableRecovery());
            tableSpace.setFileSystemCaching(this.getFileSystemCaching());
            tableSpace.recreateUserSet(this.getUserSet().toString());
            tableSpace.recreateUserGroupSet(this.getUserGroupSet().toString());
            tableSpace.setGrantOption(this.getGrantOption());
            tableSpace.setComment(this.getComment());
            tableSpace.setCommentInRDBMS(this.getCommentInRDBMS());
            tableSpace.setRawObject(false);
        }
    }
}

