/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.IndexPropertyDialogUDBv81;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyUDBv81
extends IndexProxyUDB
implements PropertiesPropagator {
    protected String collectStatistics = "NONE";
    public static final String NONE = "NONE";
    public static final String BASIC = "BASIC";
    public static final String DETAILED = "DETAILED";
    public static final String SAMPLED_DETAILED = "SAMPLED DETAILED";
    public static final String[] COLLECT_STATISTICS_STATES = new String[]{"NONE", "BASIC", "DETAILED", "SAMPLED DETAILED"};
    private static Set collectStatisticsSet = null;
    private List propertyWrapperList = null;
    private boolean partitioned = true;
    private TableSpaceUDB inTablespace = null;
    private String xmlPattern = "";
    private String xmlType = "";
    public static final String XML_TYPE_VARCHAR = "VARCHAR";
    public static final String XML_TYPE_DOUBLE = "DOUBLE";
    public static final String XML_TYPE_DATE = "DATE";
    public static final String XML_TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String XML_QUAL_HASHED = "HASHED";

    public IndexProxyUDBv81(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyUDBv81(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    protected boolean checkCollectStatistics(String value) {
        if (collectStatisticsSet == null) {
            collectStatisticsSet = new HashSet();
            collectStatisticsSet.addAll(Arrays.asList(COLLECT_STATISTICS_STATES));
        }
        return collectStatisticsSet.contains(value);
    }

    public String getCollectStatistics() {
        return this.collectStatistics;
    }

    public void setCollectStatistics(String collectStatistics) {
        if (this.checkCollectStatistics(collectStatistics)) {
            this.collectStatistics = collectStatistics;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void setPartitioned(boolean partitioned) {
        if (this.getStorageDesign() instanceof StorageDesignUDBv9) {
            this.partitioned = partitioned;
        }
    }

    public boolean getPartitioned() {
        return this.partitioned;
    }

    public void setInTablespace(TableSpaceUDB tablespace) {
        if (this.getStorageDesign() instanceof StorageDesignUDBv9) {
            this.inTablespace = tablespace;
        }
    }

    public TableSpaceUDB getInTablespace() {
        return this.inTablespace;
    }

    public void setXmlPattern(String xmlPattern) {
        if (this.getStorageDesign() instanceof StorageDesignUDBv9) {
            this.xmlPattern = xmlPattern;
        }
    }

    public String getXmlPattern() {
        return this.xmlPattern;
    }

    public void setXmlType(String xmlType) {
        if (this.getStorageDesign() instanceof StorageDesignUDBv9 && this.checkXmlType(xmlType)) {
            this.xmlType = xmlType;
        }
    }

    public String getXmlType() {
        return this.xmlType;
    }

    public boolean checkXmlType(String xmlType) {
        String dt = Token.getFirstToken(xmlType);
        if (dt.equalsIgnoreCase(XML_TYPE_VARCHAR)) {
            dt = Token.cutFirstToken(xmlType).trim();
            if (dt.equalsIgnoreCase(XML_QUAL_HASHED)) {
                return true;
            }
            try {
                int i = Integer.parseInt(Token.getValBetweenBrackets(dt));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return xmlType.equalsIgnoreCase(XML_TYPE_DOUBLE) || xmlType.equalsIgnoreCase(XML_TYPE_DATE) || xmlType.equalsIgnoreCase(XML_TYPE_TIMESTAMP);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogUDBv81 dialog = new IndexPropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            if (this.getStorageDesign() instanceof StorageDesignUDBv9) {
                this.propertyWrapperList.add(new PropertyWrapper("Partitioned", this, "getPartitioned", "setPartitioned", Boolean.TYPE));
                this.propertyWrapperList.add(new PropertyWrapper("In Tablespace", this, "getInTablespace", "setInTablespace", TableSpaceUDB.class));
            }
            this.propertyWrapperList.add(new PropertyWrapper("Cluster", this, "getCluster", "setCluster", Boolean.TYPE));
            if (this.getStorageDesign() instanceof StorageDesignUDBv9) {
                this.propertyWrapperList.add(new PropertyWrapper("XML Pattern", this, "getXmlPattern", "setXmlPattern", String.class));
                this.propertyWrapperList.add(new PropertyWrapper("XML Type", this, "getXmlType", "setXmlType", String.class));
            }
            this.propertyWrapperList.add(new PropertyWrapper("PCTFREE", this, "getPercentageFree", "setPercentageFree", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Level2 PCTFREE", this, "getLevel2PercentageFree", "setLevel2PercentageFree", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Min % Used", this, "getMinimumPercentageUsed", "setMinimumPercentageUsed", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Reverse Scan", this, "getReverseScanSupport", "setReverseScanSupport", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Page Split", this, "getPageSplit", "setPageSplit", String.class));
            this.propertyWrapperList.add(new PropertyWrapper("Collect Statistics", this, "getCollectStatistics", "setCollectStatistics", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Index index = (Index)targetDesign.getPhysicalDesign().getTableSet().getGlobalIndexSet().getByName(this.getName());
        IndexProxyUDBv81 indexProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignUDBv81)targetDesign).getIndexProxySet().getProxy(index.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            indexProxy = (IndexProxyUDBv81)storageObject;
        }
        if (indexProxy != null) {
            indexProxy.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaUDBv81 scheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (scheme == null) {
                    SchemaUDBv81 newScheme = (SchemaUDBv81)((StorageDesignUDBv81)targetDesign).getSchemaSet().createSchema();
                    newScheme.setName(this.getSchema().getName());
                    newScheme.setRawObject(true);
                    indexProxy.setSchema(newScheme);
                } else {
                    indexProxy.setSchema(scheme);
                }
            }
            indexProxy.setPartitioned(this.getPartitioned());
            indexProxy.setInTablespace(this.getInTablespace());
            indexProxy.setCluster(this.getCluster());
            indexProxy.setXmlPattern(this.getXmlPattern());
            indexProxy.setXmlType(this.getXmlType());
            indexProxy.setPercentageFree(this.getPercentageFree());
            indexProxy.setLevel2PercentageFree(this.getLevel2PercentageFree());
            indexProxy.setMinimumPercentageUsed(this.getMinimumPercentageUsed());
            indexProxy.setReverseScanSupport(this.getReverseScanSupport());
            indexProxy.setPageSplit(this.getPageSplit());
            indexProxy.setCollectStatistics(this.getCollectStatistics());
            indexProxy.recreateColumnListSet(this.getColumnSet().toString());
            indexProxy.recreateUserGroupSet(this.getUserGroupSet().toString());
            indexProxy.recreateUserSet(this.getUserSet().toString());
            indexProxy.setComment(this.getComment());
            indexProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            indexProxy.setRawObject(false);
        }
    }
}

