/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v81;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageObjectConstantsUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.DatabasePropertyDialogUDBv81;

public class DataBaseUDBv81
extends DataBaseUDB {
    public static final String NLSCHAR = "NLSCHAR";
    public static final String DB_ONLY = "DB ONLY";
    public static final String DB_AND_DBM = "DB AND DBM";
    public static final String NONE = "NONE";
    public static final String SIMPLE = "SIMPLE";
    public static final String MIXED = "MIXED";
    public static final String COMPLEX = "COMPLEX";
    public static final String PERFORMANCE = "PERFORMANCE";
    public static final String RECOVERY = "RECOVERY";
    public static final String BOTH = "BOTH";
    public static final String RR = "RR";
    public static final String RS = "RS";
    public static final String CS = "CS";
    public static final String UR = "UR";
    public static final String MEM_PERCENT = "mem_percent";
    public static final String WORKLOAD_TYPE = "workload_type";
    public static final String NUM_STMTS = "num_stmts";
    public static final String TPM = "tpm";
    public static final String ADMIN_PROPERTY = "admin_property";
    public static final String NUM_LOCAL_APPS = "num_local_apps";
    public static final String NUM_REMOTE_APPS = "num_remote_apps";
    public static final String ISOLATION = "isolation";
    public static final String BP_RESIZEABLE = "bp_resizeable";
    protected static String[] collatingSequencesChoices = new String[]{"", "COMPATIBILITY", "SYSTEM", "IDENTITY", "NLSCHAR"};
    protected static String[] applyChangesChoices = new String[]{"", "DB ONLY", "DB AND DBM", "NONE"};
    private static Set collatingSequencesSet = null;
    private static Set applyChangeSet = null;
    protected boolean autoConfigure = false;
    protected String applyChanges = "";
    protected int memPercent = 25;
    protected String workloadType = "MIXED";
    protected int numStmts = 25;
    protected int tpm = 60;
    protected String adminProperty = "BOTH";
    protected int numLocalApps = 0;
    protected int numRemoteApps = 100;
    protected String isolation = "RR";
    protected String bpResizeable = "YES";
    protected boolean useMemPercent = false;
    protected boolean useWorkloadType = false;
    protected boolean useNumStmts = false;
    protected boolean useTpm = false;
    protected boolean useAdminProperty = false;
    protected boolean useNumLocalApps = false;
    protected boolean useNumRemoteApps = false;
    protected boolean useIsolation = false;
    protected boolean useBpResizeable = false;
    protected static String[] workloadTypeChoices = new String[]{"SIMPLE", "MIXED", "COMPLEX"};
    protected static String[] adminPropertyChoices = new String[]{"PERFORMANCE", "RECOVERY", "BOTH"};
    protected static String[] isolationChoices = new String[]{"RR", "RS", "CS", "UR"};
    private static Set workloadTypeSet = null;
    private static Set adminPropertySet = null;
    private static Set isolationSet = null;

    public static String[] getAvailableCollatingSequences() {
        return collatingSequencesChoices;
    }

    public boolean getAutoConfigure() {
        return this.autoConfigure;
    }

    public void setAutoConfigure(boolean autoConfigure) {
        this.autoConfigure = autoConfigure;
    }

    protected boolean checkWorkloadType(String value) {
        if (workloadTypeSet == null) {
            workloadTypeSet = new HashSet();
            workloadTypeSet.addAll(Arrays.asList(workloadTypeChoices));
        }
        return workloadTypeSet.contains(value);
    }

    protected boolean checkAdminProperty(String value) {
        if (adminPropertySet == null) {
            adminPropertySet = new HashSet();
            adminPropertySet.addAll(Arrays.asList(adminPropertyChoices));
        }
        return adminPropertySet.contains(value);
    }

    protected boolean checkIsolationType(String value) {
        if (isolationSet == null) {
            isolationSet = new HashSet();
            isolationSet.addAll(Arrays.asList(isolationChoices));
        }
        return isolationSet.contains(value);
    }

    protected boolean checkCollatingSequences(String value) {
        if (collatingSequencesSet == null) {
            collatingSequencesSet = new HashSet();
            collatingSequencesSet.addAll(Arrays.asList(collatingSequencesChoices));
        }
        return collatingSequencesSet.contains(value);
    }

    protected boolean checkApplyChange(String value) {
        if (applyChangeSet == null) {
            applyChangeSet = new HashSet();
            applyChangeSet.addAll(Arrays.asList(applyChangesChoices));
        }
        return applyChangeSet.contains(value);
    }

    public String getAdminProperty() {
        return this.adminProperty;
    }

    public void setAdminProperty(String adminProperty) {
        if (this.checkAdminProperty(adminProperty)) {
            this.adminProperty = adminProperty;
            this.fireDataFieldChange();
        }
    }

    public String getBpResizeable() {
        return this.bpResizeable;
    }

    public void setBpResizeable(String bpResizeable) {
        if (StorageObjectConstantsUDB.checkYesNo(bpResizeable)) {
            this.bpResizeable = bpResizeable;
            this.fireDataFieldChange();
        }
    }

    public String getIsolation() {
        return this.isolation;
    }

    public void setIsolation(String isolation) {
        if (this.checkIsolationType(isolation)) {
            this.isolation = isolation;
            this.fireDataFieldChange();
        }
    }

    public int getMemPercent() {
        return this.memPercent;
    }

    public void setMemPercent(int memPercent) {
        if (memPercent >= 1 && memPercent <= 100) {
            this.memPercent = memPercent;
        }
    }

    public int getNumLocalApps() {
        return this.numLocalApps;
    }

    public void setNumLocalApps(int numLocalApps) {
        if (numLocalApps >= 0 && numLocalApps <= 5000) {
            this.numLocalApps = numLocalApps;
        }
    }

    public int getNumRemoteApps() {
        return this.numRemoteApps;
    }

    public void setNumRemoteApps(int numRemoteApps) {
        if (numRemoteApps >= 0 && numRemoteApps <= 5000) {
            this.numRemoteApps = numRemoteApps;
        }
    }

    public int getNumStmts() {
        return this.numStmts;
    }

    public void setNumStmts(int numStmts) {
        if (numStmts >= 1 && numStmts <= 1000000) {
            this.numStmts = numStmts;
        }
    }

    public int getTpm() {
        return this.tpm;
    }

    public void setTpm(int tpm) {
        if (tpm >= 1 && tpm <= 50000) {
            this.tpm = tpm;
        }
    }

    public String getWorkloadType() {
        return this.workloadType;
    }

    public void setWorkloadType(String workloadType) {
        if (this.checkWorkloadType(workloadType)) {
            this.workloadType = workloadType;
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DatabasePropertyDialogUDBv81 dialog = new DatabasePropertyDialogUDBv81(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getApplyChanges() {
        return this.applyChanges;
    }

    public void setApplyChanges(String applyChanges) {
        if (this.checkApplyChange(applyChanges)) {
            this.applyChanges = applyChanges;
            this.fireDataFieldChange();
        }
    }

    public static String[] getAdminPropertyChoices() {
        return adminPropertyChoices;
    }

    public static String[] getApplyChangesChoices() {
        return applyChangesChoices;
    }

    public static String[] getCollatingSequencesChoices() {
        return collatingSequencesChoices;
    }

    public static String[] getIsolationChoices() {
        return isolationChoices;
    }

    public static String[] getWorkloadTypeChoices() {
        return workloadTypeChoices;
    }

    public boolean getUseAdminProperty() {
        return this.useAdminProperty;
    }

    public void setUseAdminProperty(boolean useAdminProperty) {
        this.useAdminProperty = useAdminProperty;
    }

    public boolean getUseBpResizeable() {
        return this.useBpResizeable;
    }

    public void setUseBpResizeable(boolean useBpResizeable) {
        this.useBpResizeable = useBpResizeable;
    }

    public boolean getUseIsolation() {
        return this.useIsolation;
    }

    public void setUseIsolation(boolean useIsolation) {
        this.useIsolation = useIsolation;
    }

    public boolean getUseMemPercent() {
        return this.useMemPercent;
    }

    public void setUseMemPercent(boolean useMemPercent) {
        this.useMemPercent = useMemPercent;
    }

    public boolean getUseNumLocalApps() {
        return this.useNumLocalApps;
    }

    public void setUseNumLocalApps(boolean useNumLocalApps) {
        this.useNumLocalApps = useNumLocalApps;
    }

    public boolean getUseNumRemoteApps() {
        return this.useNumRemoteApps;
    }

    public void setUseNumRemoteApps(boolean useNumRemoteApps) {
        this.useNumRemoteApps = useNumRemoteApps;
    }

    public boolean getUseNumStmts() {
        return this.useNumStmts;
    }

    public void setUseNumStmts(boolean useNumStmts) {
        this.useNumStmts = useNumStmts;
    }

    public boolean getUseTpm() {
        return this.useTpm;
    }

    public void setUseTpm(boolean useTpm) {
        this.useTpm = useTpm;
    }

    public boolean getUseWorkloadType() {
        return this.useWorkloadType;
    }

    public void setUseWorkloadType(boolean useWorkloadType) {
        this.useWorkloadType = useWorkloadType;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        DataBaseUDBv81 dbUDB = null;
        StorageObject storageObject = (StorageObject)((StorageDesignUDBv81)targetDesign).getDataBaseSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                dbUDB = (DataBaseUDBv81)storageObject;
            }
        } else {
            dbUDB = (DataBaseUDBv81)((StorageDesignUDBv81)targetDesign).getDataBaseSet().createDataBase();
        }
        if (dbUDB != null) {
            TableSpaceUDBv81 newTableSpace;
            dbUDB.setName(this.getName());
            dbUDB.setOnPath(this.getOnPath());
            dbUDB.setAlias(this.getAlias());
            dbUDB.setCodeSet(this.getCodeSet());
            dbUDB.setTerritory(this.getTerritory());
            dbUDB.setCollatingSequence(this.getCollatingSequence());
            dbUDB.setSegmentNumber(this.getSegmentNumber());
            dbUDB.setDefaultExtentSize(this.getDefaultExtentSize());
            if (this.getCatalogTableSpace() != null) {
                TableSpaceUDBv81 tableSpace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().getByName(this.getCatalogTableSpace().getName());
                if (tableSpace == null) {
                    newTableSpace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getCatalogTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    dbUDB.setCatalogTableSpace(newTableSpace);
                } else {
                    dbUDB.setCatalogTableSpace(tableSpace);
                }
            }
            if (this.getUserTableSpace() != null) {
                TableSpaceUDBv81 userTableSpace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().getByName(this.getUserTableSpace().getName());
                if (userTableSpace == null) {
                    newTableSpace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getUserTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    dbUDB.setUserTableSpace(newTableSpace);
                } else {
                    dbUDB.setUserTableSpace(userTableSpace);
                }
            }
            if (this.getTemporaryTableSpace() != null) {
                TableSpaceUDBv81 tempTableSpace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().getByName(this.getTemporaryTableSpace().getName());
                if (tempTableSpace == null) {
                    newTableSpace = (TableSpaceUDBv81)((StorageDesignUDBv81)targetDesign).getTableSpaceSet().createTableSpace();
                    newTableSpace.setName(this.getTemporaryTableSpace().getName());
                    newTableSpace.setRawObject(true);
                    dbUDB.setTemporaryTableSpace(newTableSpace);
                } else {
                    dbUDB.setTemporaryTableSpace(tempTableSpace);
                }
            }
            dbUDB.setAutoConfigure(this.getAutoConfigure());
            dbUDB.setApplyChanges(this.getApplyChanges());
            if (this.getAutoConfigure()) {
                dbUDB.setUseMemPercent(this.getUseMemPercent());
                dbUDB.setUseWorkloadType(this.getUseWorkloadType());
                dbUDB.setUseNumStmts(this.getUseNumStmts());
                dbUDB.setUseTpm(this.getUseTpm());
                dbUDB.setUseAdminProperty(this.getUseAdminProperty());
                dbUDB.setUseNumLocalApps(this.getUseNumLocalApps());
                dbUDB.setUseNumRemoteApps(this.getUseNumRemoteApps());
                dbUDB.setUseIsolation(this.getUseIsolation());
                dbUDB.setUseBpResizeable(this.getUseBpResizeable());
            }
            dbUDB.setComment(this.getComment());
            dbUDB.setRawObject(false);
        }
    }
}

