/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb.v71;

import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.BufferPoolUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.ContainerUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;

public class TableSpaceUDBv71
extends TableSpaceUDB {
    public TableSpaceUDBv71(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableSpaceUDBv71 tableSpace = null;
        StorageObject stObject = (StorageObject)((StorageDesignUDBv71)targetDesign).getTableSpaceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                tableSpace = (TableSpaceUDBv71)stObject;
            }
        } else {
            tableSpace = (TableSpaceUDBv71)((StorageDesignUDBv71)targetDesign).getTableSpaceSet().createTableSpace();
        }
        if (tableSpace != null) {
            tableSpace.setName(this.getName());
            for (int i = 0; i < this.getContainers().length; ++i) {
                ContainerUDBv71 container = (ContainerUDBv71)this.getContainers()[i];
                ContainerUDBv71 targetContainer = (ContainerUDBv71)((StorageDesignUDBv71)targetDesign).getContainerSet().getByName(container.getName());
                if (targetContainer == null) {
                    ContainerUDBv71 newContainer = (ContainerUDBv71)((StorageDesignUDBv71)targetDesign).getContainerSet().createContainer();
                    newContainer.setName(container.getName());
                    newContainer.setTableSpace(tableSpace);
                    newContainer.setRawObject(true);
                    tableSpace.addContainersFromDesign(((StorageDesignUDBv71)targetDesign).getContainerSet());
                    continue;
                }
                targetContainer.setTableSpace(tableSpace);
                tableSpace.addContainersFromDesign(((StorageDesignUDBv71)targetDesign).getContainerSet());
            }
            tableSpace.setDBDefOnly(this.getDBDefOnly());
            tableSpace.setManagedBy(this.getManagedBy());
            tableSpace.setDataType(this.getDataType());
            if (this.getNodeGroup() != null) {
                NodeGroupUDBv71 nodeGroup = (NodeGroupUDBv71)((StorageDesignUDBv71)targetDesign).getNodeGroupSet().getByName(this.getNodeGroup().getName());
                if (nodeGroup == null) {
                    NodeGroupUDBv71 newNodeGroup = (NodeGroupUDBv71)((StorageDesignUDBv71)targetDesign).getNodeGroupSet().createNodeGroup();
                    newNodeGroup.setName(this.getNodeGroup().getName());
                    newNodeGroup.setRawObject(true);
                    tableSpace.setNodeGroup(newNodeGroup);
                } else {
                    tableSpace.setNodeGroup(nodeGroup);
                }
            }
            tableSpace.setPageSize(this.getPageSize());
            tableSpace.setExtentSize(this.getExtentSize());
            tableSpace.setPrefetchSize(this.getPrefetchSize());
            if (this.getBufferPool() != null) {
                BufferPoolUDBv71 bufferPool = (BufferPoolUDBv71)((StorageDesignUDBv71)targetDesign).getBufferPoolSet().getByName(this.getBufferPool().getName());
                if (bufferPool == null) {
                    BufferPoolUDBv71 newBufferPool = (BufferPoolUDBv71)((StorageDesignUDBv71)targetDesign).getBufferPoolSet().createBufferPool();
                    newBufferPool.setName(this.getBufferPool().getName());
                    newBufferPool.setRawObject(true);
                    tableSpace.setBufferPool(newBufferPool);
                } else {
                    tableSpace.setBufferPool(bufferPool);
                }
            }
            tableSpace.setOverhead(this.getOverhead());
            tableSpace.setTransferRate(this.getTransferRate());
            tableSpace.setDroppedTableRecovery(this.getDroppedTableRecovery());
            tableSpace.recreateUserSet(this.getUserSet().toString());
            tableSpace.recreateUserGroupSet(this.getUserGroupSet().toString());
            tableSpace.setGrantOption(this.getGrantOption());
            tableSpace.setComment(this.getComment());
            tableSpace.setCommentInRDBMS(this.getCommentInRDBMS());
            tableSpace.setRawObject(false);
        }
    }
}

