/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.udb.SSBIncompleteStructuredTypeUDB;
import oracle.dbtools.crest.exports.ddl.udb.SSBMethodUDB;
import oracle.dbtools.crest.exports.ddl.udb.SSBNoneTransferableFK_UDB;
import oracle.dbtools.crest.exports.ddl.udb.SSBStructuredTypeUDB;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.OwnerSet;
import oracle.dbtools.crest.model.design.storage.udb.AliasSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.ContainerUDB;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.DataBaseUDB;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.DistinctTypeUDB;
import oracle.dbtools.crest.model.design.storage.udb.FKProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.FunctionSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.FunctionUDB;
import oracle.dbtools.crest.model.design.storage.udb.InstanceSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.InstanceUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDBEstimates;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.model.propertyholder.PropertyHolder;
import oracle.dbtools.crest.swingui.storage.distincttype.DistinctTypesDialogUDB;

public abstract class StorageDesignUDB
extends StorageDesign {
    private PropertyHolder propertyholder = null;
    private DistinctTypeSetUDB distinctTypeSet = null;
    private boolean dtDialogVisible = false;
    private StorageDesignUDBEstimates storageDesignUDBEstimates = new StorageDesignUDBEstimates();

    public StorageDesignUDB(RelationalDesign physicalDesign, RDBMSSite site, Design design) {
        super(physicalDesign, site, design);
    }

    @Override
    public abstract String getName();

    @Override
    public PropertyHolder getPropertyHolder() {
        return this.propertyholder;
    }

    public abstract NodeGroupSetUDB getNodeGroupSet();

    public abstract BufferPoolSetUDB getBufferPoolSet();

    public abstract DataBaseSetUDB getDataBaseSet();

    public abstract InstanceSetUDB getInstanceSet();

    public abstract AliasSetUDB getAliasSet();

    public abstract ContainerSetUDB getContainerSet();

    public abstract TableSpaceSetUDB getTableSpaceSet();

    public abstract OwnerSet getOwnerSet();

    public abstract UserGroupSetUDB getUserGroupSet();

    public abstract SchemaSetUDB getSchemaSet();

    public abstract TriggerSetUDB getTriggerSet();

    public abstract StoredProcedureSetUDB getStoredProcedureSet();

    public abstract FunctionSetUDB getFunctionSet();

    public abstract PrivilegesSetUDB getPrivilegesSet();

    public abstract PermissionsSetUDB getPermissionsSet();

    public abstract void updateGeneralRule();

    public FKProxySetUDB getFKProxySet() {
        return null;
    }

    public DistinctTypeSetUDB getDistinctTypeSet() {
        if (this.distinctTypeSet == null) {
            this.distinctTypeSet = new DistinctTypeSetUDB();
            this.distinctTypeSet.setDesign(this.getDesign());
            this.distinctTypeSet.setStorageDesign(this);
        }
        return this.distinctTypeSet;
    }

    @Override
    public List getStorableSetsList() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getOwnerSet());
        list.add(this.getUserGroupSet());
        list.add(this.getSchemaSet());
        list.add(this.getStructuredTypeProxySet());
        list.add(this.getInstanceSet());
        list.add(this.getDataBaseSet());
        list.add(this.getBufferPoolSet());
        list.add(this.getContainerSet());
        list.add(this.getAliasSet());
        list.add(this.getNodeGroupSet());
        list.add(this.getTableSpaceSet());
        list.add(this.getDistinctTypeSet());
        list.add(this.getTableProxySet());
        list.add(this.getTableViewProxySet());
        list.add(this.getTriggerSet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getFunctionSet());
        return list;
    }

    @Override
    public List getAllSetsList() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getStructuredTypeProxySet());
        list.add(this.getTypeElementProxySet());
        list.add(this.getMethodProxySet());
        list.add(this.getInstanceSet());
        list.add(this.getDataBaseSet());
        list.add(this.getBufferPoolSet());
        list.add(this.getContainerSet());
        list.add(this.getAliasSet());
        list.add(this.getNodeGroupSet());
        list.add(this.getTableSpaceSet());
        list.add(this.getTableProxySet());
        list.add(this.getIndexProxySet());
        list.add(this.getFKProxySet());
        list.add(this.getTableViewProxySet());
        list.add(this.getColumnProxySet());
        list.add(this.getOwnerSet());
        list.add(this.getUserGroupSet());
        list.add(this.getSchemaSet());
        list.add(this.getTriggerSet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getFunctionSet());
        list.add(this.getDistinctTypeSet());
        list.add(this.getPrivilegesSet());
        list.add(this.getPermissionsSet());
        return list;
    }

    @Override
    public StorageObjectSet getStorageObjectSetForType(String objectType) {
        if (objectType == null) {
            return null;
        }
        if (objectType.equalsIgnoreCase("Owner")) {
            return this.getOwnerSet();
        }
        if (objectType.equalsIgnoreCase("UserGroup")) {
            return this.getUserGroupSet();
        }
        if (objectType.equalsIgnoreCase("Instance")) {
            return this.getInstanceSet();
        }
        if (objectType.equalsIgnoreCase("Database")) {
            return this.getDataBaseSet();
        }
        if (objectType.equalsIgnoreCase("DB")) {
            return this.getDataBaseSet();
        }
        if (objectType.equalsIgnoreCase("Bufferpool")) {
            return this.getBufferPoolSet();
        }
        if (objectType.equalsIgnoreCase("Container")) {
            return this.getContainerSet();
        }
        if (objectType.equalsIgnoreCase("Alias")) {
            return this.getAliasSet();
        }
        if (objectType.equalsIgnoreCase("NodeGroup")) {
            return this.getNodeGroupSet();
        }
        if (objectType.equalsIgnoreCase("TableSpace")) {
            return this.getTableSpaceSet();
        }
        if (objectType.equalsIgnoreCase("Schema")) {
            return this.getSchemaSet();
        }
        if (objectType.equalsIgnoreCase("Trigger")) {
            return this.getTriggerSet();
        }
        if (objectType.equalsIgnoreCase("StProc") || objectType.equalsIgnoreCase("StoredProcedure")) {
            return this.getStoredProcedureSet();
        }
        if (objectType.equalsIgnoreCase("Function")) {
            return this.getFunctionSet();
        }
        if (objectType.equalsIgnoreCase("DistinctType")) {
            return this.getDistinctTypeSet();
        }
        if (objectType.equalsIgnoreCase("Privileges")) {
            return this.getPrivilegesSet();
        }
        if (objectType.equalsIgnoreCase("Permissions")) {
            return this.getPermissionsSet();
        }
        return null;
    }

    @Override
    public boolean hasDistinctTypes() {
        return true;
    }

    @Override
    public void showDistinctTypes() {
        if (!this.dtDialogVisible) {
            DistinctTypesDialogUDB dialog = new DistinctTypesDialogUDB(this.getDesign().getAppView(), this);
            dialog.initProperties();
            dialog.showDialog();
        }
    }

    public boolean isDtDialogVisible() {
        return this.dtDialogVisible;
    }

    public void setDtDialogVisible(boolean dtDialogVisible) {
        this.dtDialogVisible = dtDialogVisible;
    }

    @Override
    public Iterator ddlIncompleteTypeObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjectsNoSort(list, this.getStructuredTypesOrderedByParent());
        return list.iterator();
    }

    @Override
    public Iterator ddlTypeObjects() {
        ArrayList list = new ArrayList();
        this.addDDLStorageObjectsNoSort(list, this.getStructuredTypesOrderedByParent());
        this.addDDLStorageObjects(list, this.getMethodProxySet());
        return list.iterator();
    }

    @Override
    protected DDLGenerator createDDLIncompleteTypeGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new SSBIncompleteStructuredTypeUDB());
        return ddlGenerator;
    }

    @Override
    protected DDLGenerator createDDLTypeGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new SSBStructuredTypeUDB());
        ddlGenerator.append(new SSBMethodUDB());
        return ddlGenerator;
    }

    @Override
    public List getDropableSets() {
        ArrayList<ModelObject> set = new ArrayList<ModelObject>();
        set.add(this.getTableProxySet());
        set.add(this.getIndexProxySet());
        set.add(this.getTableViewProxySet());
        set.add(this.getFKProxySet());
        set.add(this.getDataBaseSet());
        return set;
    }

    @Override
    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific();
        ddlGenerator.append(new SSBNoneTransferableFK_UDB(this));
        return ddlGenerator;
    }

    @Override
    public List getUniqueList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getPKProxyList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getFKProxyList() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objects = this.getFKProxySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    @Override
    public void reloadAllProxies() {
        super.reloadAllProxies();
        this.getFKProxySet().setDesign(this.getDesign());
    }

    @Override
    protected List<ElementSet> createDDLSelectionSetsList() {
        List<ElementSet> objectSets = super.createDDLSelectionSetsList();
        objectSets.add(this.getDataBaseSet());
        objectSets.add(this.getTableSpaceSet());
        objectSets.add(this.getBufferPoolSet());
        objectSets.add(this.getBufferPoolSet());
        objectSets.add(this.getNodeGroupSet());
        objectSets.add(this.getSchemaSet());
        objectSets.add(this.getAliasSet());
        objectSets.add(this.getStoredProcedureSet());
        objectSets.add(this.getFunctionSet());
        objectSets.add(this.getStructuredTypeProxySet());
        objectSets.add(this.getTableProxySet());
        objectSets.add(this.getTableViewProxySet());
        return objectSets;
    }

    @Override
    public void sortCollections() {
        this.getTableProxySet().sort();
        this.getTableViewProxySet().sort();
        this.getOwnerSet().sort();
        this.getUserGroupSet().sort();
        this.getSchemaSet().sort();
        this.getPrivilegesSet().sort();
        this.getAliasSet().sort();
        this.getBufferPoolSet().sort();
        this.getDistinctTypeSet().sort();
        this.getDataBaseSet().sort();
        this.getTableSpaceSet().sort();
        this.getInstanceSet().sort();
        this.getContainerSet().sort();
        this.getNodeGroupSet().sort();
        this.getTriggerSet().sort();
        this.getStoredProcedureSet().sort();
        this.getFunctionSet().sort();
    }

    @Override
    public StorageObjectSet getUserSchemaSet() {
        return this.getSchemaSet();
    }

    protected void reorderScopedTables(List list) {
        int checkCycleNumber = 0;
        boolean doCheck = true;
        while (doCheck && checkCycleNumber < 10) {
            doCheck = false;
            ++checkCycleNumber;
            Iterator it = this.getTableProxySet().iterator();
            while (it.hasNext()) {
                TableProxyUDB tableProxy = (TableProxyUDB)it.next();
                Table table = (Table)tableProxy.getObject();
                for (Column column : table.getElementsCollection()) {
                    int thisTableIndex;
                    int scopeTableIndex;
                    TableProxyUDB scopeTableProxy;
                    ContainerObject scope = column.getScope();
                    if (!(scope instanceof Table) || (scopeTableProxy = (TableProxyUDB)this.getTableProxySet().getProxy(scope.getObjectID())) == null || (scopeTableIndex = list.indexOf(scopeTableProxy)) <= (thisTableIndex = list.indexOf(tableProxy)) || thisTableIndex <= -1) continue;
                    list.remove(thisTableIndex);
                    list.add(tableProxy);
                    doCheck = true;
                }
            }
        }
    }

    public StorageDesignUDBEstimates getStorageDesignUDBEstimates() {
        return this.storageDesignUDBEstimates;
    }

    public Owner createOwner() {
        return this.getOwnerSet().createOwner();
    }

    public UserGroupUDB createUserGroup() {
        return this.getUserGroupSet().createUserGroup();
    }

    public SchemaUDB createSchema() {
        return this.getSchemaSet().createSchema();
    }

    public InstanceUDB createInstance() {
        return this.getInstanceSet().createInstance();
    }

    public DataBaseUDB createDataBase() {
        return this.getDataBaseSet().createDataBase();
    }

    public BufferPoolUDB createBufferPool() {
        return this.getBufferPoolSet().createBufferPool();
    }

    public ContainerUDB createContainer() {
        return this.getContainerSet().createContainer();
    }

    public AliasUDB createAlias() {
        return this.getAliasSet().createAlias();
    }

    public NodeGroupUDB createNodeGroup() {
        return this.getNodeGroupSet().createNodeGroup();
    }

    public TableSpaceUDB createTableSpace() {
        return this.getTableSpaceSet().createTableSpace();
    }

    public DistinctTypeUDB createDistinctType() {
        return this.getDistinctTypeSet().createDistinctType();
    }

    public TriggerUDB createTrigger() {
        return this.getTriggerSet().createTrigger();
    }

    public StoredProcedureUDB createStoredProcedure() {
        return this.getStoredProcedureSet().createStoredProcedure();
    }

    public FunctionUDB createFunction() {
        return this.getFunctionSet().createFunction();
    }
}

