/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k5;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.PKPropertyDialogSqlServerv2k5;

public class PKProxySqlServerv2k5
extends PKProxySqlServer {
    private String allowRowLocks = "ON";
    private String allowPageLocks = "ON";
    private String padIndex = "NO";
    private int fillFactor = 0;
    private String recomputeStatistics = "AUTO";
    private String ignoreDupKey = "NO";
    public static final String[] ON_OFF_CHOICES = new String[]{"ON", "OFF"};
    private PartitionSchemeSqlServer partitionScheme = null;
    private ColumnProxy partitioningColumn = null;

    public PKProxySqlServerv2k5(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    public PKProxySqlServerv2k5(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PKPropertyDialogSqlServerv2k5 dialog = new PKPropertyDialogSqlServerv2k5(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getFillFactor() {
        return this.fillFactor;
    }

    @Override
    public void setFillFactor(int fillFactor) {
        if (fillFactor >= 0 && fillFactor <= 100) {
            this.fillFactor = fillFactor;
        }
    }

    public String getPadIndex() {
        return this.padIndex;
    }

    public void setPadIndex(String padIndex) {
        if (ConstantsSqlServer.checkYesNo(padIndex)) {
            this.padIndex = padIndex;
            this.fireDataFieldChange();
        }
    }

    public String getRecomputeStatistics() {
        return this.recomputeStatistics;
    }

    public void setRecomputeStatistics(String recomputeStatistics) {
        if (ConstantsSqlServer.checkAutoNo(recomputeStatistics)) {
            this.recomputeStatistics = recomputeStatistics;
            this.fireDataFieldChange();
        }
    }

    public String getIgnoreDupKey() {
        return this.ignoreDupKey;
    }

    public void setIgnoreDupKey(String ignoreDupKey) {
        if (ConstantsSqlServer.checkYesNo(ignoreDupKey)) {
            this.ignoreDupKey = ignoreDupKey;
            this.fireDataFieldChange();
        }
    }

    public String getAllowPageLocks() {
        return this.allowPageLocks;
    }

    public void setAllowPageLocks(String allowPageLocks) {
        this.allowPageLocks = allowPageLocks;
    }

    public String getAllowRowLocks() {
        return this.allowRowLocks;
    }

    public void setAllowRowLocks(String allowRowLocks) {
        this.allowRowLocks = allowRowLocks;
    }

    public PartitionSchemeSqlServer getPartitionScheme() {
        return this.partitionScheme;
    }

    public void setPartitionScheme(PartitionSchemeSqlServer partitionScheme) {
        this.partitionScheme = partitionScheme;
    }

    public ColumnProxy getPartitioningColumn() {
        return this.partitioningColumn;
    }

    public void setPartitioningColumn(ColumnProxy partitionColumn) {
        this.partitioningColumn = partitionColumn;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        PKProxySqlServerv2k5 pkProxy = null;
        IndexProxy storageObject = ((StorageDesignSqlServerv2k5)targetDesign).getPKProxySet().getByName(this.getName());
        if (storageObject != null && !this.isRawObject()) {
            pkProxy = (PKProxySqlServerv2k5)storageObject;
        }
        if (pkProxy != null) {
            pkProxy.setName(this.getName());
            pkProxy.setClustered(this.isClustered());
            if (this.getFilegroup() != null) {
                FileGroupSqlServerv2k5 filegroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().getByName(this.getFilegroup().getName());
                if (filegroup == null) {
                    FileGroupSqlServerv2k5 newFilegroup = (FileGroupSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getFileGroupSet().createFileGroup();
                    newFilegroup.setName(this.getFilegroup().getName());
                    newFilegroup.setRawObject(true);
                    pkProxy.setFilegroup(newFilegroup);
                } else {
                    pkProxy.setFilegroup(filegroup);
                }
            }
            if (this.getPartitionScheme() != null) {
                PartitionSchemeSqlServerv2k5 partScheme = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionSchemeSet().getByName(this.getPartitionScheme().getName());
                if (partScheme == null) {
                    PartitionSchemeSqlServerv2k5 newScheme = (PartitionSchemeSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getPartitionSchemeSet().createPartitionScheme();
                    newScheme.setName(this.getPartitionScheme().getName());
                    newScheme.setRawObject(true);
                    pkProxy.setPartitionScheme(newScheme);
                } else {
                    pkProxy.setPartitionScheme(partScheme);
                }
            }
            if (this.getPartitioningColumn() != null) {
                ColumnProxySqlServerv2k5 column = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getColumnProxySet()).getByName(this.getPartitioningColumn().getName());
                if (column == null) {
                    ColumnProxySqlServerv2k5 newColumn = (ColumnProxySqlServerv2k5)((ColumnProxySetSqlServerv2k5)((StorageDesignSqlServerv2k5)targetDesign).getColumnProxySet()).createProxy(this.getPartitioningColumn().getObject());
                    newColumn.setName(this.getPartitioningColumn().getName());
                    newColumn.setRawObject(true);
                    pkProxy.setPartitioningColumn(newColumn);
                } else {
                    pkProxy.setPartitioningColumn(column);
                }
            }
            pkProxy.setPadIndex(this.getPadIndex());
            pkProxy.setFillFactor(this.getFillFactor());
            pkProxy.setRecomputeStatistics(this.getRecomputeStatistics());
            pkProxy.setIgnoreDupKey(this.getIgnoreDupKey());
            pkProxy.setAllowRowLocks(this.getAllowRowLocks());
            pkProxy.setAllowPageLocks(this.getAllowPageLocks());
            pkProxy.setComment(this.getComment());
            pkProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            pkProxy.setRawObject(false);
        }
    }
}

