/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver.v2k12;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k12.SequencePropertyDialogSqlServerv2k12;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class SequenceSqlServerv2k12
extends AbstractStorageObjectSqlServer
implements PropertiesPropagator {
    private static final String[] INTEGER_TYPES = new String[]{"bigint", "decimal", "int", "numeric", "smallint", "tinyint"};
    public static final List INTEGER_TYPES_LIST = Arrays.asList(INTEGER_TYPES);
    public static final String DEFAULT_INTEGER_TYPE = "bigint";
    public static final String[] DEFAULT_MINVALUES = new String[]{"-9223372036854775808", "decimal", "-2147483648", "numeric", "-32768", "0"};
    public static final String[] DEFAULT_MAXVALUES = new String[]{"9223372036854775807", "decimal", "2147483647", "numeric", "32767", "255"};
    private DataBaseSqlServer database;
    private SchemaSqlServer schema = null;
    private String integerType = "";
    private String integerPrecision = "";
    private String startWith = "";
    private String incrementBy = "";
    private String minValue = "";
    private String maxValue = "";
    private String cycle = "NO";
    private String noCache = "NO";
    private String cache = "";
    private List propertyWrapperList = null;
    public static final String TYPE_NAME = "Sequence";

    public SequenceSqlServerv2k12(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void changeDatabase(DataBaseSqlServer database) {
        if (this.database != database) {
            this.database = database;
            this.fireDataFieldChange();
        }
    }

    public void setDatabase(DataBaseSqlServer database) {
        this.database = database;
        this.fireDataFieldChange();
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schema) {
        this.schema = schema;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getIntegerType() {
        return this.integerType;
    }

    public void setIntegerType(String integerType) {
        if ("".equals(integerType) || this.checkIntegerTypes(integerType)) {
            this.integerType = integerType;
        }
    }

    public boolean checkIntegerTypes(String type) {
        return INTEGER_TYPES_LIST.contains(type.toLowerCase());
    }

    public String getIntegerPrecision() {
        return this.integerPrecision;
    }

    public void setIntegerPrecision(String precision) {
        this.integerPrecision = "0".equals(precision) ? "" : precision;
    }

    public String getIntegerTypeWithPrecision() {
        if (!"".equals(this.integerType) && !"".equals(this.integerPrecision)) {
            return this.integerType + "(" + this.integerPrecision + ")";
        }
        return this.integerType;
    }

    public void setIntegerTypeWithPrecision(String integerTypeWithPrecision) {
        int pos = integerTypeWithPrecision.indexOf("(");
        if (pos > 0) {
            this.setIntegerType(integerTypeWithPrecision.substring(0, pos).trim());
            String prec = integerTypeWithPrecision.substring(pos);
            if (prec.indexOf(",") > 0) {
                this.setIntegerPrecision(prec.substring(1, prec.indexOf(",")).trim());
            } else {
                this.setIntegerPrecision(prec.substring(1, prec.indexOf(")")).trim());
            }
        } else {
            this.setIntegerType(integerTypeWithPrecision);
            this.setIntegerPrecision("");
        }
    }

    public String getStartWith() {
        return this.startWith;
    }

    public void setStartWith(String startWith) {
        this.startWith = startWith;
    }

    public String getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(String incrementBy) {
        this.incrementBy = incrementBy;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public void setCycle(String cycle) {
        if (ConstantsSqlServer.checkYesNo(cycle)) {
            this.cycle = cycle;
        }
    }

    public String getCycle() {
        return this.cycle;
    }

    public String getNoCache() {
        return this.noCache;
    }

    public void setNoCache(String noCache) {
        if (ConstantsSqlServer.checkYesNo(noCache)) {
            this.noCache = noCache;
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null && !"".equals(this.getSchema().getLongName())) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        return this.getName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getSchema() != null) {
            name = this.getSchema().getLongName() + '.' + name;
        }
        if (!isLongName && this.getDatabase() != null) {
            name = this.getDatabase().getName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.DATABASE, this, "getDatabase", "setDatabase", DataBaseSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.SCHEMA, this, "getSchema", "setSchema", SchemaSqlServer.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.INTEGER_TYPE, this, "getIntegerType", "setIntegerType", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.PRECISION, this, "getIntegerPrecision", "setIntegerPrecision", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.START_WITH, this, "getStartWith", "setStartWith", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.INCREMENT_BY, this, "getIncrementBy", "setIncrementBy", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.MIN_VALUE, this, "getMinValue", "setMinValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.MAX_VALUE, this, "getMaxValue", "setMaxValue", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.CYCLE, this, "getCycle", "setCycle", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.NOCACHE, this, "getNoCache", "setNoCache", String.class));
            this.propertyWrapperList.add(new PropertyWrapper(PropertyNames.CACHE, this, "getCache", "setCache", String.class));
        }
        return this.propertyWrapperList;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SEQUENCE_ICON", 16);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        SequenceSqlServerv2k12 seq = null;
        StorageObject stObject = (StorageObject)((StorageDesignSqlServerv2k12)targetDesign).getSequenceSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                seq = (SequenceSqlServerv2k12)stObject;
            }
        } else {
            seq = ((StorageDesignSqlServerv2k12)targetDesign).getSequenceSet().createSequence();
        }
        if (seq != null) {
            seq.setName(this.getName());
            if (this.getSchema() != null) {
                SchemaSqlServer schema = (SchemaSqlServer)((StorageDesignSqlServer)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schema == null) {
                    SchemaSqlServer newSchema = ((StorageDesignSqlServer)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(this.getSchema().getName());
                    newSchema.setRawObject(true);
                    seq.setSchema(newSchema);
                } else {
                    seq.setSchema(schema);
                }
            }
            if (this.getDatabase() != null) {
                DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getDataBaseSet().getByName(this.getDatabase().getName());
                if (database == null) {
                    DataBaseSqlServerv2k5 newDatabase = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getDataBaseSet().createDataBase();
                    newDatabase.setName(this.getDatabase().getName());
                    newDatabase.setRawObject(true);
                    seq.setDatabase(newDatabase);
                } else {
                    seq.setDatabase(database);
                }
            }
            seq.setIntegerType(this.getIntegerType());
            seq.setIntegerPrecision(this.getIntegerPrecision());
            seq.setStartWith(this.getStartWith());
            seq.setIncrementBy(this.getIncrementBy());
            seq.setMaxValue(this.getMaxValue());
            seq.setMinValue(this.getMinValue());
            seq.setCycle(this.getCycle());
            seq.setNoCache(this.getNoCache());
            seq.setCache(this.getCache());
            seq.setComment(this.getComment());
            seq.setRawObject(false);
        }
    }

    public void copy(SequenceSqlServerv2k12 targetSequence) {
        if (targetSequence != null) {
            StorageDesign targetDesign = targetSequence.getStorageDesign();
            targetSequence.setName(this.getName());
            targetSequence.setNameHasQuotes(this.getNameHasQuotes());
            if (this.getSchema() != null) {
                SchemaSqlServer schema = (SchemaSqlServer)((StorageDesignSqlServer)targetDesign).getSchemaSet().getByName(this.getSchema().getName());
                if (schema == null) {
                    SchemaSqlServer newSchema = ((StorageDesignSqlServer)targetDesign).getSchemaSet().createSchema();
                    newSchema.setName(this.getSchema().getName());
                    newSchema.setRawObject(true);
                    targetSequence.setSchema(newSchema);
                } else {
                    targetSequence.setSchema(schema);
                }
            }
            if (this.getDatabase() != null) {
                DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getDataBaseSet().getByName(this.getDatabase().getName());
                if (database == null) {
                    DataBaseSqlServerv2k5 newDatabase = (DataBaseSqlServerv2k5)((StorageDesignSqlServerv2k12)targetDesign).getDataBaseSet().createDataBase();
                    newDatabase.setName(this.getDatabase().getName());
                    newDatabase.setRawObject(true);
                    targetSequence.setDatabase(newDatabase);
                } else {
                    targetSequence.setDatabase(database);
                }
            }
            targetSequence.setIntegerType(this.getIntegerType());
            targetSequence.setIntegerPrecision(this.getIntegerPrecision());
            targetSequence.setStartWith(this.getStartWith());
            targetSequence.setIncrementBy(this.getIncrementBy());
            targetSequence.setMaxValue(this.getMaxValue());
            targetSequence.setMinValue(this.getMinValue());
            targetSequence.setCycle(this.getCycle());
            targetSequence.setNoCache(this.getNoCache());
            targetSequence.setCache(this.getCache());
            targetSequence.setComment(this.getComment());
            targetSequence.setRawObject(false);
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SequencePropertyDialogSqlServerv2k12 dialog = new SequencePropertyDialogSqlServerv2k12(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }
}

