/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.TriggerPropertyDialogSqlServer;

public class TriggerSqlServer
extends Trigger {
    private TableProxySqlServer table;
    private TableViewProxySqlServer view;
    protected UserSqlServer owner;
    protected String encription = "NO";
    protected String forReplication = "YES";
    protected String executionOrder = "NONE";
    private SchemaSqlServer schema;
    public static final String[] TRIGGER_TIMES = new String[]{"AFTER", "INSTEAD OF", "FOR"};
    private static List triggerTimeList = Arrays.asList("FOR", "AFTER", "INSTEAD OF");
    public static final String[] EXECUTION_ORDERS = new String[]{"NONE", "FIRST", "LAST"};
    private static Set executionOrderSet = null;

    public TriggerSqlServer(StorageDesign storageDesign) {
        super(storageDesign);
        this.setTriggerTime("AFTER");
    }

    public TableProxySqlServer getTable() {
        return this.table;
    }

    public void setTable(TableProxySqlServer table) {
        this.table = table;
        this.fireDataFieldChange();
    }

    public TableViewProxySqlServer getView() {
        return this.view;
    }

    public void setView(TableViewProxySqlServer view) {
        this.view = view;
        this.fireDataFieldChange();
    }

    public static String[] getTriggerTimes() {
        return TRIGGER_TIMES;
    }

    public static List getTriggerValues() {
        return triggerTimeList;
    }

    @Override
    protected boolean checkTriggerTime(String value) {
        return triggerTimeList.contains(value);
    }

    public UserSqlServer getOwner() {
        return this.owner;
    }

    public void setOwner(UserSqlServer owner) {
        this.owner = owner;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public static String[] getExecitionOrders() {
        return EXECUTION_ORDERS;
    }

    protected boolean checkExecutionOrder(String value) {
        if (executionOrderSet == null) {
            executionOrderSet = new HashSet();
            executionOrderSet.addAll(Arrays.asList(TriggerSqlServer.getExecitionOrders()));
        }
        return executionOrderSet.contains(value.toUpperCase());
    }

    public String getExecutionOrder() {
        return this.executionOrder;
    }

    public void setExecutionOrder(String executionOrder) {
        if (executionOrder != null && this.checkExecutionOrder(executionOrder)) {
            this.executionOrder = executionOrder.toUpperCase();
            this.fireDataFieldChange();
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TriggerPropertyDialogSqlServer dialog = new TriggerPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public String getEncription() {
        return this.encription;
    }

    public void setEncription(String encription) {
        if (ConstantsSqlServer.checkYesNo(encription)) {
            this.encription = encription;
            this.fireDataFieldChange();
        }
    }

    public String getForReplication() {
        return this.forReplication;
    }

    public void setForReplication(String forReplication) {
        if (ConstantsSqlServer.checkYesNo(forReplication)) {
            this.forReplication = forReplication;
            this.fireDataFieldChange();
        }
    }

    public boolean existInsteadOfTrigger(String action) {
        TriggerSqlServer tr;
        if (this.view != null) {
            TriggerSqlServer tr2;
            Iterator triggers = ((StorageObjectCollection)this.view.getChild(1)).iterator();
            return triggers.hasNext() && (tr2 = (TriggerSqlServer)triggers.next()) != this && tr2.getActionSet().contains(action) && tr2.getTriggerTime().equalsIgnoreCase("INSTEAD OF");
        }
        Iterator triggers = ((StorageObjectCollection)this.table.getChild(3)).iterator();
        return triggers.hasNext() && (tr = (TriggerSqlServer)triggers.next()) != this && tr.getActionSet().contains(action) && tr.getTriggerTime().equalsIgnoreCase("INSTEAD OF");
    }

    public boolean existFirstTrigger(String action) {
        TriggerSqlServer tr;
        if (this.view != null) {
            TriggerSqlServer tr2;
            Iterator triggers = ((StorageObjectCollection)this.view.getChild(1)).iterator();
            return triggers.hasNext() && (tr2 = (TriggerSqlServer)triggers.next()) != this && tr2.getActionSet().contains(action) && tr2.getExecutionOrder().equalsIgnoreCase("FIRST");
        }
        Iterator triggers = ((StorageObjectCollection)this.table.getChild(3)).iterator();
        return triggers.hasNext() && (tr = (TriggerSqlServer)triggers.next()) != this && tr.getActionSet().contains(action) && tr.getExecutionOrder().equalsIgnoreCase("FIRST");
    }

    public boolean existLastTrigger(String action) {
        TriggerSqlServer tr;
        if (this.view != null) {
            TriggerSqlServer tr2;
            Iterator triggers = ((StorageObjectCollection)this.view.getChild(1)).iterator();
            return triggers.hasNext() && (tr2 = (TriggerSqlServer)triggers.next()) != this && tr2.getActionSet().contains(action) && tr2.getExecutionOrder().equalsIgnoreCase("LAST");
        }
        Iterator triggers = ((StorageObjectCollection)this.table.getChild(3)).iterator();
        return triggers.hasNext() && (tr = (TriggerSqlServer)triggers.next()) != this && tr.getActionSet().contains(action) && tr.getExecutionOrder().equalsIgnoreCase("LAST");
    }

    public SchemaSqlServer getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaSqlServer schema) {
        this.schema = schema;
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.getSchema() != null && !this.getSchema().isNullInstance()) {
            return new StringBuffer().append(this.getSchema().getName()).append('.').append(this.getName()).toString();
        }
        return this.getName();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("TRIGGER_ICON", 16);
    }
}

