/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PartitionSchemePropertyDialog;

public class PartitionSchemeSqlServer
extends AbstractStorageObjectSqlServer {
    private PartitionFunctionSqlServer partitionFunction;
    public static final String MULTIPLE_FILE_GROUPS = "MULTIPLE FILE GROUPS";
    public static final String SINGLE_FILE_GROUP = "SINGLE FILE GROUP";
    private static final String[] mapTypeChoices = new String[]{"MULTIPLE FILE GROUPS", "SINGLE FILE GROUP"};
    public static final String MAXVALUE = "MAXVALUE";
    private String mappingType = "MULTIPLE FILE GROUPS";
    private FileGroupSqlServer singleFileGroup;
    private MappingTable mappingTableSet = null;
    protected String mappingTable = "";
    public static final String TYPE_NAME = "PartitionScheme";

    public PartitionFunctionSqlServer getPartitionFunction() {
        return this.partitionFunction;
    }

    public void setPartitionFunction(PartitionFunctionSqlServer partFunction) {
        this.partitionFunction = partFunction;
        this.setPAC_Element(partFunction);
        this.fireDataFieldChange();
    }

    public FileGroupSqlServer getSingleFileGroup() {
        return this.singleFileGroup;
    }

    public void setSingleFileGroup(FileGroupSqlServer singeFileGroup) {
        this.singleFileGroup = singeFileGroup;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PartitionSchemePropertyDialog dialog = new PartitionSchemePropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "PS";
    }

    public static String[] getMapTypeChoices() {
        return mapTypeChoices;
    }

    public boolean isSingleFileGroupSelected() {
        return this.getMappingType().equalsIgnoreCase(SINGLE_FILE_GROUP);
    }

    public String getMappingType() {
        return this.mappingType;
    }

    public MappingTable getMappingTableSet() {
        if (this.mappingTableSet == null) {
            this.mappingTableSet = new MappingTable();
        }
        return this.mappingTableSet;
    }

    public void setMappingTable(String value) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateMappingTableSet(value);
        } else {
            this.addMappingTableValue(value);
        }
        this.mappingTable = this.getMappingTableSet().toString();
        this.fireDataFieldChange();
    }

    private void addMappingTableValue(String value) {
        this.getMappingTableSet().add(value);
    }

    public void recreateMappingTableSet(String value) {
        this.getMappingTableSet().clear();
        StringTokenizer st = new StringTokenizer(value, ",");
        this.mappingTableSet = new MappingTable();
        while (st.hasMoreTokens()) {
            this.getMappingTableSet().add(st.nextToken().trim());
        }
    }

    public String getMappingTable() {
        return this.mappingTable;
    }

    public void setMappingType(String mappingType) {
        this.mappingType = mappingType;
    }

    public void clear() {
        if (this.mappingTableSet != null) {
            this.mappingTableSet.removeAllElements();
            this.mappingTable = "";
        }
    }

    public void removeFileGroup(FileGroupSqlServer server) {
        for (int i = 0; i < this.getMappingTableSet().size(); ++i) {
            String fileGroupName = (String)this.getMappingTableSet().get(++i);
            if (!fileGroupName.equalsIgnoreCase(server.getName())) continue;
            this.getMappingTableSet().set(i, "");
        }
        this.mappingTable = this.getMappingTableSet().toString();
    }

    public void removeBoundaruValue(String baundaryValue) {
        int index = this.getMappingTableSet().size();
        if (index >= 2) {
            if (this.getMappingTableSet().contains(MAXVALUE)) {
                index = this.getMappingTableSet().indexOf(MAXVALUE);
            }
            this.getMappingTableSet().removeElementAt(index - 1);
            this.getMappingTableSet().removeElementAt(index - 2);
        }
        this.mappingTable = this.getMappingTableSet().toString();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("SCHEMA_ICON", 16);
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        if (this.getPartitionFunction() != null) {
            return this.getPartitionFunction().getDatabase();
        }
        return null;
    }

    public class MappingTable
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

