/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.PartitionFunctionPropertyDialog;

public class PartitionFunctionSqlServer
extends AbstractStorageObjectSqlServer
implements ModelObjectSetListener,
StorageObjectListener {
    protected String inputType = "";
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    private static final String[] LEFT_RIGHT = new String[]{"LEFT", "RIGHT"};
    protected String rangeType = "LEFT";
    protected String boundaryValues = "";
    protected InlineList bValuesSet = null;
    protected DataBaseSqlServer database = null;
    private StorageObjectCollection partitionScheme;
    public static final String TYPE_NAME = "PartitionFunction";

    public PartitionFunctionSqlServer(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        StorageDesignSqlServerv2k5 design = (StorageDesignSqlServerv2k5)storageDesign;
        this.partitionScheme = new StorageObjectCollection(((StorageDesignSqlServerv2k5)this.getStorageDesign()).getPartitionSchemeSet());
        this.partitionScheme.setParent(this);
        this.partitionScheme.setName(Messages.getString("PartitionFunctionSqlServer.PartitionScheme"));
        this.partitionScheme.setSetMethod("setPartitionFunction");
        this.partitionScheme.setClassForParent(PartitionFunctionSqlServer.class);
        this.partitionScheme.setIcon(GUIConfiguration.getInstance().getIcon("SCHEMA_FOLDER_ICON", 16));
        design.getPartitionSchemeSet().addSetListener(this);
        this.addPartSchemeFromDesign(((StorageDesignSqlServerv2k5)this.getStorageDesign()).getPartitionSchemeSet());
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.partitionScheme) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.partitionScheme) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.partitionScheme;
            }
        }
        return null;
    }

    public void clear() {
        this.getBValuesSet().removeAllElements();
        this.boundaryValues = "";
    }

    public InlineList getBValuesSet() {
        if (this.bValuesSet == null) {
            this.bValuesSet = new InlineList();
        }
        return this.bValuesSet;
    }

    public String getBoundaryValues() {
        return this.boundaryValues;
    }

    public void setBoundaryValues(String value) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateBValuesSet(value);
        } else {
            this.addBoundaryValue(value);
        }
        this.boundaryValues = this.getBValuesSet().toString();
        this.fireDataFieldChange();
    }

    private void addBoundaryValue(String value) {
        this.getBValuesSet().add(value);
    }

    public void recreateBValuesSet(String value) {
        this.getBValuesSet().clear();
        StringTokenizer st = new StringTokenizer(value, ",");
        this.bValuesSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getBValuesSet().add(st.nextToken().trim());
        }
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            PartitionFunctionPropertyDialog dialog = new PartitionFunctionPropertyDialog(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "PF";
    }

    public void setBValuesSet(InlineList valuesSet) {
        this.bValuesSet = valuesSet;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        return this.database;
    }

    public void setDatabase(DataBaseSqlServer database) {
        this.database = database;
        this.fireDataFieldChange();
    }

    public static String[] getLEFT_RIGHT() {
        return LEFT_RIGHT;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(String rangeType) {
        this.rangeType = rangeType;
    }

    private void addPartSchemeFromDesign(StorageObjectSet set) {
        for (PartitionSchemeSqlServer partScheme : set) {
            if (partScheme.getPartitionFunction() != null && partScheme.getPartitionFunction() == this) {
                partScheme.setParent(this.partitionScheme);
                this.partitionScheme.add(partScheme);
                continue;
            }
            this.partitionScheme.remove(partScheme);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof PartitionSchemeSqlServer) {
                PartitionSchemeSqlServer partScheme = (PartitionSchemeSqlServer)event.getAffected();
                partScheme.addObjectListener(this);
                if (partScheme.getPartitionFunction() != null && partScheme.getPartitionFunction() == this) {
                    partScheme.setParent(this.partitionScheme);
                    this.partitionScheme.add(partScheme);
                } else {
                    this.partitionScheme.remove(partScheme);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof PartitionSchemeSqlServer) {
            PartitionSchemeSqlServer partScheme = (PartitionSchemeSqlServer)event.getAffected();
            this.partitionScheme.remove(partScheme);
            partScheme.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof PartitionSchemeSqlServer) {
            PartitionSchemeSqlServer partScheme = (PartitionSchemeSqlServer)event.getAffected();
            if (partScheme.getPartitionFunction() != null && partScheme.getPartitionFunction() == this) {
                partScheme.setParent(this.partitionScheme);
                this.partitionScheme.add(partScheme);
            } else {
                this.partitionScheme.remove(partScheme);
            }
        }
    }

    public StorageObjectCollection getPartitionScheme() {
        return this.partitionScheme;
    }

    public PartitionSchemeSqlServer createPartitionScheme() {
        if (this.partitionScheme.getStorageObjectSet() != null) {
            return (PartitionSchemeSqlServer)this.partitionScheme.createElement(null);
        }
        return null;
    }

    @Override
    public void clearChildren() {
        this.partitionScheme.removeAll();
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("FUNCTION_ICON", 16);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

