/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.sqlserver;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.IndexOnViewPropertyDialogSqlServer;

public class IndexOnViewSqlServer
extends AbstractStorageObjectSqlServer {
    private TableViewProxySqlServer view;
    private String unique = "NO";
    private String clustered = "NO";
    private FileGroupSqlServer filegroup;
    private String padIndex = "NO";
    private int fillFactor = 0;
    private String recomputeStatistics = "AUTO";
    private String sortInTempDB = "NO";
    private String ignoreDupKey = "NO";
    private String props = "";
    private InlineList extPropsSet = null;
    private String cols = "";
    private InlineList colSet = null;
    public static final String TYPE_NAME = "IndexOnView";

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexOnViewPropertyDialogSqlServer dialog = new IndexOnViewPropertyDialogSqlServer(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ViewIndex";
    }

    public TableViewProxySqlServer getView() {
        return this.view;
    }

    public void setView(TableViewProxySqlServer view) {
        this.view = view;
        this.setPAC_Element(view);
        this.fireDataFieldChange();
    }

    public String getUnique() {
        return this.unique;
    }

    public void setUnique(String unique) {
        if (ConstantsSqlServer.checkYesNo(unique)) {
            this.unique = unique;
            if (this.view != null && ((StorageObjectCollection)this.view.getChild(0)).size() != 1) {
                this.fireDataFieldChange();
            }
        }
    }

    public String getClustered() {
        return this.clustered;
    }

    public void setClustered(String clustered) {
        if (ConstantsSqlServer.checkYesNo(clustered)) {
            this.clustered = clustered;
            if (this.view != null && ((StorageObjectCollection)this.view.getChild(0)).size() != 1) {
                this.fireDataFieldChange();
            }
        }
    }

    public FileGroupSqlServer getFilegroup() {
        return this.filegroup;
    }

    public void setFilegroup(FileGroupSqlServer filegroup) {
        this.filegroup = filegroup;
        this.fireDataFieldChange();
    }

    public int getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(int fillFactor) {
        if (fillFactor >= 0 && fillFactor <= 100) {
            this.fillFactor = fillFactor;
        }
    }

    public String getIgnoreDupKey() {
        return this.ignoreDupKey;
    }

    public void setIgnoreDupKey(String ignoreDupKey) {
        if (ConstantsSqlServer.checkYesNo(ignoreDupKey)) {
            this.ignoreDupKey = ignoreDupKey;
            this.fireDataFieldChange();
        }
    }

    public String getPadIndex() {
        return this.padIndex;
    }

    public void setPadIndex(String padIndex) {
        if (ConstantsSqlServer.checkYesNo(padIndex)) {
            this.padIndex = padIndex;
            this.fireDataFieldChange();
        }
    }

    public String getRecomputeStatistics() {
        return this.recomputeStatistics;
    }

    public void setRecomputeStatistics(String recomputeStatistics) {
        if (ConstantsSqlServer.checkAutoNo(recomputeStatistics)) {
            this.recomputeStatistics = recomputeStatistics;
            this.fireDataFieldChange();
        }
    }

    public String getSortInTempDB() {
        return this.sortInTempDB;
    }

    public void setSortInTempDB(String sortInTempDB) {
        if (ConstantsSqlServer.checkYesNo(sortInTempDB)) {
            this.sortInTempDB = sortInTempDB;
            this.fireDataFieldChange();
        }
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String prop) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateExtPropertiesSet(prop);
        } else {
            this.addExtProperty(prop);
        }
        this.props = this.getExtPropsSet().toString();
        this.fireDataFieldChange();
    }

    private void addExtProperty(String props2) {
        this.getExtPropsSet().add(props2);
    }

    protected void recreateExtPropertiesSet(String props1) {
        this.getExtPropsSet().clear();
        StringTokenizer st = new StringTokenizer(props1, ",");
        this.extPropsSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getExtPropsSet().add(st.nextToken().trim());
        }
    }

    public InlineList getExtPropsSet() {
        if (this.extPropsSet == null) {
            this.extPropsSet = new InlineList();
        }
        return this.extPropsSet;
    }

    public void clear() {
        this.getExtPropsSet().removeAllElements();
        this.props = "";
        this.getColSet().removeAllElements();
        this.cols = "";
    }

    private void addCol(String col) {
        this.getColSet().add(col);
    }

    protected void recreateColSet(String cols) {
        this.getColSet().clear();
        StringTokenizer st = new StringTokenizer(cols, ",");
        while (st.hasMoreTokens()) {
            this.getColSet().add(st.nextToken().trim());
        }
    }

    public void setCols(String cols) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColSet(cols);
        } else {
            this.addCol(cols);
        }
        this.cols = this.getColSet().toString();
        this.fireDataFieldChange();
    }

    public String getCols() {
        return this.cols;
    }

    public String getPartKeySortOrder(String columnID) {
        StringTokenizer st = new StringTokenizer(this.cols, ",");
        String colID = "";
        String sortOrder = "";
        while (st.hasMoreTokens()) {
            colID = st.nextToken().trim();
            sortOrder = st.nextToken().trim();
            if (!colID.equalsIgnoreCase(columnID)) continue;
            return sortOrder;
        }
        return "ASC";
    }

    public InlineList getColSet() {
        if (this.colSet == null) {
            this.colSet = new InlineList();
        }
        return this.colSet;
    }

    @Override
    public DataBaseSqlServer getDatabase() {
        if (this.getView() != null) {
            return this.getView().getDataBase();
        }
        return null;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

