/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v9i;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DirectoryOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableColumnOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.ExternalTableOraclePropertyDialogv9i;

public class ExternalTableOraclev9i
extends ExternalTableOracle
implements ModelObjectSetListener,
StorageObjectListener {
    public ExternalTableOraclev9i(StorageDesign storage) {
        this.setStorageDesign(storage);
        this.cols = new StorageObjectCollection(((StorageDesignOraclev9i)storage).getExternalColumnSet());
        this.cols.setParent(this);
        this.cols.setName(Messages.getString("TableProxy.Columns"));
        this.cols.setClassForParent(ExternalTableOracle.class);
        this.cols.setSetMethod("setExternalTable");
        ((StorageDesignOraclev9i)storage).getExternalColumnSet().addSetListener(this);
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof ExternalTableColumnOraclev9i) {
            ExternalTableColumnOraclev9i col = (ExternalTableColumnOraclev9i)event.getAffected();
            if (col.getExternalTable() != null && col.getExternalTable() == this) {
                col.setParent(this.cols);
                this.cols.add(col);
            } else {
                this.cols.remove(col);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ExternalTableColumnOraclev9i) {
                ExternalTableColumnOraclev9i col = (ExternalTableColumnOraclev9i)event.getAffected();
                col.addObjectListener(this);
                if (col.getExternalTable() != null && col.getExternalTable() == this) {
                    col.setParent(this.cols);
                    this.cols.add(col);
                } else {
                    this.cols.remove(col);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof ExternalTableColumnOraclev9i) {
            ExternalTableColumnOraclev9i col = (ExternalTableColumnOraclev9i)event.getAffected();
            this.cols.remove(col);
            col.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.cols;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.cols) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.cols) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.cols.removeAll();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ExternalTableOraclePropertyDialogv9i dialog = new ExternalTableOraclePropertyDialogv9i(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public StorageObjectCollection getColumns() {
        return this.cols;
    }

    public ExternalTableColumnOracle createColumn() {
        if (this.cols.getStorageObjectSet() != null) {
            return (ExternalTableColumnOracle)this.cols.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        ExternalTableOraclev9i extTable = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev9i)targetDesign).getExternalTableSet().getByName(this.getName());
        if (stObject != null) {
            if (this.isRawObject()) {
                extTable = (ExternalTableOraclev9i)stObject;
            }
        } else {
            extTable = (ExternalTableOraclev9i)((StorageDesignOraclev9i)targetDesign).getExternalTableSet().createExternalTable();
        }
        if (extTable != null) {
            extTable.setName(this.getName());
            for (ExternalTableColumnOraclev9i extTableColumn : this.getColumns()) {
                ExternalTableColumnOraclev9i targetExtColumn = (ExternalTableColumnOraclev9i)((StorageDesignOraclev9i)targetDesign).getExternalColumnSet().getByName(extTableColumn.getName());
                if (targetExtColumn == null) {
                    ExternalTableColumnOraclev9i newExtColumn = (ExternalTableColumnOraclev9i)((StorageDesignOraclev9i)targetDesign).getExternalColumnSet().createExternalColumn();
                    newExtColumn.setName(extTableColumn.getName());
                    newExtColumn.setExternalTable(extTable);
                    newExtColumn.setRawObject(true);
                    extTable.getColumns().add(newExtColumn);
                    continue;
                }
                targetExtColumn.setExternalTable(extTable);
                extTable.getColumns().add(targetExtColumn);
            }
            if (this.getOwner() != null) {
                UserOraclev9i targetUser = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().getByName(this.getOwner().getName());
                if (targetUser == null) {
                    UserOraclev9i newUser = (UserOraclev9i)((StorageDesignOraclev9i)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getOwner().getName());
                    newUser.setRawObject(true);
                    extTable.setOwner(newUser);
                } else {
                    extTable.setOwner(targetUser);
                }
            }
            extTable.setAccessDriverType(this.getAccessDriverType());
            if (this.getDefaultDir() != null) {
                DirectoryOraclev9i directory = (DirectoryOraclev9i)((StorageDesignOraclev9i)targetDesign).getDirectorySet().getByName(this.getDefaultDir().getName());
                if (directory == null) {
                    DirectoryOraclev9i newDirectory = (DirectoryOraclev9i)((StorageDesignOraclev9i)targetDesign).getDirectorySet().createDirectory();
                    newDirectory.setName(this.getDefaultDir().getName());
                    newDirectory.setRawObject(true);
                    extTable.setDefaultDir(newDirectory);
                } else {
                    extTable.setDefaultDir(directory);
                }
            }
            extTable.setOpaqueFormatSpec(this.getOpaqueFormatSpec());
            extTable.setClobSubquery(this.getClobSubquery());
            extTable.setAccessParametersType(this.getAccessParametersType());
            extTable.setLocation(this.getLocation());
            extTable.setParallel(this.getParallel());
            extTable.setParallelNum(this.getParallelNum());
            extTable.setRejectLimit(this.getRejectLimit());
            extTable.setComment(this.getComment());
            extTable.setRawObject(this.isRawObject());
        }
    }
}

