/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.DataBaseOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DataFileOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.RedoLogGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UndoTablespaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataBaseOraclev9i;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.DataBasePropertyDialogOraclev10g;

public class DataBaseOraclev10g
extends DataBaseOraclev9i {
    public DataBaseOraclev10g(StorageDesign storageDesign) {
        super(storageDesign);
        this.dfiles = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getDataFileSet());
        this.dfiles.setParent(this);
        this.dfiles.setName(Messages.getString("TableSpaceOracle.DataFiles"));
        this.dfiles.setSetMethod("setDataBase");
        this.dfiles.setClassForParent(DataBaseOracle.class);
        this.dfiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignOracle)storageDesign).getDataFileSet().addSetListener(this);
        this.rlgroups = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getRedoLogGroupSet());
        this.rlgroups.setParent(this);
        this.rlgroups.setName(Messages.getString("DataBaseOracle.RedoLogGroups"));
        this.rlgroups.setSetMethod("setDataBase");
        this.rlgroups.setClassForParent(DataBaseOracle.class);
        this.rlgroups.setIcon(GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16));
        ((StorageDesignOracle)storageDesign).getRedoLogGroupSet().addSetListener(this);
        this.sysAuxFiles = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getDataFileSet());
        this.sysAuxFiles.setParent(this);
        this.sysAuxFiles.setName(Messages.getString("DataBaseOraclev10g.SYSAUXFiles"));
        this.sysAuxFiles.setSetMethod("setDbForSysAuxFiles");
        this.sysAuxFiles.setClassForParent(DataBaseOraclev10g.class);
        this.sysAuxFiles.setIcon(GUIConfiguration.getInstance().getIcon("DATAFILE_ICON", 16));
        ((StorageDesignOracle)storageDesign).getDataFileSet().addSetListener(this);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DataBasePropertyDialogOraclev10g dialog = new DataBasePropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 3;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.dfiles;
            }
            case 1: {
                return this.rlgroups;
            }
            case 2: {
                return this.sysAuxFiles;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.dfiles) {
            return 0;
        }
        if (child == this.rlgroups) {
            return 1;
        }
        if (child == this.sysAuxFiles) {
            return 2;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.dfiles) {
            return 0;
        }
        if (child == this.rlgroups) {
            return 1;
        }
        if (child == this.sysAuxFiles) {
            return 2;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.dfiles.removeAll();
        this.rlgroups.removeAll();
        this.sysAuxFiles.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof DataFileOraclev10g) {
                DataFileOraclev10g df = (DataFileOraclev10g)event.getAffected();
                df.addObjectListener(this);
                if (df.getDataBase() != null && df.getDataBase() == this) {
                    df.setParent(this.dfiles);
                    this.dfiles.add(df);
                } else {
                    this.dfiles.remove(df);
                }
                if (df.getDbForSysAuxFiles() != null && df.getDbForSysAuxFiles() == this) {
                    df.setParent(this.sysAuxFiles);
                    this.sysAuxFiles.add(df);
                } else {
                    this.sysAuxFiles.remove(df);
                }
            } else if (event.getAffected() instanceof RedoLogGroupOracle) {
                RedoLogGroupOracle rlg = (RedoLogGroupOracle)event.getAffected();
                rlg.addObjectListener(this);
                if (rlg.getDataBase() != null && rlg.getDataBase() == this) {
                    rlg.setParent(this.rlgroups);
                    this.rlgroups.add(rlg);
                } else {
                    this.rlgroups.remove(rlg);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof DataFileOracle) {
                DataFileOracle df = (DataFileOracle)event.getAffected();
                this.dfiles.remove(df);
                this.sysAuxFiles.remove(df);
                df.removeObjectListener(this);
            } else if (event.getAffected() instanceof RedoLogGroupOracle) {
                RedoLogGroupOracle rlg = (RedoLogGroupOracle)event.getAffected();
                this.rlgroups.remove(rlg);
                rlg.removeObjectListener(this);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof DataFileOraclev10g) {
            DataFileOraclev10g df = (DataFileOraclev10g)event.getAffected();
            if (df.getDataBase() != null && df.getDataBase() == this) {
                df.setParent(this.dfiles);
                this.dfiles.add(df);
            } else {
                this.dfiles.remove(df);
            }
            if (df.getDbForSysAuxFiles() != null && df.getDbForSysAuxFiles() == this) {
                df.setParent(this.sysAuxFiles);
                this.sysAuxFiles.add(df);
            } else {
                this.sysAuxFiles.remove(df);
            }
        } else if (event.getAffected() instanceof RedoLogGroupOracle) {
            RedoLogGroupOracle rlg = (RedoLogGroupOracle)event.getAffected();
            if (rlg.getDataBase() != null && rlg.getDataBase() == this) {
                rlg.setParent(this.rlgroups);
                this.rlgroups.add(rlg);
            } else {
                this.rlgroups.remove(rlg);
            }
        }
    }

    public StorageObjectCollection getSysAuxFiles() {
        return this.sysAuxFiles;
    }

    public DataFileOracle createSysAuxFile() {
        if (this.sysAuxFiles.getStorageObjectSet() != null) {
            return (DataFileOracle)this.sysAuxFiles.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        DataBaseOraclev10g dbOracle = null;
        StorageObject storageObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getDataBaseSet().getByName(this.getName());
        if (storageObject != null) {
            if (storageObject.isRawObject()) {
                dbOracle = (DataBaseOraclev10g)storageObject;
            }
        } else {
            dbOracle = (DataBaseOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataBaseSet().createDataBase();
        }
        if (dbOracle != null) {
            dbOracle.setName(this.getName());
            for (DataFileOraclev10g dataFile : this.getDataFiles()) {
                DataFileOraclev10g targetDataFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().getByName(dataFile.getName());
                if (targetDataFile == null) {
                    DataFileOraclev10g newDataFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().createDataFile();
                    newDataFile.setName(dataFile.getName());
                    newDataFile.setDataBase(dbOracle);
                    newDataFile.setRawObject(true);
                    ((StorageDesignOraclev10g)targetDesign).getDataFileSet().add(newDataFile);
                    dbOracle.getDataFiles().add(newDataFile);
                    continue;
                }
                targetDataFile.setDataBase(dbOracle);
                ((StorageDesignOraclev10g)targetDesign).getDataFileSet().add(targetDataFile);
                dbOracle.getDataFiles().add(targetDataFile);
            }
            for (RedoLogGroupOraclev10g logGroup : this.getRedoLogGroups()) {
                RedoLogGroupOraclev10g targetLogGroup = (RedoLogGroupOraclev10g)((StorageDesignOraclev10g)targetDesign).getRedoLogGroupSet().getByName(logGroup.getName());
                if (targetLogGroup == null) {
                    RedoLogGroupOraclev10g newLogGroup = (RedoLogGroupOraclev10g)((StorageDesignOraclev10g)targetDesign).getRedoLogGroupSet().createRedoLogGroup();
                    newLogGroup.setName(logGroup.getName());
                    newLogGroup.setDataBase(dbOracle);
                    newLogGroup.setRawObject(true);
                    ((StorageDesignOraclev10g)targetDesign).getRedoLogGroupSet().add(newLogGroup);
                    dbOracle.getRedoLogGroups().add(newLogGroup);
                    continue;
                }
                targetLogGroup.setDataBase(dbOracle);
                ((StorageDesignOraclev10g)targetDesign).getRedoLogGroupSet().add(targetLogGroup);
                dbOracle.getRedoLogGroups().add(targetLogGroup);
            }
            for (DataFileOraclev10g sysAuxFile : this.getSysAuxFiles()) {
                DataFileOraclev10g targetSysAuxFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().getByName(sysAuxFile.getName());
                if (targetSysAuxFile == null) {
                    DataFileOraclev10g newSysAuxFile = (DataFileOraclev10g)((StorageDesignOraclev10g)targetDesign).getDataFileSet().createDataFile();
                    newSysAuxFile.setName(sysAuxFile.getName());
                    newSysAuxFile.setDataBase(dbOracle);
                    newSysAuxFile.setRawObject(true);
                    ((StorageDesignOraclev10g)targetDesign).getDataFileSet().add(newSysAuxFile);
                    dbOracle.getDataFiles().add(newSysAuxFile);
                    continue;
                }
                targetSysAuxFile.setDataBase(dbOracle);
                ((StorageDesignOraclev10g)targetDesign).getDataFileSet().add(targetSysAuxFile);
                dbOracle.getDataFiles().add(targetSysAuxFile);
            }
            dbOracle.setControlFileReuse(this.getControlFileReuse());
            dbOracle.setMaxDataFiles(this.getMaxDataFiles());
            dbOracle.setMaxInstances(this.getMaxInstances());
            dbOracle.setCharacterSet(this.getCharacterSet());
            dbOracle.setNationalCharacterSet(this.getNationalCharacterSet());
            dbOracle.setPassForSYS(this.getPassForSYS());
            dbOracle.setPassForSYSTEM(this.getPassForSYSTEM());
            dbOracle.setTimeZone(this.getTimeZone());
            dbOracle.setMaxLogFiles(this.getMaxLogFiles());
            dbOracle.setMaxLogMembers(this.getMaxLogMembers());
            dbOracle.setMaxLogHistory(this.getMaxLogHistory());
            dbOracle.setArchiveLog(this.getArchiveLog());
            dbOracle.setForceLogging(this.getForceLogging());
            dbOracle.setExtentManagement(this.getExtentManagement());
            if (this.getTempTablespace() != null) {
                TemporaryTablespaceOraclev10g tempTableSpace = (TemporaryTablespaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getTemporaryTablespaceSet().getByName(this.getTempTablespace().getName());
                if (tempTableSpace == null) {
                    TemporaryTablespaceOraclev10g newTablespace = (TemporaryTablespaceOraclev10g)((StorageDesignOraclev10g)this.getStorageDesign()).getTemporaryTablespaceSet().createTemporaryTablespace();
                    newTablespace.setName(this.getTempTablespace().getName());
                    newTablespace.setRawObject(true);
                    dbOracle.setTempTablespace(newTablespace);
                } else {
                    dbOracle.setTempTablespace(tempTableSpace);
                }
            }
            if (this.getUndoTablespace() != null) {
                UndoTablespaceOraclev10g undoTabSpace = (UndoTablespaceOraclev10g)((StorageDesignOraclev10g)targetDesign).getUndoTablespaceSet().getByName(this.getUndoTablespace().getName());
                if (undoTabSpace == null) {
                    UndoTablespaceOraclev10g newUndoTabSpace = (UndoTablespaceOraclev10g)((StorageDesignOraclev10g)this.getStorageDesign()).getUndoTablespaceSet().createTablespace();
                    newUndoTabSpace.setName(this.getUndoTablespace().getName());
                    newUndoTabSpace.setRawObject(true);
                    dbOracle.setUndoTablespace(newUndoTabSpace);
                } else {
                    dbOracle.setUndoTablespace(undoTabSpace);
                }
            }
            dbOracle.setComment(this.getComment());
            dbOracle.setRawObject(false);
        }
    }
}

