/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.HashMap;
import java.util.Map;

public class SearchOptions {
    private Map<String, Boolean> searchOptionsMap;
    private Map<String, String> searchTextMap = new HashMap<String, String>();
    public static final String MATCH_CASE = "MATCH_CASE";
    public static final String MATCH_WHOLE_WORD = "MATCH_WHOLE_WORD";
    public static final String HIGHLIGHT_OCCURRENCES = "HIGHLIGHT_OCCURRENCES";
    public static final String WRAP_AROUND = "WRAP_AROUND";

    public SearchOptions() {
        this.searchTextMap.put(MATCH_CASE, MATCH_CASE);
        this.searchTextMap.put(MATCH_WHOLE_WORD, MATCH_WHOLE_WORD);
        this.searchTextMap.put(HIGHLIGHT_OCCURRENCES, HIGHLIGHT_OCCURRENCES);
        this.searchTextMap.put(WRAP_AROUND, WRAP_AROUND);
        this.init();
    }

    public SearchOptions(String matchWholeWordText, String matchCaseText) {
        this.searchTextMap.put(matchWholeWordText, MATCH_WHOLE_WORD);
        this.searchTextMap.put(matchCaseText, MATCH_CASE);
        this.init();
    }

    private void init() {
        this.searchOptionsMap = new HashMap<String, Boolean>();
        this.searchOptionsMap.put(MATCH_WHOLE_WORD, false);
        this.searchOptionsMap.put(MATCH_CASE, false);
        this.searchOptionsMap.put(HIGHLIGHT_OCCURRENCES, false);
        this.searchOptionsMap.put(WRAP_AROUND, true);
    }

    public void set(String optionText, boolean value) {
        String option = this.searchTextMap.get(optionText);
        this.searchOptionsMap.put(option, value);
    }

    public boolean isMatchWholeWord() {
        boolean b = this.searchOptionsMap.get(MATCH_WHOLE_WORD);
        return b;
    }

    public boolean isMatchCase() {
        boolean b = this.searchOptionsMap.get(MATCH_CASE);
        return b;
    }

    public boolean isHighlightAll() {
        boolean b = this.searchOptionsMap.get(HIGHLIGHT_OCCURRENCES);
        return b;
    }

    public boolean isWrapAround() {
        boolean b = this.searchOptionsMap.get(WRAP_AROUND);
        return b;
    }

    public Map<String, Boolean> getMap() {
        HashMap<String, Boolean> optMap = new HashMap<String, Boolean>();
        for (String searchText : this.searchTextMap.keySet()) {
            String option = this.searchTextMap.get(searchText);
            boolean b = this.searchOptionsMap.get(option);
            optMap.put(searchText, b);
        }
        return optMap;
    }

    public boolean match(String a, String b) {
        boolean m = a.equals(b);
        if (!this.isMatchWholeWord() && this.isMatchCase()) {
            boolean bl = m = a.indexOf(b) >= 0;
        }
        if (this.isMatchWholeWord() && !this.isMatchCase()) {
            m = a.equalsIgnoreCase(b);
        }
        if (!this.isMatchWholeWord() && !this.isMatchCase()) {
            m = a.toUpperCase().indexOf(b.toUpperCase()) >= 0;
        }
        return m;
    }
}

