/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;

public class LocalIndexProperties
extends AbstractStorageObjectOracle {
    private StorageObject partition;
    private StorageObject index;
    private String partitionName = "";
    private TableSpaceOracle tableSpace;
    private String logging = "";
    private SegmentOracle segment;
    private InlineList indexHSubPartitionsTableSpacesSet = null;
    private String indexHSubPartitionsTableSpaces = "";
    private String keyCompress = "";
    private String layerType;
    private TableSpaceOracle workTablespace;
    public static final String TYPE_NAME = "LocIndProp";
    public static final String OLD_TYPE_NAME = "LocalIndexProperties";

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "LIP";
    }

    public InlineList getIndexHashSubPartTSSet() {
        if (this.indexHSubPartitionsTableSpacesSet == null) {
            this.indexHSubPartitionsTableSpacesSet = new InlineList();
        }
        return this.indexHSubPartitionsTableSpacesSet;
    }

    private void recreateLocIndexHashSubPartitionsTSSet(String tableSpaces) {
        this.getIndexHashSubPartTSSet().clear();
        StringTokenizer st = new StringTokenizer(tableSpaces, "|");
        while (st.hasMoreTokens()) {
            this.getIndexHashSubPartTSSet().add(st.nextToken().trim());
        }
    }

    private void addLocIndexHashSubPartitionsTS(String ts) {
        if (!this.getIndexHashSubPartTSSet().contains(ts)) {
            this.getIndexHashSubPartTSSet().add(ts);
        }
    }

    public void setHashSubPartitionsTableSpaces(String indexHSubPartitionsTableSpaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateLocIndexHashSubPartitionsTSSet(indexHSubPartitionsTableSpaces);
        } else {
            this.addLocIndexHashSubPartitionsTS(indexHSubPartitionsTableSpaces);
        }
        this.indexHSubPartitionsTableSpaces = this.getIndexHashSubPartTSSet().toString();
        this.fireDataFieldChange();
    }

    public void clearHashSubPartTSSet() {
        this.getIndexHashSubPartTSSet().clear();
        this.indexHSubPartitionsTableSpaces = "";
    }

    public StorageObject getIndex() {
        return this.index;
    }

    public void setIndex(StorageObject index) {
        this.index = index;
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        this.logging = logging;
    }

    public StorageObject getPartition() {
        return this.partition;
    }

    public void setPartition(StorageObject partition) {
        this.partition = partition;
        if (partition != null) {
            this.setPAC_Element(partition.getPAC_Element());
        }
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segment) {
        this.segment = segment;
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        this.tableSpace = tableSpace;
    }

    public String getHashSubPartitionsTableSpaces() {
        return this.indexHSubPartitionsTableSpaces;
    }

    public String getAllHashSubPartitionsTableSpaces() {
        StringBuffer tablespaces = new StringBuffer();
        String idList = this.indexHSubPartitionsTableSpaces;
        StringTokenizer st = new StringTokenizer(idList, "|");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)((StorageDesignOracle)this.getStorageDesign()).getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (tablespaces.length() > 0) {
                tablespaces.append(", ");
            }
            tablespaces.append(ts.getName());
        }
        return tablespaces.toString();
    }

    public String getKeyCompress() {
        return this.keyCompress;
    }

    public void setKeyCompress(String keyCompress) {
        this.keyCompress = keyCompress;
    }

    public boolean isSpatialIndex() {
        if (this.getIndex() instanceof IndexProxy) {
            return ((IndexProxy)this.getIndex()).getIndex().isSpatialIndex();
        }
        return false;
    }

    public TableSpaceOracle getWorkTablespace() {
        return this.workTablespace;
    }

    public void setWorkTablespace(TableSpaceOracle workTablespace) {
        this.workTablespace = workTablespace;
    }

    public String getLayerType() {
        return this.layerType;
    }

    public void setLayerType(String layerType) {
        if (Arrays.asList(Index.getConstrainLayerTypeChoices()).contains(layerType)) {
            this.layerType = layerType;
        }
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append("|");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

