/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class ExternalTableColumnOracle
extends AbstractStorageObjectOracle {
    public static final String[] UNITS = new String[]{"", "BYTE", "CHAR"};
    protected ExternalTableOracle externalTable;
    protected String datatype = "UNKNOWN";
    protected int size = 0;
    protected int precision = 0;
    protected int scale = 0;
    protected String units = "";
    public static final String TYPE_NAME = "ExternalTableColumn";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ExternCol";
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        if (!this.datatype.equals(datatype)) {
            this.datatype = datatype;
            if (!this.isSizeAllowed(datatype)) {
                this.size = 0;
            }
            if (!this.isUnitsAllowed(datatype)) {
                this.units = "";
            }
            if (!this.isPrecisionAllowed(datatype)) {
                this.precision = 0;
            }
            if (!this.isScaleAllowed(datatype)) {
                this.scale = 0;
            }
            this.fireDataFieldChange();
        }
    }

    public ExternalTableOracle getExternalTable() {
        return this.externalTable;
    }

    public void setExternalTable(ExternalTableOracle externalTable) {
        this.externalTable = externalTable;
        this.setPAC_Element(externalTable);
        this.fireDataFieldChange();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public boolean isSizeAllowed(String datatype) {
        return datatype.contains("CHAR") || datatype.equals("RAW") || datatype.equals("UROWID");
    }

    public boolean isUnitsAllowed(String datatype) {
        return datatype.equals("CHAR") || datatype.equals("VARCHAR2");
    }

    public boolean isPrecisionAllowed(String datatype) {
        return datatype.startsWith("DEC") || datatype.equals("FLOAT") || datatype.startsWith("NUM") || datatype.startsWith("TIMESTAMP") || datatype.startsWith("INTERVAL");
    }

    public boolean isScaleAllowed(String datatype) {
        return datatype.startsWith("DEC") || datatype.startsWith("NUM") || datatype.equals("INTERVAL DAY TO SECOND");
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("COLUMN_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

