/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class ClusterOracle
extends AbstractStorageObjectOracle
implements ModelObjectSetListener,
StorageObjectListener,
OwnedObjectOracle {
    private static final String[] UNITS = new String[]{"", "K"};
    private static List measureUnitList = Arrays.asList(UNITS);
    private UserOracle user = null;
    private int size = 0;
    private static Set unitSet = null;
    private String measureUnit = UNITS[0];
    private TableSpaceOracle tableSpace = null;
    private SegmentOracle segment = null;
    private String indexed = "YES";
    private String singleTable = "NO";
    private int hashKeys = 0;
    private String hashExpression = "";
    private String parallel = "NO";
    private int degree = 0;
    private String cache = "NO";
    private String rowDependency = "NO";
    StorageObjectCollection aindexes;
    StorageObjectCollection columns;
    public static final String TYPE_NAME = "Cluster";

    public ClusterOracle() {
    }

    public ClusterOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.columns = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getClusterColumnSet());
        this.aindexes = new StorageObjectCollection(((StorageDesignOracle)storageDesign).getClusterIndexSet());
        this.columns.setParent(this);
        this.columns.setName(Messages.getString("TableProxy.Columns"));
        this.columns.setSetMethod("setCluster");
        this.columns.setClassForParent(ClusterOracle.class);
        this.columns.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON", 16));
        this.aindexes.setParent(this);
        this.aindexes.setName(Messages.getString("TableProxy.Indexes"));
        this.aindexes.setSetMethod("setCluster");
        this.aindexes.setClassForParent(ClusterOracle.class);
        this.aindexes.setAllowedNumberOfElements(1);
        this.aindexes.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON", 16));
        ((StorageDesignOracle)storageDesign).getClusterIndexSet().addSetListener(this);
        ((StorageDesignOracle)storageDesign).getClusterColumnSet().addSetListener(this);
        this.addIndFromDesign(((StorageDesignOracle)storageDesign).getClusterIndexSet());
        this.addColumnFromDesign(((StorageDesignOracle)storageDesign).getClusterColumnSet());
    }

    @Override
    public String getIDPrefix() {
        return "CL";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.fireDataFieldChange();
    }

    public static String[] getUnitChoices() {
        return UNITS;
    }

    protected boolean checkUnit(String value) {
        if (unitSet == null) {
            unitSet = new HashSet();
            unitSet.addAll(Arrays.asList(ClusterOracle.getUnitChoices()));
        }
        return unitSet.contains(value);
    }

    public void setMeasureUnit(String value) {
        if (this.checkUnit(value)) {
            this.measureUnit = value;
            this.fireDataFieldChange();
        }
    }

    public String getMeasureUnit() {
        return this.measureUnit;
    }

    public TableSpaceOracle getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(TableSpaceOracle tableSpace) {
        if (this.tableSpace != tableSpace) {
            this.tableSpace = tableSpace;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segment) {
        this.segment = segment;
        this.fireDataFieldChange();
    }

    public void setIndexed(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.indexed = value;
            this.fireDataFieldChange();
        }
    }

    public String getIndexed() {
        return this.indexed;
    }

    public void setSingleTable(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.singleTable = value;
            this.fireDataFieldChange();
        }
    }

    public String getSingleTable() {
        return this.singleTable;
    }

    public int getHashKeys() {
        return this.hashKeys;
    }

    public void setHashKeys(int hashKeys) {
        this.hashKeys = hashKeys;
        this.fireDataFieldChange();
    }

    public String getHashExpression() {
        return this.hashExpression;
    }

    public void setHashExpression(String hashExpression) {
        this.hashExpression = hashExpression;
        this.fireDataFieldChange();
    }

    public void setParallel(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.parallel = value;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int degree) {
        this.degree = degree;
        this.fireDataFieldChange();
    }

    public void setCache(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.cache = value;
            this.fireDataFieldChange();
        }
    }

    public String getCache() {
        return this.cache;
    }

    public void setRowDependency(String rowDependency) {
        if (ConstantsOracle.checkYesNo(rowDependency)) {
            this.rowDependency = rowDependency;
            this.fireDataFieldChange();
        }
    }

    public String getRowDependency() {
        return this.rowDependency;
    }

    public static List getMeasureUnitValues() {
        return measureUnitList;
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null) {
            name = this.getUser().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public int getMaxNameLength() {
        return 30;
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.aindexes;
            }
            case 1: {
                return this.columns;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.aindexes) {
            return 0;
        }
        if (child == this.columns) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.aindexes) {
            return 0;
        }
        if (child == this.columns) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.aindexes.removeAll();
        this.columns.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ClusterColumnOracle) {
                ClusterColumnOracle col = (ClusterColumnOracle)event.getAffected();
                col.addObjectListener(this);
                if (col.getCluster() != null && col.getCluster() == this && !this.columns.contains(col)) {
                    col.setParent(this.columns);
                    this.columns.add(col);
                } else {
                    this.columns.remove(col);
                }
            } else if (event.getAffected() instanceof ClusterIndexOracle) {
                ClusterIndexOracle ci = (ClusterIndexOracle)event.getAffected();
                ci.addObjectListener(this);
                if (ci.getCluster() != null && ci.getCluster() == this && !this.aindexes.contains(ci)) {
                    ci.setParent(this.aindexes);
                    this.aindexes.add(ci);
                } else {
                    this.aindexes.remove(ci);
                }
            }
        } else if (event.isType(0)) {
            if (event.getAffected() instanceof ClusterColumnOracle) {
                ClusterColumnOracle col = (ClusterColumnOracle)event.getAffected();
                this.columns.remove(col);
            }
            if (event.getAffected() instanceof ClusterIndexOracle) {
                ClusterIndexOracle ci = (ClusterIndexOracle)event.getAffected();
                this.aindexes.remove(ci);
            }
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof ClusterIndexOracle) {
            ClusterIndexOracle ci = (ClusterIndexOracle)event.getAffected();
            if (ci.getCluster() != null && ci.getCluster() == this) {
                if (!this.aindexes.contains(ci)) {
                    ci.setParent(this.aindexes);
                    this.aindexes.add(ci);
                }
            } else {
                this.aindexes.remove(ci);
            }
        } else if (event.getAffected() instanceof ClusterColumnOracle) {
            ClusterColumnOracle col = (ClusterColumnOracle)event.getAffected();
            if (col.getCluster() != null && col.getCluster() == this) {
                if (!this.columns.contains(col)) {
                    col.setParent(this.columns);
                    this.columns.add(col);
                }
            } else {
                this.columns.remove(col);
            }
        }
    }

    public void addIndFromDesign(StorageObjectSet set) {
        for (ClusterIndexOracle ind : set) {
            if (ind.getCluster() != null && ind.getCluster() == this) {
                ind.setParent(this.aindexes);
                this.aindexes.add(ind);
                continue;
            }
            this.aindexes.remove(ind);
        }
    }

    public void addColumnFromDesign(StorageObjectSet set) {
        for (ClusterColumnOracle ind : set) {
            if (ind.getCluster() != null && ind.getCluster() == this) {
                ind.setParent(this.columns);
                this.columns.add(ind);
                continue;
            }
            this.columns.remove(ind);
        }
    }

    public List getColumns() {
        ArrayList list = new ArrayList();
        this.columns.addAllElementsTo(list);
        return list;
    }

    public List getIndexes() {
        ArrayList list = new ArrayList();
        this.aindexes.addAllElementsTo(list);
        return list;
    }

    public StorageObjectCollection getColumnsCollection() {
        return this.columns;
    }

    public StorageObjectCollection getIndexesCollection() {
        return this.aindexes;
    }

    public ClusterColumnOracle createColumn() {
        if (this.columns.getStorageObjectSet() != null) {
            return (ClusterColumnOracle)this.columns.createElement(null);
        }
        return null;
    }

    public ClusterIndexOracle createIndex() {
        if (this.aindexes.getStorageObjectSet() != null) {
            return (ClusterIndexOracle)this.aindexes.createElement(null);
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("CLUSTER_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.columns.removeAll();
    }

    @Override
    public void clearMergableStructure(Map reverseMap) {
        if (reverseMap != null) {
            for (StorageObject st : this.aindexes) {
                if (reverseMap.get(st.getObjectID()) != null) continue;
                st.remove(true);
            }
        }
    }
}

