/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.OwnedObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class BitmapJoinIndexOracle
extends AbstractStorageObjectOracle
implements OwnedObjectOracle {
    protected UserOracle user;
    protected TableProxyOracle table;
    protected String indexColumns = "";
    protected InlineList indexColumnSet = null;
    protected String dimensionKeys = "";
    protected InlineList dimensionKeySet = null;
    protected String joinColumns = "";
    protected InlineList joinColumnSet = null;
    protected String localPartitioning = "NO";
    protected String tablespace = "Default";
    protected String logging = "";
    protected SegmentOracle segment;
    protected int compress = 0;
    protected String parallel = "NO";
    protected String degree = "";
    protected String sortedRows = "NO";
    public static final String SORTED = "SORTED";
    public static final String REVERSE = "REVERSE";
    private static String[] sortedRowsChoices = new String[]{"NO", "SORTED", "REVERSE"};
    private static Set sortedRowsSet = null;
    protected String computeStatistics = "NO";
    protected String online = "NO";
    private String hashSubPartitionsTableSpaces = "";
    private InlineList hashPartitionsTableSpacesSet = null;
    public static final String TYPE_NAME = "BJIndex";
    public static final String OLD_TYPE_NAME = "BitmapJoinIndex";

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "BJI";
    }

    public InlineList getIndexColumnSet() {
        if (this.indexColumnSet == null) {
            this.indexColumnSet = new InlineList();
        }
        return this.indexColumnSet;
    }

    public void clearIndexColumns() {
        this.getIndexColumnSet().removeAllElements();
        this.indexColumns = "";
    }

    public String getIndexColumnNames() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getIndexColumnSet().iterator();
        while (it.hasNext()) {
            ColumnProxy columnProxy;
            String ascOrDesc;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String columnId = (String)it.next();
            if (it.hasNext() && "DESC".equals(ascOrDesc = (String)it.next())) {
                sb.append("DESC ");
            }
            if ((columnProxy = this.table.getColumnProxy(columnId)) == null) continue;
            sb.append(columnProxy.getName());
        }
        return sb.toString();
    }

    public String getIndexColumns() {
        return this.indexColumns;
    }

    public void setIndexColumns(String col) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateIndexColumnSet(col);
        } else {
            this.addIndexColumn(col);
        }
        this.indexColumns = this.getIndexColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addIndexColumn(String colId) {
        this.getIndexColumnSet().add(colId);
    }

    public void recreateIndexColumnSet(String col) {
        this.getIndexColumnSet().clear();
        StringTokenizer st = new StringTokenizer(col, ",");
        this.indexColumnSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getIndexColumnSet().add(st.nextToken().trim());
        }
    }

    public InlineList getJoinColumnSet() {
        if (this.joinColumnSet == null) {
            this.joinColumnSet = new InlineList();
        }
        return this.joinColumnSet;
    }

    public void clearJoinColumns() {
        this.getJoinColumnSet().removeAllElements();
        this.joinColumns = "";
    }

    public String getJoinColumnNames() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getJoinColumnSet().iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String columnId = (String)it.next();
            RelationalObjectProxy colProxy = this.getStorageDesign().getColumnProxySet().getProxy(columnId);
            if (colProxy == null) continue;
            sb.append(colProxy.getName());
        }
        return sb.toString();
    }

    public String getJoinColumns() {
        return this.joinColumns;
    }

    public void setJoinColumns(String col) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateJoinColumnSet(col);
        } else {
            this.addJoinColumn(col);
        }
        this.joinColumns = this.getJoinColumnSet().toString();
        this.fireDataFieldChange();
    }

    private void addJoinColumn(String colID) {
        this.getJoinColumnSet().add(colID);
    }

    public void recreateJoinColumnSet(String col) {
        this.getJoinColumnSet().clear();
        StringTokenizer st = new StringTokenizer(col, ",");
        this.joinColumnSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getJoinColumnSet().add(st.nextToken().trim());
        }
    }

    public InlineList getDimensionKeySet() {
        if (this.dimensionKeySet == null) {
            this.dimensionKeySet = new InlineList();
        }
        return this.dimensionKeySet;
    }

    public void clearDimensionKeys() {
        this.getDimensionKeySet().removeAllElements();
        this.dimensionKeys = "";
    }

    public String getDimensionKeyNames() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getDimensionKeySet().iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            it.next();
            if (!it.hasNext()) continue;
            String dimensionKeyId = (String)it.next();
            RelationalObjectProxy keyProxy = this.getStorageDesign().getIndexProxySet().getProxy(dimensionKeyId);
            if (keyProxy == null) continue;
            sb.append(keyProxy.getName());
        }
        return sb.toString();
    }

    public String getDimensionKeys() {
        return this.dimensionKeys;
    }

    public void setDimensionKeys(String col) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateDimensionKeySet(col);
        } else {
            this.addDimensionKey(col);
        }
        this.dimensionKeys = this.getDimensionKeySet().toString();
        this.fireDataFieldChange();
    }

    private void addDimensionKey(String colId) {
        this.getDimensionKeySet().add(colId);
    }

    public void recreateDimensionKeySet(String col) {
        this.getDimensionKeySet().clear();
        StringTokenizer st = new StringTokenizer(col, ",");
        this.dimensionKeySet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getDimensionKeySet().add(st.nextToken().trim());
        }
    }

    protected boolean checkSortedRows(String value) {
        if (sortedRowsSet == null) {
            sortedRowsSet = new HashSet();
            sortedRowsSet.addAll(Arrays.asList(sortedRowsChoices));
        }
        return sortedRowsSet.contains(value);
    }

    public int getCompress() {
        return this.compress;
    }

    public void setCompress(int compress) {
        this.compress = compress;
        this.fireDataFieldChange();
    }

    public String getComputeStatistics() {
        return this.computeStatistics;
    }

    public void setComputeStatistics(String computeStatistics) {
        if (ConstantsOracle.checkYesNo(computeStatistics)) {
            this.computeStatistics = computeStatistics;
            this.fireDataFieldChange();
        }
    }

    public String getLocalPartitioning() {
        return this.localPartitioning;
    }

    public void setLocalPartitioning(String localPartitioning) {
        if (ConstantsOracle.checkYesNo(localPartitioning)) {
            this.localPartitioning = localPartitioning;
            this.fireDataFieldChange();
        }
    }

    public String getLogging() {
        return this.logging;
    }

    public void setLogging(String logging) {
        if (!this.logging.equals(logging) && (ConstantsOracle.checkYesNo(logging) || "".equals(logging))) {
            this.logging = logging;
            this.fireDataFieldChange();
        }
    }

    public String getOnline() {
        return this.online;
    }

    public void setOnline(String online) {
        if (ConstantsOracle.checkYesNo(online)) {
            this.online = online;
            this.fireDataFieldChange();
        }
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        if (ConstantsOracle.checkYesNo(parallel)) {
            this.parallel = parallel;
            this.fireDataFieldChange();
        }
    }

    public SegmentOracle getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentOracle segment) {
        this.segment = segment;
        this.fireDataFieldChange();
    }

    public String getSortedRows() {
        return this.sortedRows;
    }

    public void setSortedRows(String sortedRows) {
        if (this.checkSortedRows(sortedRows)) {
            this.sortedRows = sortedRows;
            this.fireDataFieldChange();
        }
    }

    public TableProxyOracle getTable() {
        return this.table;
    }

    public void setTable(TableProxyOracle table) {
        this.table = table;
        this.setPAC_Element(table);
        this.fireDataFieldChange();
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
        this.fireDataFieldChange();
    }

    @Override
    public UserOracle getUser() {
        return this.user;
    }

    @Override
    public void setUser(UserOracle user) {
        this.user = user;
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    public String getColumnSortOrder(String columnID) {
        int index;
        if (this.indexColumnSet != null && (index = this.getIndexColumnSet().indexOf(columnID)) > -1) {
            return (String)this.getIndexColumnSet().elementAt(index + 1);
        }
        return "ASC";
    }

    public IndexProxy getDimensionKey(TableProxyOracle proxy) {
        int index;
        if (this.dimensionKeySet != null && (index = this.getDimensionKeySet().indexOf(proxy.getObjectID())) > -1) {
            String indexID = (String)this.getDimensionKeySet().elementAt(index + 1);
            ModelIDObject ind = proxy.getPrimaryKeys().getById(indexID);
            if (ind == null) {
                ind = proxy.getUniqueKeys().getById(indexID);
            }
            return (IndexProxy)ind;
        }
        return null;
    }

    public ColumnProxyOracle getJoinColumn(ColumnProxyOracle proxy) {
        int index;
        if (this.joinColumnSet != null && (index = this.getJoinColumnSet().indexOf(proxy.getObjectID())) > -1) {
            String colID = index % 2 == 0 ? (String)this.getJoinColumnSet().elementAt(index + 1) : (String)this.getJoinColumnSet().elementAt(index - 1);
            ColumnProxyOracle col = (ColumnProxyOracle)this.getStorageDesign().getColumnProxySet().getProxy(colID);
            return col;
        }
        return null;
    }

    public Object[] getDimensionTables() {
        ArrayList<String> list = new ArrayList<String>();
        Object[] dim = this.getDimensionKeySet().toArray();
        for (int i = 0; i < dim.length; ++i) {
            String table = (String)dim[i];
            ++i;
            list.add(table);
        }
        return list.toArray();
    }

    public void setHashSubPartitionsTableSpaces(String hashSubPartitionsTableSpaces) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateHashSubPartitionsTSSet(hashSubPartitionsTableSpaces);
        } else {
            this.addHashSubPartitionsTS(hashSubPartitionsTableSpaces);
        }
        this.hashSubPartitionsTableSpaces = this.getHashPartitionsTableSpacesSet().toString();
        this.fireDataFieldChange();
    }

    public String getHashSubPartitionsTableSpaces() {
        return this.hashSubPartitionsTableSpaces;
    }

    public String getAllHashSubPartitionsTableSpaces() {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.hashSubPartitionsTableSpaces, ",");
        while (st.hasMoreTokens()) {
            String tsID = st.nextToken().trim();
            TableSpaceOracle ts = (TableSpaceOracle)this.getStorageDesignOracle().getTableSpaceSet().getById(tsID);
            if (ts == null) continue;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(ts.getName());
        }
        return result.toString();
    }

    private void addHashSubPartitionsTS(String tableSpaceID) {
        if (!this.getHashPartitionsTableSpacesSet().contains(tableSpaceID)) {
            this.getHashPartitionsTableSpacesSet().add(tableSpaceID);
        }
    }

    public void recreateHashSubPartitionsTSSet(String tableSpaces) {
        this.getHashPartitionsTableSpacesSet().clear();
        StringTokenizer st = new StringTokenizer(tableSpaces, ",");
        while (st.hasMoreTokens()) {
            this.getHashPartitionsTableSpacesSet().add(st.nextToken().trim());
        }
    }

    public InlineList getHashPartitionsTableSpacesSet() {
        if (this.hashPartitionsTableSpacesSet == null) {
            this.hashPartitionsTableSpacesSet = new InlineList();
        }
        return this.hashPartitionsTableSpacesSet;
    }

    public void clear() {
        this.getHashPartitionsTableSpacesSet().clear();
        this.hashSubPartitionsTableSpaces = "";
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        block5: {
            if (!"".equalsIgnoreCase(degree)) {
                try {
                    int intVal = Integer.parseInt(degree);
                    if (intVal > 0) {
                        this.degree = degree;
                        break block5;
                    }
                    this.degree = "";
                }
                catch (NumberFormatException e) {
                    this.degree = "";
                }
            } else {
                this.degree = "";
            }
        }
        this.fireDataFieldChange();
    }

    @Override
    public String getLongName() {
        if (this.getUser() != null && !"".equals(this.getUser().getLongName())) {
            return new StringBuffer(this.getUser().getLongName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!isLongName && this.getUser() != null) {
            name = this.getUser().getLongName() + '.' + name;
        }
        return !objectSet.containsLongName(this, name);
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("INDEX_ICON", 16);
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

