/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v70;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class TableViewProxyDB2v70
extends TableViewProxyDB2 {
    public TableViewProxyDB2v70(TableView view, StorageDesign storage) {
        super(view, storage);
    }

    public TableViewProxyDB2v70(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableView tableView = (TableView)((StorageDesignDB2v70)targetDesign).getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxyDB2v70 tableViewProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignDB2v70)targetDesign).getTableViewProxySet().getProxy(tableView.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableViewProxy = (TableViewProxyDB2v70)storageObject;
        }
        if (tableViewProxy != null) {
            tableViewProxy.setName(this.getName());
            for (SynonymDB2 synonym : this.getSynonyms()) {
                SynonymDB2 targetSynonym = (SynonymDB2)((StorageDesignDB2v70)targetDesign).getSynonymSet().getById(synonym.getObjectID());
                if (targetSynonym == null) {
                    SynonymDB2 newSynonym = ((StorageDesignDB2v70)targetDesign).getSynonymSet().createSynonym();
                    newSynonym.setName(synonym.getName());
                    newSynonym.setRawObject(true);
                    newSynonym.setView(tableViewProxy);
                    tableViewProxy.addSynonymsFromDesign(((StorageDesignDB2v70)targetDesign).getSynonymSet());
                    continue;
                }
                targetSynonym.setView(tableViewProxy);
                tableViewProxy.addSynonymsFromDesign(((StorageDesignDB2v70)targetDesign).getSynonymSet());
            }
            if (this.getOwner() != null) {
                Owner owner = (Owner)((StorageDesignDB2v70)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (owner == null) {
                    Owner newOwner = (Owner)((StorageDesignDB2v70)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    tableViewProxy.setOwner(newOwner);
                } else {
                    tableViewProxy.setOwner(owner);
                }
            }
            tableViewProxy.setCheckOption(this.getCheckOption());
            tableViewProxy.setCheckOptionScope(this.getCheckOptionScope());
            tableViewProxy.setDefinition(this.getDefinition());
            tableViewProxy.setLabelOn(this.getLabelOn());
            tableViewProxy.setComment(this.getComment());
            tableViewProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableViewProxy.setRawObject(false);
        }
    }
}

