/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v70;

import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxySet;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxyDB2v70;

public class IndexProxySetDB2v70
extends IndexProxySet {
    public IndexProxySetDB2v70(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    public RelationalObjectProxy createProxy(DesignObject object) {
        String name;
        IndexProxyDB2v70 proxy = new IndexProxyDB2v70((Index)object, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            String stName;
            if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerIndex()) {
                StorageTemplateDB2 template = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                proxy.setStorageTemplate(template);
                proxy.synchronizeStorageTemplateName();
            } else if (this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerIndex() && (stName = this.getDesign().getAppView().getSettings().getDefaultIndexStorageTemplateName()) != null && !"".equalsIgnoreCase(stName)) {
                StorageTemplateDB2 template = (StorageTemplateDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().getByName(stName);
                if (template == null) {
                    template = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                    template.setName(stName);
                }
                if (template != null) {
                    proxy.setStorageTemplate(template);
                }
            }
        }
        if (!((name = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) == null || "".equalsIgnoreCase(name.trim()) || "[Implicit]".equalsIgnoreCase(name.trim()) || "PUBLIC".equalsIgnoreCase(name.trim()))) {
            Owner owner;
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(name) == null) {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(name);
            } else {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(name);
            }
            proxy.setOwner(owner);
        }
        return proxy;
    }

    @Override
    protected RelationalObjectProxy createProxy(Design design, String id, String longName) {
        String name;
        IndexProxyDB2v70 proxy = new IndexProxyDB2v70(design, id, longName, this.getStorageDesign());
        if (!this.getStorageDesign().isLoading()) {
            String stName;
            if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerIndex()) {
                StorageTemplateDB2 template = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                proxy.setStorageTemplate(template);
                proxy.synchronizeStorageTemplateName();
            } else if (this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerIndex() && (stName = this.getDesign().getAppView().getSettings().getDefaultIndexStorageTemplateName()) != null && !"".equalsIgnoreCase(stName)) {
                StorageTemplateDB2 template = (StorageTemplateDB2)((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().getByName(stName);
                if (template == null) {
                    template = ((AbstractStorageDesignDB2)this.getStorageDesign()).getStorageTemplateSet().createStorageTemplate();
                    template.setName(stName);
                }
                if (template != null) {
                    proxy.setStorageTemplate(template);
                }
            }
        }
        if (!((name = this.getDesign().getAppView().getSettings().getDefaultDB2Owner()) == null || "".equalsIgnoreCase(name.trim()) || "[Implicit]".equalsIgnoreCase(name.trim()) || "PUBLIC".equalsIgnoreCase(name.trim()))) {
            Owner owner;
            if (((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(name) == null) {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(name);
            } else {
                owner = (Owner)((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet().getByName(name);
            }
            proxy.setOwner(owner);
        }
        return proxy;
    }

    @Override
    protected void add(Index[] array) {
        for (int i = 0; i < array.length; ++i) {
            Index ind = array[i];
            if (ind.isFK()) continue;
            this.add(ind);
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        Index ind;
        if (event.isAdded()) {
            Index ind2 = (Index)event.getAffected();
            if (!ind2.isFK()) {
                this.add(ind2);
                this.fireUpdate();
            }
        } else if (event.isRemoved() && this.containsId((ind = (Index)event.getAffected()).getObjectID())) {
            this.remove((Index)event.getAffected());
            this.fireUpdate();
        }
    }
}

