/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import oracle.dbtools.crest.model.design.storage.db2.AbstractPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractPartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;

public class PartitionSetDB2
extends AbstractPartitionSetDB2 {
    public static final PartitionDB2[] PROTO_ARRAY = new PartitionDB2[0];

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    public PartitionDB2 createPartition() {
        return this.createPartition(null);
    }

    public PartitionDB2 createPartition(String id) {
        return (PartitionDB2)this.createElement(id);
    }

    @Override
    public AbstractPartitionDB2 instantiateElement() {
        return new PartitionDB2();
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Partition";
    }

    public PartitionDB2[] getPartitionsFor(TableSpaceDB2 tableSpace) {
        PartitionDB2[] allPartitions = (PartitionDB2[])this.toArray();
        Arrays.sort(allPartitions, new PossitionComparator());
        ArrayList<PartitionDB2> partitionsForTS = new ArrayList<PartitionDB2>();
        for (int i = 0; i < allPartitions.length; ++i) {
            if (allPartitions[i].getTableSpace() == null || !allPartitions[i].getTableSpace().equals(tableSpace)) continue;
            partitionsForTS.add(allPartitions[i]);
        }
        return partitionsForTS.toArray(new PartitionDB2[0]);
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionDB2)one).getPartNumber() > ((PartitionDB2)two).getPartNumber()) {
                return 1;
            }
            if (((PartitionDB2)one).getPartNumber() < ((PartitionDB2)two).getPartNumber()) {
                return -1;
            }
            return 0;
        }
    }
}

