/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import javax.swing.Icon;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class DataBaseSetDB2
extends StorageObjectSet {
    private static final Object[] PROTO_ARRAY = new DataBaseDB2[0];

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "DB";
    }

    public DataBaseDB2 createDataBase() {
        return this.createDataBase(null);
    }

    public DataBaseDB2 createDataBase(String id) {
        DataBaseDB2 db = new DataBaseDB2(this.getStorageDesign());
        return this.initialize(db, id);
    }

    private DataBaseDB2 initialize(DataBaseDB2 db, String id) {
        db.setObjectID(id);
        db.setName(this.createName());
        db.setDesign(this.getDesign());
        db.setParent(this);
        this.add(db);
        return db;
    }

    @Override
    public ModelIDObject createElement(String id) {
        return this.createDataBase(id);
    }

    public void initializeSystemObjects() {
        DataBaseDB2.SystemDataBase dsndb07 = new DataBaseDB2.SystemDataBase(this.getStorageDesign());
        DataBaseDB2.SystemDataBase dsndb04 = new DataBaseDB2.SystemDataBase(this.getStorageDesign());
        this.initialize(dsndb04, "DSNDB04");
        this.initialize(dsndb07, "DSNDB07");
        dsndb04.setOwnerDesignName(Design.getSystemDesignName());
        dsndb07.setOwnerDesignName(Design.getSystemDesignName());
        dsndb04.setTemporaryWriteable(true);
        dsndb07.setTemporaryWriteable(true);
        dsndb04.setName("DSNDB04");
        dsndb07.setName("DSNDB07");
        dsndb04.setTemporaryWriteable(false);
        dsndb07.setTemporaryWriteable(false);
        dsndb04.setIsNullInstance(true);
        dsndb07.setIsNullInstance(true);
        String name = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
        if (!(name == null || "".equalsIgnoreCase(name.trim()) || "DSNDB04".equalsIgnoreCase(name.trim()) || "DSNDB07".equalsIgnoreCase(name.trim()))) {
            DataBaseDB2 defDb = new DataBaseDB2(this.getStorageDesign());
            this.initialize(defDb, name);
            defDb.setTemporaryWriteable(true);
            defDb.setName(name);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("DATABASE_ICON", 16);
    }
}

