/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.OptimizerHint;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.ColumnViewSet;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ViewColumnPlaceHolder;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.relational.ViewIndexSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.TableViewPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class TableView
extends AbstractView
implements EditableFonts {
    private List editableFonts = new ArrayList();
    private String oidText = "";

    public TableView(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getIDPrefix() {
        return MDPreferences.getDefaultInstance().get("tableview id prefix");
    }

    @Override
    public Class getContainedClass() {
        return ColumnView.class;
    }

    @Override
    public DesignObjectSet getTableSet() {
        return ((RelationalDesign)this.getDesignPart()).getTableSet();
    }

    public ColumnViewSet getColumnViewSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnViewSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnViewSet();
    }

    @Override
    protected KeyObjectSet createKeySet() {
        return new ViewIndexSet(this.getDesignPart(), this);
    }

    @Override
    public ContainedObject createContainedObject(String id) {
        ColumnView column = new ColumnView(this.getDesignPart());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        if (id != null) {
            column.setObjectID(id);
        }
        column.setDesignObjectSet(this.getColumnViewSet());
        this.add(column);
        this.getColumnViewSet().add(column);
        if (id != null) {
            column.setObjectID(id);
        }
        return column;
    }

    @Override
    public void add(ContainedObject object) {
        if (!this.exists(object)) {
            if (object instanceof ColumnView) {
                if (object.getObjectID() == null) {
                    this.assignLocalID(object);
                }
                object.setDesign(this.getDesign());
                if (!this.isBackup() && this.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
                    this.getColumnViewSet().add(object);
                }
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), object));
                super.add(object);
                if (((ColumnView)object).getReferencedColumn() != null) {
                    ((ColumnView)object).getReferencedColumn().addObjectListener(this);
                }
                if (((ColumnView)object).getReferencedColumnView() != null) {
                    ((ColumnView)object).getReferencedColumnView().addObjectListener(this);
                }
                if (((ColumnView)object).getView() != null && ((ColumnView)object).getView() != this) {
                    ContainedObject[] cols = ((ColumnView)object).getView().getElements();
                    for (int i = 0; i < cols.length; ++i) {
                        if (((ColumnView)cols[i]).getReferencedColumn() != ((ColumnView)object).getReferencedColumn()) continue;
                        cols[i].addObjectListener(this);
                    }
                }
            } else {
                ColumnView adapter = new ColumnView(this.getDesignPart());
                adapter.setObjectID(this.getDesign().getAppView().getIDGenerator().createNewID());
                adapter.setName(object.getName());
                adapter.setNameHasQuotes(object.getNameHasQuotes());
                adapter.setDesign(this.getDesign());
                adapter.setReferencedColumn((Column)object);
                adapter.setDataType(((Column)object).getDataType().toString());
                adapter.setContainer(this);
                adapter.setTable((Table)object.getContainer());
                if (!this.isBackup() && this.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
                    this.getColumnViewSet().add(adapter);
                }
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), adapter));
                super.add(adapter);
                if (adapter.getView() != this) {
                    adapter.addObjectListener(this);
                }
            }
            object.addObjectListener(this);
        }
    }

    public ColumnView columnViewAdd(ContainedObject object) {
        if (!this.exists(object)) {
            if (object instanceof ColumnView) {
                if (object.getObjectID() == null) {
                    this.assignLocalID(object);
                }
                object.setDesign(this.getDesign());
                this.getColumnViewSet().add(object);
                this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), object));
                super.add(object);
                if (((ColumnView)object).getReferencedColumn() != null) {
                    ((ColumnView)object).getReferencedColumn().addObjectListener(this);
                }
                if (((ColumnView)object).getView() != null && ((ColumnView)object).getView() != this) {
                    ContainedObject[] cols = ((ColumnView)object).getView().getElements();
                    for (int i = 0; i < cols.length; ++i) {
                        if (((ColumnView)cols[i]).getReferencedColumn() != ((ColumnView)object).getReferencedColumn()) continue;
                        cols[i].addObjectListener(this);
                    }
                }
                return (ColumnView)object;
            }
            ColumnView adapter = new ColumnView(this.getDesignPart());
            adapter.setObjectID(this.getDesign().getAppView().getIDGenerator().createNewID());
            adapter.setName(object.getName());
            adapter.setNameHasQuotes(object.getNameHasQuotes());
            adapter.setDesign(this.getDesign());
            adapter.setReferencedColumn((Column)object);
            adapter.setDataType(((Column)object).getDataType().toString());
            this.getColumnViewSet().add(adapter);
            adapter.setContainer(this);
            adapter.setTable((Table)object.getContainer());
            this.phelements.add(new ViewColumnPlaceHolder(this.getDesignPart(), adapter));
            super.add(adapter);
            if (adapter.getView() != this) {
                adapter.addObjectListener(this);
            }
            object.addObjectListener(this);
            return adapter;
        }
        return null;
    }

    private boolean exists(ContainedObject object) {
        if (object instanceof ColumnView) {
            return this.getElementsCollection().contains(object);
        }
        for (ColumnView contained : this.getElementsCollection()) {
            if (object != contained.getReferencedColumn()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove(ContainedObject object) {
        this.phelements.removePlaceHolderFor(object);
        this.removeFromOrderBy(object);
        super.remove(object);
        this.getColumnViewSet().remove(object);
    }

    @Override
    public void addToOrderBy(ContainedObject object, String sortOrder) {
        if (object.getObjectID() == null) {
            this.assignLocalID(object);
        }
        object.setContainer(this);
        this.getColumnViewSet().add(object);
        this.orderByMap.put(object.getObjectID(), sortOrder);
        this.orderByList.add(object);
        if (((AbstractViewElement)object).getReferencedColumn() != null) {
            ((AbstractViewElement)object).getReferencedColumn().addObjectListener(this);
        }
    }

    public ContainedObject[] getColumns() {
        return this.getElements();
    }

    public ColumnView getColumnByObjectID(String objectID) {
        for (ColumnView contained : this.getElementsCollection()) {
            if (!contained.getObjectID().equals(objectID)) continue;
            return contained;
        }
        return null;
    }

    @Override
    public void addToContainers(ContainerObject container, String alias) {
        this.containerMap.put(alias, container.getObjectID());
        if (container instanceof Table) {
            if (!this.tables.contains(container)) {
                this.tables.add(container);
                this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
            }
        } else if (container instanceof TableView && !this.views.contains(container)) {
            this.views.add(container);
            this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
        }
        container.addObjectListener(this);
    }

    @Override
    public void clearContainers() {
        this.containerMap.clear();
        this.tables.clear();
        this.views.clear();
        this.usedContainers.clear();
    }

    @Override
    public void addToContainers(String objectID, String alias) {
        this.containerMap.put(alias, objectID);
        ContainerObject container = (ContainerObject)this.getTableSet().getObjectByID(objectID);
        if (container != null) {
            if (!this.tables.contains(container)) {
                this.tables.add(container);
            }
            this.usedContainers.add(new AbstractView.ContainerHolder(container, alias));
            container.addObjectListener(this);
            this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
        } else {
            TableView v = (TableView)((RelationalDesign)this.getDesignPart()).getTableViewSet().getObjectByID(objectID);
            if (v != null) {
                if (!this.views.contains(v)) {
                    this.views.add(v);
                }
                this.usedContainers.add(new AbstractView.ContainerHolder(v, alias));
                v.addObjectListener(this);
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
            } else {
                this.getViewsNotAdded().add(new AbstractView.ViewNotAdded(objectID, alias));
            }
        }
    }

    public ColumnView getColumnViewByName(String name) {
        for (ColumnView contained : this.getElementsCollection()) {
            if (!contained.getName().equalsIgnoreCase(name)) continue;
            return contained;
        }
        return null;
    }

    public ColumnView getColumnViewByLongName(String name) {
        for (ColumnView contained : this.getElementsCollection()) {
            if (!contained.getLongName().equalsIgnoreCase(name)) continue;
            return contained;
        }
        return null;
    }

    public String getUserDefinedSQLAsDDL() {
        String sql = this.userDefinedSQL;
        if (!this.optimizerHints.isEmpty()) {
            String beforeSelect = Token.getStringBeforeToken(sql, "SELECT");
            String afterSelect = Token.getStringAfterToken(sql, "SELECT");
            if (!afterSelect.startsWith("/*+")) {
                for (int i = 0; i < this.optimizerHints.size(); ++i) {
                    OptimizerHint hint = (OptimizerHint)this.optimizerHints.get(i);
                    if (!hint.isOrderedHint()) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(beforeSelect).append(" SELECT /*+ ");
                    buffer.append(hint.getHint()).append(" ");
                    buffer.append("*/ ").append(afterSelect);
                    sql = buffer.toString();
                    break;
                }
            }
        }
        if (!sql.toUpperCase().startsWith("CREATE ")) {
            sql = ((RelationalDesign)this.getDesignPart()).getStorageDesign() instanceof StorageDesignOracle ? "CREATE OR REPLACE VIEW " + this.getName() + "\nAS \n" + sql : "CREATE VIEW " + this.getName() + "\nAS \n" + sql;
        }
        return sql;
    }

    @Override
    public void clear(ContainerObject container) {
        if (this.isUsedInDefinition(container)) {
            this.setValidSQL(false);
            this.setDirty(true);
        }
    }

    public void clear(ColumnView column) {
        if (column.getContainer() == this) {
            this.removeFromOrderBy(column);
            column.remove();
        }
    }

    @Override
    public void clearElements(ContainerObject container) {
        block5: {
            block4: {
                if (!(container instanceof TableView)) break block4;
                ContainedObject[] cos = container.getElements();
                for (int i = 0; i < cos.length; ++i) {
                    if (!this.getElementsCollection().contains(cos[i])) continue;
                    this.remove(cos[i]);
                }
                break block5;
            }
            if (!(container instanceof Table)) break block5;
            ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
            Iterator it = this.getElementsCollection().iterator();
            ContainedObject[] cos = container.getElements();
            block1: while (it.hasNext()) {
                ColumnView colView = (ColumnView)it.next();
                if (colView.getReferencedColumn() == null) continue;
                for (int i = 0; i < cos.length; ++i) {
                    if (colView.getReferencedColumn() != cos[i]) continue;
                    forRemove.add(colView);
                    continue block1;
                }
            }
            it = forRemove.iterator();
            while (it.hasNext()) {
                this.remove((ColumnView)it.next());
            }
        }
    }

    @Override
    public void clearOrderByElements(ContainerObject container) {
        block7: {
            block6: {
                if (!(container instanceof TableView)) break block6;
                ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
                for (ColumnView col : container.getElementsCollection()) {
                    for (ColumnView column : this.orderByList) {
                        if (col.getReferencedColumn() != column.getReferencedColumn()) continue;
                        forRemove.add(column);
                    }
                }
                Iterator it = forRemove.iterator();
                while (it.hasNext()) {
                    this.removeFromOrderBy((ColumnView)it.next());
                }
                break block7;
            }
            if (!(container instanceof Table)) break block7;
            ArrayList<ColumnView> forRemove = new ArrayList<ColumnView>();
            block3: for (ColumnView colView : this.orderByList) {
                if (colView.getReferencedColumn() == null) continue;
                for (Column col : container.getElementsCollection()) {
                    if (colView.getReferencedColumn() != col) continue;
                    forRemove.add(colView);
                    continue block3;
                }
            }
            Iterator it = forRemove.iterator();
            while (it.hasNext()) {
                this.removeFromOrderBy((ColumnView)it.next());
            }
        }
    }

    @Override
    public void remove() {
        Iterator it = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView view = (TableView)it.next();
            view.clear(this);
        }
        try {
            for (ColumnView col : this.getElementsCollection()) {
                this.getColumnViewSet().remove(col);
            }
            ArrayList<ColumnView> forDelete = new ArrayList<ColumnView>();
            it = this.getColumnViewSet().iterator();
            while (it.hasNext()) {
                ColumnView col = (ColumnView)it.next();
                if (col.getView() != this) continue;
                forDelete.add(col);
            }
            for (ColumnView col : forDelete) {
                this.getColumnViewSet().remove(col);
                col.getContainer().remove(col);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.remove();
        SetEvent.OBJECT_REMOVED.setAffected(this);
        ((RelationalDesign)this.getDesignPart()).getTableViewSet().fireChange(SetEvent.OBJECT_REMOVED);
    }

    @Override
    public void remove(KeyObject key) {
        this.remove(key, true);
    }

    public void remove(KeyObject key, boolean removeFromGlobalSet) {
        if (key.isPK() || key.isUnique()) {
            this.removeDependentFKAssociations(key);
        }
        if (key.isPK()) {
            this.pkSet.remove(key);
            this.setPK(null);
        }
        if (key.isFK() && ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().contains(key.getFKAssociation())) {
            this.removeFKAssociation(key.getFKAssociation());
        }
        if (removeFromGlobalSet) {
            ((RelationalDesign)this.getDesignPart()).getGlobalIndexSet().remove(key);
        }
        super.remove(key);
        key.clearElements();
    }

    public void removeDependentFKAssociations(KeyObject pk) {
        Collection col = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(pk);
        for (FKIndexAssociation fkass : col) {
            fkass.removeAllFKElements();
            KeyObject key = fkass.getLocalFKIndex();
            ContainerWithKeyObject keyContainer = key.getContainerWithKeyObject();
            if (keyContainer instanceof TableView) {
                ((TableView)keyContainer).removeFKAssociation(fkass);
            } else if (keyContainer instanceof Table) {
                ((Table)keyContainer).removeFKAssociation(fkass);
            }
            ((ContainerWithKeyObject)key.getTopLevelContainer()).remove(key);
        }
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (SetEvent.OBJECT_REMOVED.equals(event) && event.getAffected() instanceof ContainerObject) {
            ((ContainerObject)event.getAffected()).removeContainerListener(this);
        }
        if (set instanceof StructuredTypeSet || set instanceof SchemaObjectSet) {
            super.changed(set, event);
            return;
        }
    }

    protected void invalidateLinkedViews() {
        Iterator it = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView tableView = (TableView)it.next();
            if (tableView == null || !tableView.isValidSQL() || !tableView.sqlNameExists(this.getObjectID())) continue;
            tableView.setValidSQL(false);
            tableView.invalidateLinkedViews();
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        boolean containsObject = false;
        if (!ApplicationView.loading && (event.isType(ObjectChangeEvent.OBJECT_REMOVED) || event.isType(ObjectChangeEvent.NAME_CHANGED) || event.isType(ObjectChangeEvent.SCHEMA_CHANGED))) {
            if (this.sqlNameExists(object.getObjectID())) {
                containsObject = true;
            } else if (object instanceof Column) {
                for (ColumnView colView : this.getElementsCollection()) {
                    if (colView.getReferencedColumn() != object) continue;
                    containsObject = true;
                    break;
                }
            } else if (object instanceof ColumnView) {
                for (ColumnView colView : this.getElementsCollection()) {
                    if (colView != object && colView.getReferencedColumnView() != object) continue;
                    containsObject = true;
                    break;
                }
            }
            if (containsObject) {
                boolean changed = this.isSQLNamesChanged();
                this.setValidSQL(!changed);
                if (!this.isValidSQL()) {
                    this.invalidateLinkedViews();
                }
            }
        }
    }

    @Override
    public void copy(DesignObject desObject) {
        this.copy(desObject, null, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap) {
        this.copy(desObject, copyMap, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        this.copy(desObject, copyMap, remoteObject, false);
    }

    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject, boolean targetIsRemoteObject) {
        ColumnView col;
        boolean revRemote;
        TableView view = (TableView)desObject;
        super.copy(view);
        boolean bl = revRemote = targetIsRemoteObject && !this.isRemoteObject();
        if (revRemote) {
            this.setRemoteObjectID(view.getObjectID());
            this.setRemoteModelID(view.getRelationalModel().getObjectID());
            this.setRemoteDesignID(this.getDesign().getObjectID());
            this.setRemoteObjectRelativeStorageName(view.getRelativeStorageName());
            this.setDirty(true);
        }
        view.setBasedOnStructuredType(this.getBasedOnStructuredType());
        view.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
        view.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
        view.setSyntaxProvider(this.getSyntaxProvider());
        view.setWhere(this.getWhere());
        view.setGroupBy(this.getGroupBy());
        view.setHaving(this.getHaving());
        view.setUserDefined(this.getUserDefined());
        view.setUserDefinedSQL(this.getUserDefinedSQL(view.getName()));
        view.setOptimizerHints(this.getOptimizerHints());
        view.setOidText(this.getOidText());
        view.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        view.setBeforeDrop(this.getBeforeDrop());
        view.setBeforeCreate(this.getBeforeCreate());
        view.setAfterCreate(this.getAfterCreate());
        view.setEndOfScript(this.getEndOfScript());
        view.setShouldGenerateScript(this.getShouldGenerateScript());
        for (String alias : this.getContainerMap().keySet()) {
            String cID = this.getContainerID(alias);
            view.addToContainers(cID, alias);
        }
        if (!this.isBST()) {
            if (remoteObject) {
                ContainedObject[] columns = view.getElements();
                for (int i = columns.length - 1; i >= 0; --i) {
                    ContainedObject rc;
                    ContainedObject column = columns[i];
                    String rcID = column.getRemoteObjectID();
                    if ("".equalsIgnoreCase(rcID) || (rc = this.getElementByID(rcID)) != null) continue;
                    column.remove();
                }
            }
            view.getElementsCollection().clear();
            ContainedObject[] cos = this.getElements();
            for (int i = 0; i < cos.length; ++i) {
                ColumnView old = (ColumnView)cos[i];
                ColumnView col2 = new ColumnView(this.getDesignPart());
                if (remoteObject) {
                    if (old.isRemoteObject()) {
                        col2.setRemoteObjectID(old.getRemoteObjectID());
                    } else {
                        col2.setRemoteObjectID(old.getObjectID());
                    }
                }
                if (revRemote) {
                    old.setRemoteObjectID(col2.getObjectID());
                }
                old.copy(col2);
                col2.setView(view);
                col2.setContainer(view);
                view.add(col2);
                if (copyMap == null) continue;
                copyMap.put(old.getObjectID(), col2);
            }
        }
        for (String id : this.getOrderByMap().keySet()) {
            ColumnView columnView = (ColumnView)this.getObjectByID(this.orderByList, id);
            if (columnView != null) {
                col = new ColumnView(this.getDesignPart());
                columnView.copy(col);
                col.setView(view);
                view.addToOrderBy(col, (String)this.getOrderByMap().get(id));
                if (copyMap == null) continue;
                copyMap.put(columnView.getObjectID(), col);
                continue;
            }
            System.out.println("TableView.copy: Unable to find ColumnView: " + id);
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            col = (ColumnView)this.getGroupByList().get(i);
            view.addGroupByList(col);
        }
        for (int i = 0; i < this.getKeys().length; ++i) {
            KeyObject key = null;
            KeyObject oldKey = this.getKeys()[i];
            if (oldKey.isFK() && !remoteObject || oldKey instanceof ViewIndex && "Foreign Key".equalsIgnoreCase(oldKey.getIndexState())) continue;
            if (key == null && (key = (KeyObject)view.getKeySet().getObjectByRemoteObjectID(oldKey.getObjectID())) == null) {
                key = view.createKeyObject();
            }
            oldKey.copy(key);
            if (remoteObject) {
                if (oldKey.isRemoteObject()) {
                    key.setRemoteObjectID(oldKey.getRemoteObjectID());
                } else {
                    key.setRemoteObjectID(oldKey.getObjectID());
                }
            }
            if (revRemote) {
                oldKey.setRemoteObjectID(key.getObjectID());
            }
            key.setContainerObject(view);
            if (oldKey instanceof ViewIndex) {
                key.setIndexState(oldKey.getIndexState());
            }
            if (copyMap == null) continue;
            copyMap.put(oldKey.getObjectID(), key);
        }
        view.clearContainers();
        Object[] obj = this.containerMap.keySet().toArray();
        for (int i = obj.length - 1; i >= 0; --i) {
            String alias = (String)obj[i];
            String containerID = (String)this.containerMap.get(alias);
            view.addToContainers(containerID, alias);
        }
        view.setParsed(this.isParsed());
        view.setValidSQL(this.isValidSQL());
        view.setIncorrectSQL(this.isIncorrectSQL());
        if (this.getDesignPart() == view.getDesignPart()) {
            this.copySQLNames(view);
        }
        view.setORDSEnable(this.isORDSEnable());
        view.setORDSAuth(this.isORDSAuth());
        view.setORDSAlias(this.getORDSAlias());
    }

    @Override
    public void importView(DesignObject desObject) {
        ColumnView col;
        TableView view = (TableView)desObject;
        super.copy(view);
        view.setBasedOnStructuredType(this.getBasedOnStructuredType());
        view.setWhere(this.getWhere());
        view.setGroupBy(this.getGroupBy());
        view.setHaving(this.getHaving());
        view.setUserDefined(this.getUserDefined());
        view.setUserDefinedSQL(this.getUserDefinedSQL());
        view.setOptimizerHints(this.getOptimizerHints());
        for (String alias : this.getContainerMap().keySet()) {
            String cID = this.getContainerID(alias);
            DesignObject object = view.getDesign().getCorrObject(cID);
            if (object == null) continue;
            view.addToContainers(object.getObjectID(), alias);
        }
        for (String id : this.getOrderByMap().keySet()) {
            ColumnView key = (ColumnView)this.getObjectByID(this.orderByList, id);
            if (key != null) {
                Column newColumn;
                ColumnView col2 = new ColumnView(this.getDesignPart());
                Column oldColumn = (Column)key.getReferencedColumn();
                if (oldColumn != null && (newColumn = (Column)view.getDesign().getCorrObject(oldColumn.getObjectID())) != null) {
                    col2.setReferencedColumn(newColumn);
                    col2.setName(key.getName());
                    col2.setNameHasQuotes(key.getNameHasQuotes());
                    col2.setDataType(newColumn.getDataType().toString());
                    col2.setTable((Table)newColumn.getContainer());
                    col2.setView(view);
                    col2.setDesign(view.getDesign());
                    view.addToOrderBy(col2, (String)this.getOrderByMap().get(id));
                }
                col2.setImportedDesign(this.getDesign());
                col2.setImportedId(key.getObjectID());
                continue;
            }
            System.out.println("TableView.copy: Unable to find ColumnView: " + id);
        }
        if (!this.isBST()) {
            for (int i = 0; i < this.getElements().length; ++i) {
                Table table;
                Column newColumn;
                col = new ColumnView(view.getDesignPart());
                ColumnView oldColumnView = (ColumnView)this.getElements()[i];
                Column oldColumn = (Column)oldColumnView.getReferencedColumn();
                if (oldColumn != null && (newColumn = (Column)view.getDesign().getCorrObject(oldColumn.getObjectID())) != null) {
                    col.setReferencedColumn(newColumn);
                }
                col.setName(oldColumnView.getName());
                col.setNameHasQuotes(oldColumnView.getNameHasQuotes());
                col.setDataType(oldColumnView.getDataType().toString());
                if (oldColumnView.getTable() != null && (table = (Table)view.getDesign().getCorrObject(oldColumnView.getTable().getObjectID())) != null) {
                    col.setTable(table);
                }
                col.setView(view);
                col.setDesign(view.getDesign());
                col.setContainer(view);
                view.add(col);
                col.setImportedDesign(this.getDesign());
                col.setImportedId(oldColumnView.getObjectID());
            }
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            ColumnView newcol;
            col = (ColumnView)this.getGroupByList().get(i);
            if (col == null || (newcol = (ColumnView)view.getDesign().getCorrObject(col.getObjectID())) == null) continue;
            view.addGroupByList(newcol);
        }
        view.setORDSEnable(this.isORDSEnable());
        view.setORDSAuth(this.isORDSAuth());
        view.setORDSAlias(this.getORDSAlias());
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TableViewPropertiesDialogEx dialog = new TableViewPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public void updateElements(List telems) {
        for (int i = 0; i < telems.size(); ++i) {
            TypeElement te = (TypeElement)telems.get(i);
            ColumnView column = (ColumnView)this.getElementByStructAttributeID(te.getObjectID());
            if (column == null) {
                column = new ColumnView(this.getDesignPart());
                column.setName(te.getName());
                column.setNameHasQuotes(te.getNameHasQuotes());
                column.setStructAttributeID(te.getObjectID());
                column.setAlias(te.getName());
                this.addColumn(column);
            }
            this.copyTEtoColumn(te, column);
        }
    }

    private void copyTEtoColumn(TypeElement te, ColumnView column) {
        column.setName(te.getName());
        column.setNameHasQuotes(te.getNameHasQuotes());
        column.setDataType(te.getDataType(this.getDesignPart().getSelectedRDBMSSite().getName()));
        column.setReference(te.isReference());
        column.setTypeElement(te);
        if (te.getType() instanceof StructuredType) {
            column.setStructuredType((StructuredType)te.getType());
        } else {
            column.setStructuredType(null);
        }
    }

    public void addColumn(ColumnView column) {
        column.setDesign(this.getDesign());
        column.setContainer(this);
        this.add(column);
    }

    public List getRefColumns() {
        ArrayList<ColumnView> list = new ArrayList<ColumnView>();
        if (this.isBST()) {
            ContainedObject[] columns = this.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                ColumnView col = (ColumnView)columns[i];
                if (!col.isReference()) continue;
                list.add(col);
            }
        }
        return list;
    }

    public void getColumns(String statement) {
        this.getElements(statement);
    }

    @Override
    public AbstractViewElement createViewElement(DesignPart designPart) {
        return new ColumnView(designPart);
    }

    public XtdMapping getDeletedMapping() {
        List list = this.getRMExtendedMap().getDeletedMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    public EntityView getEngEntityView() {
        XtdMapping mapping;
        DesignObject obj;
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof EntityView) {
            return (EntityView)obj;
        }
        EntityView entView = (EntityView)this.getGenerator();
        if (entView == null) {
            if (!"User generated".equalsIgnoreCase(this.getGeneratorID())) {
                entView = (EntityView)this.getDesign().getLogicalDesign().getEntityViewSet().getObjectByID(this.getGeneratorID());
            }
            if (entView == null) {
                entView = (EntityView)this.getDesign().getLogicalDesign().getEntityViewSet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return entView;
    }

    @Override
    public void updateDeletedMappings(String oldContainerID, String recreatedID, String designPartID) {
        for (ContainedObject co : this.getElementsCollection()) {
            XtdMapping mapping = co.getDeletedMapping(oldContainerID, designPartID);
            if (mapping == null) continue;
            mapping.setRecreatedContainerID(recreatedID);
        }
    }

    @Override
    public String getFCObjectType() {
        return "Relational View";
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public String getOidText() {
        return this.oidText;
    }

    public void setOidText(String oidText) {
        this.oidText = oidText;
    }

    @Override
    protected String appendQuotes(String name) {
        StorageDesign sd = ((RelationalDesign)this.getDesignPart()).getStorageDesign();
        if (sd != null) {
            return sd.getFormatedName(name);
        }
        return super.appendQuotes(name);
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "view" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getLongName() {
        if (this.getSchemaObject() != null) {
            return new StringBuffer(this.getSchemaObject().getName()).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public boolean canSetSchemaToTablesOnRE() {
        if (this.includeSchemaNameInQuery()) {
            return true;
        }
        if (this.getSchemaObject() == null) {
            for (SQLNameHelper helper : this.getSQLNames()) {
                DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
                if (desObj == null || !(desObj instanceof ContainerObject) || desObj.getSchema() == null) continue;
                return true;
            }
        }
        return false;
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public DesignObject getTempObject() {
        return new TableView(this.getDesignPart());
    }

    @Override
    public boolean hasValidHeader() {
        boolean result = false;
        Iterator it = this.getElementsCollection().iterator();
        if (it.hasNext()) {
            boolean allHaveHeaders = true;
            while (it.hasNext()) {
                ColumnView cv = (ColumnView)it.next();
                String ch = cv.getHeaderAlias();
                if (ch == null || ch.trim().length() == 0) {
                    allHaveHeaders = false;
                    continue;
                }
                if (ch.trim().equals(cv.getPresentationName(false))) continue;
                return true;
            }
            result = allHaveHeaders;
        }
        return result;
    }

    public List<String> getHeaderAliases() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.isBST()) {
            ContainedObject[] elements = this.getElements();
            for (int i = 0; i < elements.length; ++i) {
                String headerAlias = ((AbstractViewElement)elements[i]).getPresentationName(true);
                result.add(headerAlias);
            }
        }
        return result;
    }

    @Override
    public KeyObject createKeyObject(String id) {
        return this.createIndex(id);
    }

    public ViewIndex createIndex() {
        ViewIndex key = this.createIndex(null);
        return key;
    }

    @Override
    public KeyObject[] getKeyArrayPrototype() {
        return Table.KEY_PROTOTYPE;
    }

    public ViewIndex createIndex(String id) {
        ViewIndex key = new ViewIndex(this.getDesignPart());
        key.setBackup(this.isBackup());
        key.setObjectID(id);
        this.add(key);
        return key;
    }

    public void backupTo(TableView tableView) {
        ColumnView col;
        ColumnView old;
        tableView.setBackup(true);
        super.copy(tableView);
        tableView.setObjectID(this.getObjectID());
        tableView.setBasedOnStructuredType(this.getBasedOnStructuredType());
        tableView.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
        tableView.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
        tableView.setSyntaxProvider(this.getSyntaxProvider());
        tableView.setWhere(this.getWhere());
        tableView.setGroupBy(this.getGroupBy());
        tableView.setHaving(this.getHaving());
        tableView.setUserDefined(this.getUserDefined());
        tableView.setUserDefinedSQL(this.getUserDefinedSQL(tableView.getName()));
        tableView.setOptimizerHints(this.getOptimizerHints());
        tableView.setOidText(this.getOidText());
        tableView.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        tableView.setBeforeDrop(this.getBeforeDrop());
        tableView.setBeforeCreate(this.getBeforeCreate());
        tableView.setAfterCreate(this.getAfterCreate());
        tableView.setEndOfScript(this.getEndOfScript());
        tableView.setShouldGenerateScript(this.getShouldGenerateScript());
        tableView.setCreatedTime(this.getCreatedTime());
        tableView.setCreatedBy(this.getCreatedBy());
        for (String alias : this.getContainerMap().keySet()) {
            String cID = this.getContainerID(alias);
            tableView.addToContainers(cID, alias);
        }
        for (String id : this.getOrderByMap().keySet()) {
            old = (ColumnView)this.getObjectByID(this.orderByList, id);
            if (old != null) {
                ColumnView col2 = new ColumnView(this.getDesignPart());
                old.copy(col2);
                col2.setView(tableView);
                tableView.addToOrderBy(col2, (String)this.getOrderByMap().get(id));
                continue;
            }
            System.out.println("TableView.backupTo: Unable to find ColumnView: " + id);
        }
        for (int i = 0; i < this.getGroupByList().size(); ++i) {
            col = (ColumnView)this.getGroupByList().get(i);
            tableView.addGroupByList(col);
        }
        tableView.getElementsCollection().clear();
        ContainedObject[] cos = this.getElements();
        for (int i = 0; i < cos.length; ++i) {
            old = (ColumnView)cos[i];
            col = new ColumnView(this.getDesignPart());
            old.copy(col);
            col.setView(tableView);
            col.setContainer(tableView);
            col.setObjectID(old.getObjectID());
            tableView.add(col);
            col.setCreatedTime(old.getCreatedTime());
            col.setCreatedBy(old.getCreatedBy());
        }
        tableView.clearContainers();
        Object[] obj = this.containerMap.keySet().toArray();
        for (int i = obj.length - 1; i >= 0; --i) {
            String alias = (String)obj[i];
            String containerID = (String)this.containerMap.get(alias);
            tableView.addToContainers(containerID, alias);
        }
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            ViewIndex key = null;
            ViewIndex oldKey = (ViewIndex)keys[i];
            if (oldKey.isFK()) continue;
            if (oldKey.isOidKey()) {
                key = (ViewIndex)tableView.getOidKey();
            }
            if (key == null) {
                key = (ViewIndex)tableView.createKeyObject();
            }
            if (oldKey.isOidKey() && key != null) {
                key.setOidKey(true);
            }
            String tempKeyName = key.getName();
            String origKeyName = oldKey.getName();
            oldKey.copy(key);
            key.setContainerObject(tableView);
            tableView.getKeySet().changeName(null, tempKeyName, origKeyName, key);
            key.setObjectID(oldKey.getObjectID());
            key.setIndexState(oldKey.getIndexState());
            if (oldKey.isPK()) {
                key.getContainerWithKeyObject().setPK(key);
            }
            key.setNameFixed(oldKey.isNameFixed());
            key.setCreatedTime(oldKey.getCreatedTime());
            key.setCreatedBy(oldKey.getCreatedBy());
        }
        tableView.setParsed(this.isParsed());
        tableView.setValidSQL(this.isValidSQL());
        tableView.setIncorrectSQL(this.isIncorrectSQL());
        if (this.getDesignPart() == tableView.getDesignPart()) {
            this.copySQLNames(tableView);
        }
        tableView.setORDSEnable(this.isORDSEnable());
        tableView.setORDSAuth(this.isORDSAuth());
        tableView.setORDSAlias(this.getORDSAlias());
    }

    public void restoreTo(TableView tableView) {
        int i;
        ColumnView col;
        super.copy(tableView);
        tableView.setBasedOnStructuredType(this.getBasedOnStructuredType());
        tableView.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
        tableView.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
        tableView.setSyntaxProvider(this.getSyntaxProvider());
        tableView.setWhere(this.getWhere());
        tableView.setGroupBy(this.getGroupBy());
        tableView.setHaving(this.getHaving());
        tableView.setUserDefined(this.getUserDefined());
        tableView.setUserDefinedSQL(this.getUserDefinedSQL(tableView.getName()));
        tableView.setOptimizerHints(this.getOptimizerHints());
        tableView.setOidText(this.getOidText());
        tableView.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        tableView.setBeforeDrop(this.getBeforeDrop());
        tableView.setBeforeCreate(this.getBeforeCreate());
        tableView.setAfterCreate(this.getAfterCreate());
        tableView.setEndOfScript(this.getEndOfScript());
        tableView.setShouldGenerateScript(this.getShouldGenerateScript());
        tableView.setCreatedTime(this.getCreatedTime());
        tableView.setCreatedBy(this.getCreatedBy());
        for (String alias : this.getContainerMap().keySet()) {
            String cID = this.getContainerID(alias);
            tableView.addToContainers(cID, alias);
        }
        for (String id : this.getOrderByMap().keySet()) {
            ColumnView cvkey = (ColumnView)this.getObjectByID(this.orderByList, id);
            if (cvkey != null) {
                ColumnView col2 = new ColumnView(this.getDesignPart());
                cvkey.copy(col2);
                col2.setView(tableView);
                tableView.addToOrderBy(col2, (String)this.getOrderByMap().get(id));
                continue;
            }
            System.out.println("TableView.restoreTo: Unable to find ColumnView: " + id);
        }
        for (int i2 = 0; i2 < this.getGroupByList().size(); ++i2) {
            col = (ColumnView)this.getGroupByList().get(i2);
            tableView.addGroupByList(col);
        }
        if (!this.isBST()) {
            tableView.getElementsCollection().clear();
            ContainedObject[] cos = this.getElements();
            for (i = 0; i < cos.length; ++i) {
                col = new ColumnView(this.getDesignPart());
                cos[i].copy(col);
                col.setView(tableView);
                col.setContainer(tableView);
                col.setObjectID(cos[i].getObjectID());
                tableView.add(col);
                col.setCreatedTime(cos[i].getCreatedTime());
                col.setCreatedBy(cos[i].getCreatedBy());
            }
        }
        tableView.clearContainers();
        Object[] obj = this.containerMap.keySet().toArray();
        for (i = obj.length - 1; i >= 0; --i) {
            String alias = (String)obj[i];
            String containerID = (String)this.containerMap.get(alias);
            tableView.addToContainers(containerID, alias);
        }
        KeyObject[] keys = this.getKeys();
        for (int i3 = 0; i3 < keys.length; ++i3) {
            ViewIndex key = null;
            ViewIndex oldKey = (ViewIndex)keys[i3];
            if (oldKey.isFK()) continue;
            if (oldKey.isOidKey()) {
                key = (ViewIndex)tableView.getOidKey();
            }
            if (key == null) {
                key = (ViewIndex)tableView.createKeyObject();
            }
            if (oldKey.isOidKey() && key != null) {
                key.setOidKey(true);
            }
            String tempKeyName = key.getName();
            String origKeyName = oldKey.getName();
            oldKey.copy(key);
            key.setContainerObject(tableView);
            tableView.getKeySet().changeName(null, tempKeyName, origKeyName, key);
            key.setObjectID(oldKey.getObjectID());
            key.setIndexState(oldKey.getIndexState());
            if (oldKey.isPK()) {
                key.getContainerWithKeyObject().setPK(key);
            }
            key.setNameFixed(oldKey.isNameFixed());
            key.setCreatedTime(oldKey.getCreatedTime());
            key.setCreatedBy(oldKey.getCreatedBy());
        }
        tableView.setParsed(this.isParsed());
        tableView.setValidSQL(this.isValidSQL());
        tableView.setIncorrectSQL(this.isIncorrectSQL());
        if (this.getDesignPart() == tableView.getDesignPart()) {
            this.copySQLNames(tableView);
        }
        tableView.setORDSEnable(this.isORDSEnable());
        tableView.setORDSAuth(this.isORDSAuth());
        tableView.setORDSAlias(this.getORDSAlias());
    }

    public void backupFKeysTO(TableView backupTable, DesignPartView dpv) {
        FKIndexAssociation[] fkeys = this.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            FKIndexAssociation fk = fkeys[i];
            if (fk.getRemoteIndex() == null) continue;
            FKIndexAssociation bfk = backupTable.addBackupFK(fk);
            fk.backupTo(bfk, dpv);
            bfk.setCreatedTime(fk.getCreatedTime());
            bfk.setCreatedBy(fk.getCreatedBy());
        }
    }

    public FKIndexAssociation addBackupFK(FKIndexAssociation originatingFK) {
        return this.addFK(originatingFK.getRemoteIndex(), null, null, originatingFK);
    }

    @Override
    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID, FKIndexAssociationReference reference, FKIndexAssociation originatingFK) {
        FKIndexAssociation association = new FKIndexAssociation(this.getDesignPart(), originatingFK);
        if (reference != null) {
            reference.setObject(association);
        }
        if (!association.isBackupFK()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        association.setDesign(this.getDesign());
        this.assignLocalID(association);
        if (!this.isBackup()) {
            this.getDesign().addDesignObject(association);
        }
        association.setKeyObject(fkObject);
        association.setGeneratorID(generatorID);
        association.setDeleteRule(this.getDesign().getAppView().getSettings().getDefaultFKDeleteRule());
        this.addFKAssociation(association);
        this.addToMap(generatorID, association);
        KeyObject ind = association.getLocalFKIndex();
        if (ind != null) {
            if (generatorID == null) {
                generatorID = "User generated";
            }
            ind.setGeneratorID(generatorID);
        }
        return association;
    }

    public List getAllInds_PK_UK_NoFKeys() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isFK()) continue;
            list.add(key);
        }
        return list;
    }

    public List getAllInds_FKeyInds() {
        ArrayList<ViewIndex> list = new ArrayList<ViewIndex>();
        ArrayList<ViewIndex> plain = new ArrayList<ViewIndex>();
        ArrayList<ViewIndex> fk = new ArrayList<ViewIndex>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            ViewIndex index = (ViewIndex)it.next();
            if (index.isPK()) {
                list.add(0, index);
                continue;
            }
            if (index.isUnique()) {
                list.add(index);
                continue;
            }
            if (index.isFK()) {
                fk.add(index);
                continue;
            }
            plain.add(index);
        }
        list.addAll(plain);
        list.addAll(fk);
        return list;
    }

    public void applyIndexOrderFromList(List orderedIndexes) {
        this.getKeySet().applyOrderFromList(orderedIndexes);
    }

    @Override
    public List getPKandUKConstraints() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isPK() && !key.isUnique()) continue;
            list.add(key);
        }
        return list;
    }

    public ColumnView createColumn(String name, String id) {
        ColumnView column = new ColumnView(this.getDesignPart());
        column.setBackup(this.isBackup());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        if (id != null) {
            column.setObjectID(id);
        }
        this.add(column);
        if (name != null) {
            column.setName(name);
        }
        return column;
    }

    public void removeFKAssociation(FKIndexAssociation fkAssociation) {
        fkAssociation.removeAllFKElements();
        this.removeFKAssociationFromList(fkAssociation);
        this.getDesign().removeDesignObject(fkAssociation);
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().remove(fkAssociation);
        this.removeContainerListener(fkAssociation);
        if (fkAssociation.getOriginalContainer() != null) {
            fkAssociation.getOriginalContainer().removeContainerListener(fkAssociation);
            fkAssociation.removeObjectListener(fkAssociation.getOriginalContainer());
        }
        if (fkAssociation.getKeyObject() != null) {
            fkAssociation.getKeyObject().removeObjectListener(this);
            fkAssociation.getKeyObject().removeContainerListener(fkAssociation);
            fkAssociation.setKeyObject(null);
        }
        fkAssociation.removeObjectListener(this);
        fkAssociation.callRemoveListeners();
        ObjectChangeEvent.FKINDEX_REMOVED.setAffected(fkAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_REMOVED);
        ObjectChangeEvent.FKINDEX_REMOVED.setAffected(null);
    }

    @Override
    public void applyChangesTo(DesignObject anotherState) {
        if (anotherState instanceof TableView) {
            TableView table = (TableView)anotherState;
            table.setSchemaObject(this.getSchemaObject());
            super.applyChangesTo(anotherState);
            table.setObjectID(this.getObjectID());
            table.setTypeID(this.getTypeID());
            table.setBasedOnStructuredType(this.getBasedOnStructuredType());
            table.setAbbreviation(this.getAbbreviation());
            table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
            table.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
            table.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
            table.setSyntaxProvider(this.getSyntaxProvider());
            table.setWhere(this.getWhere());
            table.setGroupBy(this.getGroupBy());
            table.setHaving(this.getHaving());
            table.setUserDefined(this.getUserDefined());
            table.setUserDefinedSQL(this.getUserDefinedSQL());
            table.setOidText(this.getOidText());
            table.setParsed(this.isParsed());
            table.setValidSQL(this.isValidSQL());
            table.setIncorrectSQL(this.isIncorrectSQL());
            table.setRemoteObjectID(this.getRemoteObjectID());
            table.setRemoteModelID(this.getRemoteModelID());
            table.setRemoteDesignID(this.getRemoteDesignID());
            table.setRemoteObjectRelativeStorageName(this.getRemoteObjectRelativeStorageName());
            table.setBeforeDrop(this.getBeforeDrop());
            table.setBeforeCreate(this.getBeforeCreate());
            table.setAfterCreate(this.getAfterCreate());
            table.setEndOfScript(this.getEndOfScript());
            table.setShouldGenerateScript(this.getShouldGenerateScript());
            table.clearContainers();
            Object[] obj = this.containerMap.keySet().toArray();
            for (int i = obj.length - 1; i >= 0; --i) {
                String alias = (String)obj[i];
                String containerID = (String)this.containerMap.get(alias);
                table.addToContainers(containerID, alias);
            }
            table.setORDSEnable(this.isORDSEnable());
            table.setORDSAuth(this.isORDSAuth());
            table.setORDSAlias(this.getORDSAlias());
            this.copySQLNames(table);
        }
    }

    public ViewIndex getIndexByName(String indexName) {
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            ViewIndex index = (ViewIndex)keys[i];
            if (!index.getName().equals(indexName)) continue;
            return index;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FKIndexAssociation addForeignKey(KeyObject refferedKey, List localColumns) {
        FKElement[] refcols = (FKElement[])refferedKey.getColumns();
        if (refcols.length != localColumns.size()) {
            return null;
        }
        for (FKElement col : localColumns) {
            if (col.getContainer() == this) continue;
            return null;
        }
        FKIndexAssociation fk = new FKIndexAssociation(this.getDesignPart());
        NamingStandardRule nsr = this.getDesign().getNamingStandardRule();
        String fkname = ApplyNamingStandards.createFK_Name(this.getName(), (FKContainer)refferedKey.getContainerWithKeyObject(), refferedKey, this.getFKAssociationsCount(), nsr, this.getDesignPart().getName(), this.getAbbreviation(), null);
        fk.setObjectID(new GUID().toString());
        fk.setContainerWithKeyObject(this);
        fk.setName(fkname);
        boolean existingColumns = true;
        if (localColumns.size() == 0) {
            existingColumns = false;
        }
        if (existingColumns) {
            this.getDesign().setPropagatePKChahges(false);
        }
        try {
            fk.getLocalFKIndex().getElementsCollection().addAll(localColumns);
            fk.setKeyObject(refferedKey);
            fk = this.recreateFK(fk, refferedKey);
            for (int i = 0; i < refcols.length; ++i) {
                FKElement col = (FKElement)localColumns.get(i);
                col.addFKAssociation(refcols[i], fk);
            }
        }
        finally {
            if (existingColumns) {
                this.getDesign().setPropagatePKChahges(true);
            }
        }
        return fk;
    }

    public int getFKAssociationsCount() {
        return this.fkList.size();
    }

    public DesignObjectCollection getUKeys() {
        return this.unSet;
    }

    public FKIndexAssociation recreateFK(FKIndexAssociation association, KeyObject fkObject) {
        association.setDesign(this.getDesign());
        association.setContainerWithKeyObject(this);
        if (!association.isBackupFK() && !this.isBackup()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(association);
        association.setKeyObject(fkObject);
        if (!this.fkList.contains(association)) {
            this.fkList.add(association);
        }
        this.assignLocalID(association);
        this.getDesign().addDesignObject(association);
        this.addToMap(fkObject.getGeneratorID(), association);
        KeyObject key = association.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(association)) {
            this.fkSet.add(new AbstractView.DesignObjectPH_ShortName((DesignObject)association));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(association);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
        return association;
    }

    public FKIndexAssociation copyForeignKey(TableView view, FKIndexAssociation oldFK, Map copyMap) {
        FKIndexAssociation newFK = null;
        if (copyMap == null) {
            return null;
        }
        KeyObject oldRemoteIndex = oldFK.getRemoteIndex();
        if (oldRemoteIndex != null) {
            boolean copyWithinSameModel = this.getDesignPart() == view.getDesignPart();
            Object remoteKeyCopy = copyMap.get(oldRemoteIndex.getObjectID());
            if (remoteKeyCopy == null && oldRemoteIndex.isRemoteObject()) {
                remoteKeyCopy = copyMap.get(oldRemoteIndex.getRemoteObjectID());
            }
            if (copyWithinSameModel || remoteKeyCopy != null) {
                newFK = new FKIndexAssociation(view.getDesignPart());
                newFK.setBackup(this.isBackup());
                this.assignLocalID(newFK);
                KeyObject newRemoteKey = remoteKeyCopy != null ? (KeyObject)remoteKeyCopy : oldRemoteIndex;
                newFK.setKeyObject(newRemoteKey);
                KeyObject oldLocalIndex = oldFK.getLocalFKIndex();
                ViewIndex newLocalIndex = (ViewIndex)view.createIndexFK(newFK);
                for (ColumnView oldColumn : oldLocalIndex.getElementsCollection()) {
                    FKElement newRefCol;
                    Object newCol = copyMap.get(oldColumn.getObjectID());
                    FKElement oldRefColumn = oldColumn.getReferencedColumn(oldFK);
                    if (remoteKeyCopy != null) {
                        newRefCol = copyMap.get(oldRefColumn.getObjectID());
                        if (newRefCol == null) {
                            newRefCol = copyMap.get(oldRefColumn.getRemoteObjectID());
                        }
                    } else {
                        newRefCol = oldRefColumn;
                    }
                    if (!(newCol instanceof ColumnView) || !(newRefCol instanceof FKElement)) continue;
                    ColumnView newColumn = (ColumnView)newCol;
                    newColumn.addFKAssociation(newRefCol, newFK);
                    newLocalIndex.add(newColumn);
                }
                oldLocalIndex.copy(newLocalIndex);
                view.recreateFK(newFK, newRemoteKey, newLocalIndex.getObjectID(), null);
                oldFK.copy(newFK);
                if (copyWithinSameModel) {
                    String newname = FKUtilities.generateFKName((FKContainer)view, newFK.getRemoteTable(), newFK.getRemoteIndex());
                    newFK.setName(newname);
                }
                newFK.resetEdgeParams();
                if (copyMap != null) {
                    copyMap.put(oldFK.getObjectID(), newFK);
                }
            }
        }
        return newFK;
    }

    public void copyForeignKeys(TableView view, Map copyMap) {
        if (copyMap == null) {
            return;
        }
        FKIndexAssociation[] fkeys = this.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            FKIndexAssociation oldFK = fkeys[i];
            KeyObject oldRemoteIndex = oldFK.getRemoteIndex();
            if (oldRemoteIndex == null) continue;
            boolean copyWithinSameModel = this.getDesignPart() == view.getDesignPart();
            Object remoteKeyCopy = copyMap.get(oldRemoteIndex.getObjectID());
            if (!copyWithinSameModel && remoteKeyCopy == null) continue;
            FKIndexAssociation newFK = new FKIndexAssociation(view.getDesignPart());
            newFK.setBackup(this.isBackup());
            this.assignLocalID(newFK);
            KeyObject newRemoteKey = remoteKeyCopy != null ? (KeyObject)remoteKeyCopy : oldRemoteIndex;
            newFK.setKeyObject(newRemoteKey);
            KeyObject oldLocalIndex = oldFK.getLocalFKIndex();
            ViewIndex newLocalIndex = (ViewIndex)view.createIndexFK(newFK);
            for (ColumnView oldColumn : oldLocalIndex.getElementsCollection()) {
                Object newCol = copyMap.get(oldColumn.getObjectID());
                FKElement oldRefColumn = oldColumn.getReferencedColumn(oldFK);
                FKElement newRefCol = remoteKeyCopy != null ? copyMap.get(oldRefColumn.getObjectID()) : oldRefColumn;
                if (!(newCol instanceof ColumnView) || !(newRefCol instanceof ColumnView)) continue;
                ColumnView newColumn = (ColumnView)newCol;
                newColumn.addFKAssociation((ColumnView)newRefCol, newFK);
                newLocalIndex.add(newColumn);
            }
            oldLocalIndex.copy(newLocalIndex);
            view.recreateFK(newFK, newRemoteKey, newLocalIndex.getObjectID(), null);
            oldFK.copy(newFK);
            if (copyWithinSameModel) {
                String newname = FKUtilities.generateFKName((FKContainer)view, newFK.getRemoteTable(), newFK.getRemoteIndex());
                newFK.setName(newname);
            }
            newFK.resetEdgeParams();
            if (copyMap == null) continue;
            copyMap.put(oldFK.getObjectID(), newFK);
        }
    }

    @Override
    protected List<ModelIDObject> getDependentConstrainedObjects() {
        if (this.getKeySet().size() > 0) {
            ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
            Iterator it = this.getKeySet().iterator();
            while (it.hasNext()) {
                KeyObject key = (KeyObject)it.next();
                if (key.isFK()) {
                    list.add(key.getFKAssociation());
                    continue;
                }
                list.add(key);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public void addSQLNameHelpersForTable(Table table) {
        String schema = table.getSchema();
        boolean hasSchema = schema != null && schema.length() > 0;
        String tblName = table.getName();
        List list = this.getSQLNames();
        SQLNameHelper nh = new SQLNameHelper(true, false);
        nh.setTableName(tblName);
        nh.setID(table.getObjectID());
        nh.setDeprecated(table.isDeprecated());
        if (hasSchema) {
            nh.setSchema(schema);
        }
        list.add(nh);
        table.addObjectListener(this);
        for (ContainedObject co : table.getElementsCollection()) {
            nh = new SQLNameHelper(false, false);
            nh.setTableName(tblName);
            nh.setID(co.getObjectID());
            nh.setColumnName(co.getName());
            if (hasSchema) {
                nh.setSchema(schema);
            }
            list.add(nh);
            co.addObjectListener(this);
        }
    }
}

