/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import com.adbs.ast.KeywordFormat;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectPH_ShortName;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableCheckConstraintListener;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntitySet;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.TablePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class Table
extends FKContainer
implements SetListener,
EditableFonts {
    public static final String PK_INDEX = "PK_INDEX.class";
    public static final KeyObject[] KEY_PROTOTYPE = new Index[0];
    private static final Object[] INDEX_ASSOCIATION_PROTO = FKIndexAssociationSet.PROTOTYPE_ARRAY;
    private List<ColumnGroup> columnGroupsSet;
    private List pendingFKassociation = null;
    private boolean beingRecreated = false;
    private KeyObjectSet allkeys;
    private DesignObjectCollection indSet;
    private DesignObjectCollection pkSet;
    private DesignObjectCollection unSet;
    private DesignObjectCollection fkSet;
    private DesignObjectCollection indexOnlySet;
    private List checkConstraints = new ArrayList();
    private boolean userDefinedOid = true;
    private List oidPKColumns = new ArrayList();
    private boolean oidIsPK = false;
    private String splittedTableID = "";
    private String scope = "";
    private String minVolumes = "0";
    private String expectedVolumes = "0";
    private String maxVolumes = "9999999";
    private int growthPercent = 0;
    private String growthType = GROWTH_TYPES[2];
    private String normalForm = NORMAL_FORMS[3];
    private String adequatelyNormalized = YES_NO_STATES[1];
    public static final String[] GROWTH_TYPES = new String[]{"Day", "Month", "Year"};
    private static Set growthSet = null;
    public static final String[] NORMAL_FORMS = new String[]{"None", "First", "Second", "Third", "Fourth"};
    private static Set normalFormSet = null;
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private boolean isSpatialTable = false;
    private boolean allowColumnReorder = true;
    private List spatialDefinitions;
    private List<ValidTimeDimension> validTimeDimensions;
    private List editableFonts = new ArrayList();
    private String abbreviation = "";
    private Map generatedLists = new TreeMap();
    private String redactionPolicyName;
    private String redactionPolicyDefaultExpression;
    private boolean redactionPolicyEnabled = false;
    private boolean redactionPolicyGenerateInDDL;
    private boolean engineerToRelation = false;
    public static String DC_DDL_LEVEL_SINGLE_STATEMENT = "Single statement";
    public static String DC_DDL_LEVEL_DISCRIMINATOR_VALUE = "Discriminator value";
    public static String DC_DDL_LEVEL_COLUMN_LEVEL = "Column";
    public static String[] DC_DDL_GENERATION_LEVELS = new String[]{DC_DDL_LEVEL_SINGLE_STATEMENT, DC_DDL_LEVEL_DISCRIMINATOR_VALUE, DC_DDL_LEVEL_COLUMN_LEVEL};
    private boolean existDependencyGenerateInDDl = true;
    private String existDependencyGenerationLevel = DC_DDL_LEVEL_SINGLE_STATEMENT;
    private String existDependencyConstraintName = "";
    private boolean materializedQueryTable = false;
    private boolean onPrebuiltTable = false;
    private String userDefinedSQL = "";
    private List sqlNames = null;
    private boolean includeSchemaNameInQuery = false;
    private boolean validSQL = true;
    private boolean parsed = false;
    private boolean incorrectSQL = false;
    private String useObjectsOnlyFrom = "";
    private String syntaxProvider = "Oracle";
    public static final String TYPE_NAME = "Table";

    public Table(DesignPart designPart) {
        super(designPart);
        this.validTimeDimensions = new ArrayList<ValidTimeDimension>();
        this.initIndexFilters();
        this.setAllowColumnReorder(designPart.getAppView().getSettings().isDefaultAllowColumnsReorder());
    }

    public void initIndexFilters() {
        this.allkeys = this.getKeySet();
        this.indSet = new DesignObjectCollection();
        this.pkSet = new DesignObjectCollection();
        this.unSet = new DesignObjectCollection();
        this.fkSet = new DesignObjectCollection();
        this.unSet.setParent(this);
        this.pkSet.setParent(this);
        this.indSet.setParent(this);
        this.fkSet.setParent(this);
        this.indSet.setDesign(this.getDesign());
        this.indSet.setName(Messages.getString("Table.Indexes"));
        this.indSet.setParent(this);
        this.fkSet.setDesign(this.getDesign());
        this.fkSet.setName(Messages.getString("Table.ForeignKeys"));
        this.pkSet.setDesign(this.getDesign());
        this.pkSet.setName(Messages.getString("Table.PrimaryKeys"));
        this.unSet.setDesign(this.getDesign());
        this.unSet.setName(Messages.getString("Table.UniqueConstraints"));
        this.fkSet.setParent(this);
        this.allkeys.addSetListener(this);
        if (this.getDesignPart() != null) {
            this.indexOnlySet = ((RelationalDesign)this.getDesignPart()).getIndexOnlyPlaceHolderSet();
        }
        this.indSet.setElementDescriptor(Index.class);
        this.pkSet.setElementDescriptor(PK_INDEX);
        this.unSet.setElementDescriptor(Index.class);
        this.fkSet.setElementDescriptor(FKIndexAssociation.class);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public KeyObject[] getKeyArrayPrototype() {
        return KEY_PROTOTYPE;
    }

    @Override
    public Class getContainedClass() {
        return Column.class;
    }

    @Override
    public String getIDPrefix() {
        return this.getPreference("table id prefix");
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        String querySQL;
        super.changed(object, event);
        if (object instanceof Index) {
            if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
                if (!this.pkSet.containsPlaceHolderFor(object)) {
                    this.pkSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), object));
                }
                this.indSet.removePlaceHolderFor(object);
                this.indexOnlySet.removePlaceHolderFor(object);
                this.unSet.removePlaceHolderFor(object);
            } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_PK)) {
                this.pkSet.removePlaceHolderFor(object);
                if (!((Index)object).isUnique()) {
                    this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), object));
                    if (!this.isBackup()) {
                        this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), object));
                    }
                }
            }
            if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
                this.indSet.removePlaceHolderFor(object);
                this.indexOnlySet.removePlaceHolderFor(object);
                this.unSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), object));
            } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE)) {
                if (this.unSet.getNumberOfChildren() > 0) {
                    this.unSet.removePlaceHolderFor(object);
                }
                if (!((Index)object).isPK()) {
                    this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), object));
                    if (!this.isBackup()) {
                        this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), object));
                    }
                }
            }
        } else if (object instanceof FKArc) {
            if (event == ObjectChangeEvent.OBJECT_REMOVED) {
                this.removeArc((FKArc)object);
            }
        } else if (!ApplicationView.loading && (querySQL = this.getUserDefinedSQL()) != null && !querySQL.isEmpty() && (event.isType(ObjectChangeEvent.OBJECT_REMOVED) || event.isType(ObjectChangeEvent.NAME_CHANGED) || event.isType(ObjectChangeEvent.SCHEMA_CHANGED)) && this.sqlNameExists(object.getObjectID())) {
            this.setValidSQL(!this.isSQLNamesChanged());
        }
    }

    @Override
    public List getPKandUKConstraints() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (!key.isPK() && !key.isUnique()) continue;
            list.add(key);
        }
        return list;
    }

    public List getAllInds_PK_UK_NoFKeys() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject key = (KeyObject)it.next();
            if (key.isFK()) continue;
            list.add(key);
        }
        return list;
    }

    public List getAllInds_FKeyInds() {
        ArrayList<Index> list = new ArrayList<Index>();
        ArrayList<Index> plain = new ArrayList<Index>();
        ArrayList<Index> fk = new ArrayList<Index>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.isPK()) {
                list.add(0, index);
                continue;
            }
            if (index.isUnique()) {
                list.add(index);
                continue;
            }
            if (index.isFK()) {
                fk.add(index);
                continue;
            }
            plain.add(index);
        }
        list.addAll(plain);
        list.addAll(fk);
        return list;
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof StructuredTypeSet || set instanceof SchemaObjectSet) {
            super.changed(set, event);
            return;
        }
        if (event == SetEvent.OBJECT_ADDED) {
            Index index = (Index)event.getAffected();
            index.addObjectListener(this);
            if (index.isFK()) {
                if (!this.fkSet.containsPlaceHolderFor(index.getFKAssociation())) {
                    this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)index.getFKAssociation()));
                }
            } else if (!index.isUnique() && !index.isPK()) {
                this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
                if (!this.isBackup()) {
                    this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), index));
                }
            } else if (index.isUnique()) {
                this.unSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
            } else {
                this.pkSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
            }
        } else if (event == SetEvent.OBJECT_REMOVED) {
            Index obj = (Index)event.getAffected();
            if (obj.isFK()) {
                this.fkSet.removePlaceHolderFor(obj.getFKAssociation());
            } else {
                this.indSet.removePlaceHolderFor(obj);
                this.indexOnlySet.removePlaceHolderFor(obj);
                this.pkSet.removePlaceHolderFor(obj);
                this.unSet.removePlaceHolderFor(obj);
            }
        }
    }

    @Override
    public int getNumberOfChildren() {
        return super.getNumberOfChildren() + 3;
    }

    @Override
    public ModelObject getChild(int index) {
        if (index < super.getNumberOfChildren() - 1) {
            return super.getChild(index);
        }
        if (index == this.getNumberOfChildren() - 2) {
            return this.indSet;
        }
        if (index == this.getNumberOfChildren() - 3) {
            return this.unSet;
        }
        if (index == this.getNumberOfChildren() - 4) {
            return this.pkSet;
        }
        return this.fkSet;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.fkSet) {
            return this.getNumberOfChildren();
        }
        if (child == this.indSet) {
            return this.getNumberOfChildren() - 1;
        }
        if (child == this.pkSet) {
            return this.getNumberOfChildren() - 3;
        }
        if (child == this.unSet) {
            return this.getNumberOfChildren() - 2;
        }
        return super.getIndexForChild(child);
    }

    @Override
    protected KeyObjectSet createKeySet() {
        return new IndexSet(this.getDesignPart(), this);
    }

    public Column createNestedColumn() {
        Column nestedColumn = this.createColumn(null);
        this.getElementsCollection().remove(nestedColumn);
        this.getNestedElements().add(nestedColumn);
        return nestedColumn;
    }

    public Column createColumn() {
        return this.createColumn(null);
    }

    public Column createColumn(String name) {
        return this.createColumn(name, null);
    }

    @Override
    public void add(ContainedObject object) {
        super.add(object);
        if (!this.isBackup() && this.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
            this.getColumnSet().add(object);
        }
    }

    public Column createColumn(String name, String id) {
        Column column = new Column(this.getDesignPart());
        column.setBackup(this.isBackup());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        if (id != null) {
            column.setObjectID(id);
        }
        this.add(column);
        if (name != null) {
            column.setName(name);
        }
        return column;
    }

    public void addColumn(Column column) {
        column.setDesign(this.getDesign());
        column.setContainer(this);
        this.add(column);
    }

    @Override
    public ContainedObject createContainedObject(String id) {
        return this.createColumn(null, id);
    }

    @Override
    public FKElement createColumnFK(FKElement referencedColumn, FKIndexAssociation fkAss) {
        Column column = new Column(this.getDesignPart(), referencedColumn, fkAss);
        FKElement firstReferencedColumn = null;
        if (referencedColumn instanceof ColumnView) {
            firstReferencedColumn = ((ColumnView)referencedColumn).getFirstReferencedColumn();
        }
        if (firstReferencedColumn == null) {
            firstReferencedColumn = referencedColumn;
        }
        column.setDesign(this.getDesign());
        column.setPreviousColumn(false);
        column.setUse(firstReferencedColumn.getUse());
        column.setReference(firstReferencedColumn.isReference());
        column.setDomain(firstReferencedColumn.getDomain());
        column.setLogicalDatatype(firstReferencedColumn.getLogicalDatatype());
        column.setStructuredType(firstReferencedColumn.getStructuredType());
        column.setCollectionType(firstReferencedColumn.getCollectionType());
        column.setContainer(this);
        this.add(column);
        column.addFKAssociation(referencedColumn, fkAss);
        fkAss.getLocalFKIndex().add(column);
        return column;
    }

    @Override
    public Column createRefToStructuredType(StructuredType type, FKIndexAssociation fkAss) {
        Column column = new Column(this.getDesignPart());
        column.setDesign(this.getDesign());
        column.setContainer(this);
        column.setPreviousColumn(false);
        column.setUse((short)3);
        column.setReference(true);
        column.setStructuredType(type);
        column.setScopeId(fkAss.getOriginalContainer().getObjectID());
        this.add(column);
        FKElement col = (FKElement)fkAss.getOriginalContainer().getOidElement();
        if (col != null) {
            String generatedFKColumnName = ApplyNamingStandards.createFKColumnName(col, fkAss, this.getDesign().getDesignLevelSettings().getNamingStandardRule(), fkAss.getTable());
            column.setName(generatedFKColumnName != null ? generatedFKColumnName : col.getName());
            column.addFKAssociation(col, fkAss);
        }
        fkAss.getLocalFKIndex().add(column);
        return column;
    }

    public Column createColumnFK(Column referencedColumn, FKIndexAssociationReference fkAssRef) {
        Column column = new Column(this.getDesignPart(), (FKElement)referencedColumn, fkAssRef);
        column.setDesign(this.getDesign());
        column.setPreviousColumn(false);
        column.setContainer(this);
        this.add(column);
        return column;
    }

    public Column createTemporaryFKColumn(String id) {
        Column column = new Column(this.getDesignPart());
        column.setDesign(this.getDesign());
        column.setPreviousColumn(false);
        column.setContainer(this);
        column.setObjectID(id);
        column.setRealFKPlaceHolder(true);
        this.add(column);
        return column;
    }

    public Column recreateColumn(String id) {
        Column column = new Column(this.getDesignPart());
        column.setObjectID(id);
        column.setDesign(this.getDesign());
        column.setContainer(this);
        this.add(column);
        return column;
    }

    @Override
    public FKIndexAssociation addFK(KeyObject fkObject) {
        return this.addFK(fkObject, fkObject.getGeneratorID());
    }

    public FKIndexAssociation addFK(KeyObject fkObject, DesignObject generator) {
        return this.addFK(fkObject, generator.getObjectID());
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID) {
        return this.addFK(fkObject, generatorID, null);
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID, FKIndexAssociationReference reference) {
        return this.addFK(fkObject, generatorID, reference, null);
    }

    public FKIndexAssociation addBackupFK(FKIndexAssociation originatingFK) {
        return this.addFK(originatingFK.getRemoteIndex(), null, null, originatingFK);
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID, FKIndexAssociationReference reference, FKIndexAssociation originatingFK) {
        FKIndexAssociation association = new FKIndexAssociation(this.getDesignPart(), originatingFK);
        if (reference != null) {
            reference.setObject(association);
        }
        if (!association.isBackupFK()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        association.setDesign(this.getDesign());
        this.assignLocalID(association);
        if (!this.isBackup()) {
            this.getDesign().addDesignObject(association);
        }
        association.setKeyObject(fkObject);
        association.setGeneratorID(generatorID);
        association.setDeleteRule(this.getDesign().getAppView().getSettings().getDefaultFKDeleteRule());
        this.addFKAssociation(association);
        this.addToMap(generatorID, association);
        KeyObject ind = association.getLocalFKIndex();
        if (ind != null) {
            if (generatorID == null) {
                generatorID = "User generated";
            }
            ind.setGeneratorID(generatorID);
        }
        return association;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FKIndexAssociation addForeignKey(KeyObject refferedKey, List localColumns) {
        FKElement[] refcols = (FKElement[])refferedKey.getColumns();
        if (refcols.length != localColumns.size()) {
            return null;
        }
        for (Column col : localColumns) {
            if (col.getContainer() == this) continue;
            return null;
        }
        FKIndexAssociation fk = new FKIndexAssociation(this.getDesignPart());
        NamingStandardRule nsr = this.getDesign().getNamingStandardRule();
        String fkname = ApplyNamingStandards.createFK_Name(this.getName(), (FKContainer)refferedKey.getContainerWithKeyObject(), refferedKey, this.getFKAssociationsCount(), nsr, this.getDesignPart().getName(), this.getAbbreviation(), null);
        fk.setObjectID(new GUID().toString());
        fk.setContainerWithKeyObject(this);
        fk.setName(fkname);
        boolean existingColumns = true;
        if (localColumns.size() == 0) {
            existingColumns = false;
        }
        if (existingColumns) {
            this.getDesign().setPropagatePKChahges(false);
        }
        try {
            fk.getLocalFKIndex().getElementsCollection().addAll(localColumns);
            fk.setKeyObject(refferedKey);
            fk = this.recreateFK(fk, refferedKey);
            for (int i = 0; i < refcols.length; ++i) {
                Column col = (Column)localColumns.get(i);
                col.addFKAssociation(refcols[i], fk);
            }
        }
        finally {
            if (existingColumns) {
                this.getDesign().setPropagatePKChahges(true);
            }
        }
        return fk;
    }

    public FKIndexAssociation recreateFK(FKIndexAssociation association, KeyObject fkObject) {
        association.setDesign(this.getDesign());
        association.setContainerWithKeyObject(this);
        if (!association.isBackupFK() && !this.isBackup()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(association);
        association.setKeyObject(fkObject);
        if (!this.fkList.contains(association)) {
            this.fkList.add(association);
        }
        this.assignLocalID(association);
        this.getDesign().addDesignObject(association);
        this.addToMap(fkObject.getGeneratorID(), association);
        KeyObject key = association.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(association)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)association));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(association);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
        return association;
    }

    @Override
    public FKIndexAssociation recreateFK(FKIndexAssociation association, KeyObject fkObject, String localIndexId, String deleteRule) {
        association.setDesign(this.getDesign());
        association.setContainerWithKeyObject(this);
        if (!association.isBackupFK() && !this.isBackup()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        association.setKeyObject(fkObject);
        association.setDeleteRule(deleteRule);
        if (localIndexId != null) {
            Index localIndex = (Index)this.getKeyObject(localIndexId);
            association.setLocalFKIndex(localIndex);
            localIndex.setFKAssociation(association);
        }
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(association);
        if (!this.fkList.contains(association)) {
            this.fkList.add(association);
        }
        this.assignLocalID(association);
        this.getDesign().addDesignObject(association);
        if (fkObject != null) {
            this.addToMap(fkObject.getGeneratorID(), association);
        }
        KeyObject key = association.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(association)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)association));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(association);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
        return association;
    }

    public FKIndexAssociation recreateFK(KeyObject fkObject, String fkAssociationId, String localIndexId, String deleteRule, String name, String comments, String notes) {
        FKIndexAssociation association = new FKIndexAssociation(this.getDesignPart());
        association.setDesign(this.getDesign());
        association.setContainerWithKeyObject(this);
        if (!association.isBackupFK()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        association.setObjectID(fkAssociationId);
        association.setKeyObject(fkObject);
        association.setComment(comments);
        association.setNotes(notes);
        association.setDeleteRule(deleteRule);
        if (localIndexId != null) {
            Index localIndex = (Index)this.getKeyObject(localIndexId);
            association.setLocalFKIndex(localIndex);
            localIndex.setFKAssociation(association);
        }
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(association);
        association.setName(name);
        this.fkList.add(association);
        this.assignLocalID(association);
        this.getDesign().addDesignObject(association);
        this.addToMap(fkObject.getGeneratorID(), association);
        KeyObject key = association.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(association)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)association));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(association);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
        return association;
    }

    public void recreateFK(String referencedTableId, String referencedKeyId, String fkAssociationId, String localIndexId, String deleteRule, String name, String comments, String notes, String mandatory, String transferable) {
        this.addPending(new PendingFKAssociationRecreation(referencedTableId, referencedKeyId, fkAssociationId, localIndexId, deleteRule, name, comments, notes, mandatory, transferable));
    }

    public void attemptRecreateFK() {
        if (this.pendingFKassociation != null) {
            Object[] array = this.pendingFKassociation.toArray();
            for (int i = 0; i < array.length; ++i) {
                ((PendingFKAssociationRecreation)array[i]).resolve();
            }
        }
    }

    private void addPending(PendingFKAssociationRecreation pending) {
        if (this.pendingFKassociation == null) {
            this.pendingFKassociation = new ArrayList();
        }
        this.pendingFKassociation.add(pending);
    }

    private void removePending(PendingFKAssociationRecreation pending) {
        if (this.pendingFKassociation != null) {
            this.pendingFKassociation.remove(pending);
            if (this.pendingFKassociation.size() <= 0) {
                this.pendingFKassociation = null;
            }
        }
    }

    public boolean hasPendingFKAssociationRecreations() {
        return this.pendingFKassociation != null && this.pendingFKassociation.size() > 0;
    }

    public boolean hasFKAssociationFor(KeyObject keyObject) {
        FKIndexAssociation[] associations = this.getFKAssociations();
        for (int i = 0; i < associations.length; ++i) {
            if (associations[i].getKeyObject() != keyObject) continue;
            return true;
        }
        return false;
    }

    @Override
    public FKElement getColumnForDelegate(FKIndexAssociation fk, FKElement delegate) {
        FKElement[] cols = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isReferingTo(fk, delegate)) continue;
            return cols[i];
        }
        return null;
    }

    public int getNumberOfFKAssociationFor(KeyObject keyObject) {
        int k = 0;
        FKIndexAssociation[] associations = this.getFKAssociations();
        for (int i = 0; i < associations.length; ++i) {
            if (associations[i].getKeyObject() != keyObject) continue;
            ++k;
        }
        return k;
    }

    @Override
    public FKElement[] getAllFKColumns(FKIndexAssociation fkAssociation) {
        ArrayList<FKElement> fkcolumns = new ArrayList<FKElement>();
        FKElement[] columns = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            FKElement cfk;
            if (!columns[i].isFKColumn() || !(cfk = columns[i]).isPartOfFKIndexAssociation(fkAssociation)) continue;
            fkcolumns.add(columns[i]);
        }
        return fkcolumns.toArray(new FKElement[0]);
    }

    @Override
    public FKElement getFKColumn(FKIndexAssociation association, FKElement delegate) {
        FKElement[] columns = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isReferingTo(association, delegate)) continue;
            return columns[i];
        }
        return null;
    }

    public Column[] getAllFKPlaceHolderColumns() {
        ArrayList<Column> fkcolumns = new ArrayList<Column>();
        Column[] columns = (Column[])this.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isFKPlaceHolderColumn()) continue;
            fkcolumns.add(columns[i]);
        }
        return fkcolumns.toArray(new Column[0]);
    }

    protected void addToMap(String generatorID, FKIndexAssociation association) {
        if (generatorID != null) {
            HashSet<FKIndexAssociation> set = (HashSet<FKIndexAssociation>)this.generatedLists.get(generatorID);
            if (set == null) {
                set = new HashSet<FKIndexAssociation>();
                this.generatedLists.put(generatorID, set);
            }
            set.add(association);
        }
    }

    public void removeAllGeneratedFKs(DesignObject generator) {
        this.removeAllGeneratedFKs(generator.getObjectID());
    }

    public void removeAllGeneratedFKs(String generatorID) {
        Set set = (Set)this.generatedLists.get(generatorID);
        if (set != null) {
            Iterator it = set.iterator();
            while (it.hasNext()) {
                this.removeFKAssociation((FKIndexAssociation)it.next());
            }
            this.generatedLists.remove(generatorID);
        }
    }

    @Override
    public FKIndexAssociation[] getFKAssociations() {
        return (FKIndexAssociation[])this.fkList.toArray(INDEX_ASSOCIATION_PROTO);
    }

    @Override
    public FKIndexAssociation getFKIndexAssociationByName(String fkName) {
        for (FKIndexAssociation fk : this.fkList) {
            if (!fk.getName().equalsIgnoreCase(fkName)) continue;
            return fk;
        }
        return null;
    }

    public FKIndexAssociation getFKIndexAssociationByImportedID(String importedID) {
        for (FKIndexAssociation fk : this.fkList) {
            if (!fk.getImportedId().equalsIgnoreCase(importedID)) continue;
            return fk;
        }
        return null;
    }

    @Override
    public List<FKIndexAssociation> getFKAssociationsList() {
        return this.fkList;
    }

    public FKIndexAssociation[] getFKIndexAssociationsWith(Table other) {
        HashSet result = new HashSet();
        Collection associatedToOther = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(other);
        result.addAll(this.fkList);
        result.retainAll(associatedToOther);
        return (FKIndexAssociation[])result.toArray(INDEX_ASSOCIATION_PROTO);
    }

    public FKIndexAssociation getFKIndexAssociationFor(KeyObject primaryKey) {
        Table other = (Table)primaryKey.getContainerObject();
        FKIndexAssociation[] fkeys = this.getFKIndexAssociationsWith(other);
        for (int i = 0; i < fkeys.length; ++i) {
            if (fkeys[i].getKeyObject() != primaryKey) continue;
            return fkeys[i];
        }
        return null;
    }

    public void addFKAssociation(FKIndexAssociation fkAssociation) {
        fkAssociation.setContainerWithKeyObject(this);
        if (!fkAssociation.isBackupFK()) {
            ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fkAssociation);
        }
        if (this.getDesign().isPropagatePKChahges() && !fkAssociation.isBackupFK()) {
            fkAssociation.addAllFKElements();
        }
        this.fkList.add(fkAssociation);
        KeyObject key = fkAssociation.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(fkAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fkAssociation));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(fkAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
    }

    @Override
    public void addRecreateFKAssociation(FKIndexAssociation fkAssociation) {
        this.recreateFK(fkAssociation, fkAssociation.getRemoteIndex(), fkAssociation.getLocalFKIndex().getObjectID(), fkAssociation.getDeleteRule());
    }

    @Override
    public void restoreFKAssociation(FKIndexAssociation fkAssociation, String index_id) {
        fkAssociation.setContainerWithKeyObject(this);
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fkAssociation);
        Index key = this.createIndexFK(fkAssociation, index_id);
        this.fkList.add(fkAssociation);
        if (!this.fkSet.containsPlaceHolderFor(fkAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fkAssociation));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
    }

    public void removeDependentFKAssociations(Index pk) {
        Collection col = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(pk);
        for (FKIndexAssociation fkass : col) {
            fkass.removeAllFKElements();
            KeyObject key = fkass.getLocalFKIndex();
            ((Table)key.getContainerWithKeyObject()).removeFKAssociation(fkass);
            ((ContainerWithKeyObject)key.getTopLevelContainer()).remove(key);
        }
    }

    public void syncDependentFKAssociations(Index pk) {
        Table table = pk.getTable();
        Collection dpvs = table.getAffectedDPVs();
        Collection col = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(pk);
        for (FKIndexAssociation fk : col) {
            for (DesignPartView dpv : dpvs) {
                TopView tv = table.getFirstViewForDPV(dpv);
                fk.resetSourceTVTable((TVTable)tv);
            }
        }
    }

    public void removeDependentFKAssociations() {
        Collection col = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(this);
        for (FKIndexAssociation fkass : col) {
            fkass.removeAllFKElements();
            KeyObject key = fkass.getLocalFKIndex();
            ((Table)key.getContainerWithKeyObject()).removeFKAssociation(fkass);
            ((ContainerWithKeyObject)key.getTopLevelContainer()).remove(key);
        }
    }

    @Override
    public void remove(KeyObject key) {
        this.remove(key, true);
    }

    public void remove(KeyObject key, boolean removeFromGlobalSet) {
        if (key.isPK() || key.isUnique()) {
            this.removeDependentFKAssociations((Index)key);
        }
        if (key.isPK()) {
            this.pkSet.remove(key);
            this.setPK(null);
        }
        if (key.isFK() && ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().contains(key.getFKAssociation())) {
            this.removeFKAssociation(key.getFKAssociation());
        }
        if (removeFromGlobalSet) {
            ((RelationalDesign)this.getDesignPart()).getGlobalIndexSet().remove(key);
        }
        super.remove(key);
        key.clearElements();
    }

    public void moveIndexToTable(Index key, Table target) {
        if (!key.isFK()) {
            if (key.isPK()) {
                this.pkSet.remove(key);
                this.setPK(null);
            } else if (key.isUnique()) {
                this.unSet.remove(key);
            } else {
                this.indSet.remove(key);
            }
            this.getKeySet().remove(key);
            key.setContainerObject(null);
            key.clearElements();
            String kname = key.getName();
            target.add(key);
            key.setName(kname);
            if (key.isPK() || key.isUnique()) {
                this.syncDependentFKAssociations(key);
            }
        }
    }

    @Override
    public void remove() {
        int i;
        FKIndexAssociation[] fks = this.getFKAssociations();
        for (i = 0; i < fks.length; ++i) {
            fks[i].setSilentRemove(true);
        }
        try {
            this.removeAllKeys();
            this.clearViews();
            this.deleteAllArcs();
            super.remove();
        }
        finally {
            for (i = 0; i < fks.length; ++i) {
                fks[i].setSilentRemove(false);
            }
        }
    }

    @Override
    public void clearAll() {
        int strat = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        this.getDesign().getAppView().getSettings().setDeleteFKColumnStrategy(0);
        this.removeAllKeys();
        this.deleteAllArcs();
        super.clearAll();
        this.getDesign().getAppView().getSettings().setDeleteFKColumnStrategy(strat);
    }

    public void removeAllFKAssociations() {
        FKIndexAssociation[] associations = this.getFKAssociations();
        for (int i = 0; i < associations.length; ++i) {
            this.removeFKAssociation(associations[i]);
        }
    }

    @Override
    public void removeAllKeys() {
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            keys[i].remove();
        }
    }

    public void clearViews() {
        Iterator it = ((RelationalDesign)this.getDesignPart()).getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView view = (TableView)it.next();
            view.clear(this);
        }
    }

    public void removeFKAssociation(FKIndexAssociation fkAssociation) {
        fkAssociation.removeAllFKElements();
        this.removeFKAssociationFromList(fkAssociation);
        this.getDesign().removeDesignObject(fkAssociation);
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().remove(fkAssociation);
        this.removeContainerListener(fkAssociation);
        if (fkAssociation.getOriginalContainer() != null) {
            fkAssociation.getOriginalContainer().removeContainerListener(fkAssociation);
            fkAssociation.removeObjectListener(fkAssociation.getOriginalContainer());
        }
        if (fkAssociation.getKeyObject() != null) {
            fkAssociation.getKeyObject().removeObjectListener(this);
            fkAssociation.getKeyObject().removeContainerListener(fkAssociation);
            fkAssociation.setKeyObject(null);
        }
        fkAssociation.removeObjectListener(this);
        fkAssociation.callRemoveListeners();
        ObjectChangeEvent.FKINDEX_REMOVED.setAffected(fkAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_REMOVED);
        ObjectChangeEvent.FKINDEX_REMOVED.setAffected(null);
    }

    @Override
    public void removeFKAssociationFromList(FKIndexAssociation fkAssociation) {
        this.fkList.remove(fkAssociation);
    }

    public boolean isAssociated(KeyObject foreignKey) {
        if (foreignKey == null) {
            return false;
        }
        Iterator it = this.fkList.iterator();
        while (it.hasNext()) {
            if (!foreignKey.equals(((FKIndexAssociation)it.next()).getKeyObject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public KeyObject createKeyObject(String id) {
        return this.createIndex(id);
    }

    public Index createIndex() {
        Index key = this.createIndex(null);
        return key;
    }

    public Index createIndex(String id) {
        Index key = new Index(this.getDesignPart());
        key.setBackup(this.isBackup());
        key.setObjectID(id);
        String indname = ApplyNamingStandards.createIndexName(this.getName(), this.getKeySet().size(), this.getDesignPart().getDesign().getDesignLevelSettings().getNamingStandardRule(), this.getDesignPart().getName(), this.getAbbreviation());
        key.setName(indname);
        this.add(key);
        return key;
    }

    @Override
    public KeyObject createIndexFK(FKIndexAssociation fkass) {
        Index key = new Index(this.getDesignPart(), fkass);
        key.setBackup(this.isBackup());
        key.setObjectID(null);
        key.setFKAssociation(fkass);
        this.add(key);
        return key;
    }

    public Index createIndexFK(FKIndexAssociation fkass, String index_id) {
        Index key = (Index)fkass.getLocalFKIndex();
        key.setBackup(this.isBackup());
        fkass.setBackup(this.isBackup());
        key.setObjectID(index_id);
        key.setFKAssociation(fkass);
        this.add(key);
        return key;
    }

    public ColumnSet getColumnSet() {
        return ((RelationalDesign)this.getDesignPart()).getColumnSet();
    }

    @Override
    public DesignObjectSet getContainedSet() {
        return this.getColumnSet();
    }

    public boolean reconnectFKColumns() {
        boolean result = true;
        Column[] columns = this.getAllFKPlaceHolderColumns();
        for (int i = 0; i < columns.length; ++i) {
            result = result && this.replace(columns[i]);
        }
        return result;
    }

    public boolean reconnectFK() {
        return false;
    }

    private boolean replace(Column placeHolder) {
        if (!placeHolder.isAdapterLoaded()) {
            placeHolder.loadDelegate();
        }
        return true;
    }

    public boolean isBeingRecreated() {
        return this.beingRecreated;
    }

    public boolean isMtoNjoinCandidate() {
        Entity engent = this.getEngEntity();
        if (engent != null) {
            return false;
        }
        FKIndexAssociation[] fkeys = this.getFKAssociations();
        if (fkeys.length == 2 && fkeys[0].getRemoteTable() != fkeys[1].getRemoteTable()) {
            for (Column col : this.getElementsCollection()) {
                if ((col.isFKColumn() || !col.isPKElement()) && (!col.isFKColumn() || col.isPKElement())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setBeingRecreated(boolean value) {
        this.beingRecreated = value;
    }

    @Override
    public int getByteSize(String rdbmsName) {
        return super.getByteSize(rdbmsName);
    }

    @Override
    public int countRelationsWith(ContainerWithKeyObject other) {
        if (other != null && other instanceof Table) {
            int count = 0;
            FKIndexAssociation[] associations = this.getFKAssociations();
            for (int i = 0; i < associations.length; ++i) {
                if (!other.equals(associations[i].getContainerWithKeyObject())) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public int countRelations() {
        return this.fkList.size();
    }

    @Override
    public List getCheckConstraints() {
        return this.checkConstraints;
    }

    public TableLevelConstraint createCheckConstraint() {
        TableLevelConstraint tc = new TableLevelConstraint(this.getDesignPart());
        return tc;
    }

    public TableLevelConstraint createCheckConstraint(String name, String rule) {
        TableLevelConstraint tc = new TableLevelConstraint(this.getDesignPart());
        String ccName = this.createCheckConstraintName(name);
        tc.setName(ccName);
        tc.setRule(rule);
        return tc;
    }

    private String createCheckConstraintName(String name) {
        String ccName = name;
        String sep = "v";
        int ind = 1;
        while (this.getCheckConstraintByName(ccName) != null) {
            ccName = name + sep + ind++;
            if (ind < 100) continue;
        }
        return ccName;
    }

    public void addCheckConstraint(TableLevelConstraint constraint) {
        if (!this.checkConstraints.contains(constraint)) {
            this.checkConstraints.add(constraint);
            constraint.setTable(this);
            TableLevelConstraintEvent event = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_ADDED;
            event.setAffected(constraint);
            this.fireChange(event);
        }
    }

    public void removeCheckConstraint(TableLevelConstraint constraint) {
        if (this.checkConstraints.contains(constraint)) {
            this.checkConstraints.remove(constraint);
            TableLevelConstraintEvent event = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED;
            event.setAffected(constraint);
            this.fireChange(event);
        }
    }

    public void clearCheckConstraints() {
        for (TableLevelConstraint constraint : this.checkConstraints) {
            TableLevelConstraintEvent event = TableLevelConstraintEvent.TABLE_CHECK_CONSTRAINT_REMOVED;
            event.setAffected(constraint);
            this.fireChange(event);
        }
        this.checkConstraints.clear();
    }

    public TableLevelConstraint getCheckConstraintByID(String id) {
        for (TableLevelConstraint tc : this.checkConstraints) {
            if (!tc.getID().equals(id)) continue;
            return tc;
        }
        return null;
    }

    public TableLevelConstraint getCheckConstraintByName(String name) {
        for (TableLevelConstraint tc : this.checkConstraints) {
            if (!tc.getName().equalsIgnoreCase(name)) continue;
            return tc;
        }
        return null;
    }

    public TableLevelConstraint getCheckConstraintByImportedID(String importedID) {
        for (TableLevelConstraint tc : this.checkConstraints) {
            if (!tc.getImportedId().equals(importedID)) continue;
            return tc;
        }
        return null;
    }

    public FKArc getArcByImportedID(String importedID) {
        for (FKArc arc : this.arcs) {
            if (!arc.getImportedId().equals(importedID)) continue;
            return arc;
        }
        return null;
    }

    protected void fireChange(TableLevelConstraintEvent event) {
        this.setDirty(true);
        this.getChange().setTimeNow();
        for (Object l : this.getListeners()) {
            if (!(l instanceof TableCheckConstraintListener)) continue;
            ((TableCheckConstraintListener)l).changed((TableLevelConstraint)event.getAffected(), event);
        }
    }

    @Override
    public boolean hasAliveGenerator() {
        RelationSet rset;
        DesignObject obj;
        EntitySet set = this.getDesign().getLogicalDesign().getEntitySet();
        return "User generated".equalsIgnoreCase(this.getGeneratorID()) || (obj = set.getObjectByID(this.getGeneratorID())) != null || (obj = (rset = this.getDesign().getLogicalDesign().getRelationSet()).getObjectByID(this.getGeneratorID())) != null;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            try {
                TablePropertiesDialogEx dialog = new TablePropertiesDialogEx(this.getDesign().getAppView(), this);
                dialog.initProperties(this);
                dialog.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean hasPrimaryKey() {
        return this.pkSet.size() > 0;
    }

    public boolean hasUniqueKeys() {
        return this.unSet.size() > 0;
    }

    public DesignObjectCollection getPKeys() {
        return this.pkSet;
    }

    public DesignObjectCollection getUKeys() {
        return this.unSet;
    }

    public DesignObjectCollection getIndexes() {
        return this.indSet;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (scope != null && scope.equals(this.scope)) {
            return;
        }
        this.scope = scope;
    }

    @Override
    public String getLongName() {
        StringBuffer buffer = new StringBuffer();
        if ("".equals(this.getSchema())) {
            return this.getName();
        }
        buffer.append(this.getSchema()).append('.').append(this.getName());
        return buffer.toString();
    }

    private boolean checkGrowth(String value) {
        if (growthSet == null) {
            growthSet = new HashSet();
            growthSet.addAll(Arrays.asList(GROWTH_TYPES));
        }
        return growthSet.contains(value);
    }

    private boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(YES_NO_STATES));
        }
        return yesNoSet.contains(value);
    }

    private boolean checkNormalForm(String value) {
        if (normalFormSet == null) {
            normalFormSet = new HashSet();
            normalFormSet.addAll(Arrays.asList(NORMAL_FORMS));
        }
        return normalFormSet.contains(value);
    }

    public String getAdequatelyNormalized() {
        return this.adequatelyNormalized;
    }

    public void setAdequatelyNormalized(String adequatelyNormalized) {
        if (this.checkYesNo(adequatelyNormalized)) {
            this.adequatelyNormalized = adequatelyNormalized;
        }
    }

    public String getExpectedVolumes() {
        return this.expectedVolumes;
    }

    public void setExpectedVolumes(String expectedVolumes) {
        try {
            if (expectedVolumes != null) {
                this.expectedVolumes = expectedVolumes;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGrowthPercent() {
        return Integer.toString(this.growthPercent);
    }

    public int getGrowthPercentInt() {
        return this.growthPercent;
    }

    public void setGrowthPercent(String growthPercent) {
        try {
            this.growthPercent = Integer.parseInt(growthPercent);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getGrowthType() {
        return this.growthType;
    }

    public void setGrowthType(String growthType) {
        if (this.checkGrowth(growthType)) {
            this.growthType = growthType;
        }
    }

    public String getMaxVolumes() {
        return this.maxVolumes;
    }

    public void setMaxVolumes(String maxVolumes) {
        if (maxVolumes != null) {
            this.maxVolumes = maxVolumes;
        }
    }

    public String getMinVolumes() {
        return this.minVolumes;
    }

    public void setMinVolumes(String minVolumes) {
        if (minVolumes != null) {
            this.minVolumes = minVolumes;
        }
    }

    public String getNormalForm() {
        return this.normalForm;
    }

    public void setNormalForm(String normalForm) {
        if (this.checkNormalForm(normalForm)) {
            this.normalForm = normalForm;
        }
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    @Override
    public boolean canPaste() {
        for (Object obj : this.getAppView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copy(DesignObject desObject) {
        this.copy(desObject, null, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap) {
        this.copy(desObject, copyMap, false);
    }

    @Override
    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject) {
        this.copy(desObject, copyMap, remoteObject, false);
    }

    public void copy(DesignObject desObject, Map copyMap, boolean remoteObject, boolean targetIsRemoteObject) {
        Column old;
        boolean revRemote;
        Table table = (Table)desObject;
        HashMap<Column, Column> colMap = new HashMap<Column, Column>();
        super.copy(table);
        boolean bl = revRemote = targetIsRemoteObject && !this.isRemoteObject();
        if (revRemote) {
            this.setRemoteObjectID(table.getObjectID());
            this.setRemoteModelID(table.getRelationalModel().getObjectID());
            this.setRemoteDesignID(this.getDesign().getObjectID());
            this.setRemoteObjectRelativeStorageName(table.getRelativeStorageName());
            this.setDirty(true);
        }
        table.setTypeID(this.getTypeID());
        table.setScope(this.getScope());
        table.setBasedOnStructuredType(this.getBasedOnStructuredType());
        table.setAbbreviation(this.getAbbreviation());
        table.setOidIsPK(this.isOidIsPK());
        table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        table.setOnPrebuiltTable(this.isOnPrebuiltTable());
        table.setMaterializedQueryTable(this.isMaterializedQueryTable());
        table.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
        table.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
        table.setSyntaxProvider(this.getSyntaxProvider());
        table.setUserDefinedSQL(this.getUserDefinedSQL());
        table.setParsed(this.isParsed());
        table.setValidSQL(this.isValidSQL());
        table.setIncorrectSQL(this.isIncorrectSQL());
        table.setMinVolumes(this.getMinVolumes());
        table.setExpectedVolumes(this.getExpectedVolumes());
        table.setMaxVolumes(this.getMaxVolumes());
        table.setGrowthPercent(this.getGrowthPercent());
        table.setGrowthType(this.getGrowthType());
        table.setNormalForm(this.getNormalForm());
        table.setAdequatelyNormalized(this.getAdequatelyNormalized());
        table.setEngineerToRelation(this.isEngineerToRelation());
        table.setAllowColumnReorder(this.isAllowColumnReorder());
        if (!this.isBST()) {
            if (remoteObject) {
                ContainedObject[] columns = table.getElements();
                for (int i = columns.length - 1; i >= 0; --i) {
                    ContainedObject rc;
                    ContainedObject column = columns[i];
                    String rcID = column.getRemoteObjectID();
                    if ("".equalsIgnoreCase(rcID) || (rc = this.getElementByID(rcID)) != null) continue;
                    column.remove();
                }
            }
            ContainedObject[] cos = this.getElements();
            for (int i = 0; i < cos.length; ++i) {
                old = (Column)cos[i];
                Column col = (Column)table.getElementByRemoteObjectID(old.getObjectID());
                if (col == null) {
                    col = table.createColumn();
                }
                if (remoteObject) {
                    if (old.isRemoteObject()) {
                        col.setRemoteObjectID(old.getRemoteObjectID());
                    } else {
                        col.setRemoteObjectID(old.getObjectID());
                    }
                }
                if (revRemote) {
                    old.setRemoteObjectID(col.getObjectID());
                }
                old.copy(col, remoteObject, copyMap, true);
                colMap.put(old, col);
                table.moveToIndex(col, i);
            }
        } else {
            ContainedObject[] cos = this.getElements();
            for (int i = 0; i < cos.length; ++i) {
                old = (Column)cos[i];
                if (!old.isOid()) {
                    DesignObject obj;
                    String id = old.getStructAttributeID();
                    if (id == null || "".equals(id)) continue;
                    Column column = (Column)table.getElementByStructAttributeID(id);
                    if (column == null && copyMap != null && (obj = (DesignObject)copyMap.get(id)) != null) {
                        column = (Column)table.getElementByStructAttributeID(obj.getObjectID());
                    }
                    if (column == null) continue;
                    if (remoteObject) {
                        column.setRemoteObjectID(old.getObjectID());
                    } else {
                        column.setObjectID(old.getObjectID());
                    }
                    if (revRemote) {
                        old.setRemoteObjectID(column.getObjectID());
                    }
                    old.copy(column, remoteObject, copyMap, true);
                    colMap.put(old, column);
                    continue;
                }
                Column column = (Column)table.getOidElement();
                if (column == null) continue;
                if (remoteObject) {
                    column.setRemoteObjectID(old.getObjectID());
                } else {
                    column.setObjectID(old.getObjectID());
                }
                if (revRemote) {
                    old.setRemoteObjectID(column.getObjectID());
                }
                old.copy(column, remoteObject, copyMap, true);
                colMap.put(old, column);
            }
        }
        for (Column old2 : colMap.keySet()) {
            Column col = (Column)colMap.get(old2);
            if (col == null) continue;
            old2.copyDepenDendentColumnDescriptors(col, false, copyMap);
        }
        for (int i = 0; i < this.getKeys().length; ++i) {
            KeyObject key = null;
            KeyObject oldKey = this.getKeys()[i];
            if (oldKey.isFK() && !remoteObject || oldKey instanceof Index && "Foreign Key".equalsIgnoreCase(oldKey.getIndexState())) continue;
            if (oldKey.isOidKey()) {
                key = table.getOidKey();
            }
            if (key == null && (key = (KeyObject)table.getKeySet().getObjectByRemoteObjectID(oldKey.getObjectID())) == null) {
                key = table.createKeyObject();
            }
            if (oldKey.isOidKey() && key != null) {
                key.setOidKey(true);
            }
            oldKey.copy(key);
            if (remoteObject) {
                if (oldKey.isRemoteObject()) {
                    key.setRemoteObjectID(oldKey.getRemoteObjectID());
                } else {
                    key.setRemoteObjectID(oldKey.getObjectID());
                }
            }
            if (revRemote) {
                oldKey.setRemoteObjectID(key.getObjectID());
            }
            key.setContainerObject(table);
            if (oldKey instanceof Index) {
                key.setIndexState(oldKey.getIndexState());
            }
            if (copyMap == null) continue;
            copyMap.put(oldKey.getObjectID(), key);
        }
        for (int i = 0; i < this.getCheckConstraints().size(); ++i) {
            TableLevelConstraint oldTlc = (TableLevelConstraint)this.getCheckConstraints().get(i);
            TableLevelConstraint tlc = table.getCheckConstraintByName(oldTlc.getName());
            if (tlc == null) {
                tlc = table.createCheckConstraint(oldTlc.getName(), oldTlc.getRule());
                tlc.setNotes(oldTlc.getNotes());
                tlc.setComment(oldTlc.getComment());
                tlc.setCommentInRDBMS(oldTlc.getCommentInRDBMS());
                tlc.setGenerateInDDL(oldTlc.getGenerateInDDL());
                table.addCheckConstraint(tlc);
            }
            if (copyMap == null) continue;
            copyMap.put(oldTlc.getObjectID(), tlc);
        }
        table.getValidTimeDimensions().clear();
        for (ValidTimeDimension oldVTD : this.getValidTimeDimensions()) {
            ValidTimeDimension newVTD = new ValidTimeDimension(table);
            oldVTD.copy(newVTD, copyMap);
            if (copyMap == null) continue;
            copyMap.put(oldVTD.getObjectID(), newVTD);
        }
        table.setSpatialTable(this.isSpatialTable());
        table.getSpatialDefinitions().clear();
        for (SpatialColumnDefObject spCol : this.getSpatialDefinitions()) {
            SpatialColumnDefObject t_spCol = new SpatialColumnDefObject(table);
            table.addSpatialDefinition(t_spCol);
            spCol.copyTo(t_spCol, copyMap);
        }
        table.setBeforeDrop(this.getBeforeDrop());
        table.setBeforeCreate(this.getBeforeCreate());
        table.setAfterCreate(this.getAfterCreate());
        table.setEndOfScript(this.getEndOfScript());
        table.setShouldGenerateScript(this.getShouldGenerateScript());
        table.getColumnGroupsSet().clear();
        for (ColumnGroup cgOld : this.getColumnGroupsSet()) {
            ColumnGroup cgNew = table.createColumnGroup(cgOld.getName(), null);
            table.getColumnGroupsSet().add(cgNew);
            cgOld.copy(cgNew, copyMap);
        }
        table.setRedactionPolicyName(this.getRedactionPolicyName());
        table.setRedactionPolicyDefaultExpression(this.getRedactionPolicyDefaultExpression());
        table.setRedactionPolicyEnabled(this.isRedactionPolicyEnabled());
        table.setRedactionPolicyGenerateInDDL(this.isRedactionPolicyGenerateInDDL());
        table.setExistDependencyConstraintName(this.getExistDependencyConstraintName());
        table.setExistDependencyGenerateInDDl(this.isExistDependencyGenerateInDDl());
        table.setExistDependencyGenerationLevel(this.getExistDependencyGenerationLevel());
        table.getAdditionalClassificationTypes().clear();
        for (String id : this.getAdditionalClassificationTypes()) {
            table.getAdditionalClassificationTypes().add(id);
        }
        if (this.getDesignPart() == table.getDesignPart()) {
            table.removeQueryObjectListeners();
            this.copySQLNames(table);
            table.addQueryObjectListeners();
        }
        table.setORDSEnable(this.isORDSEnable());
        table.setORDSAuth(this.isORDSAuth());
        table.setORDSAlias(this.getORDSAlias());
    }

    public FKIndexAssociation copyForeignKey(Table table, FKIndexAssociation oldFK, Map copyMap) {
        FKIndexAssociation newFK = null;
        if (copyMap == null) {
            return null;
        }
        KeyObject oldRemoteIndex = oldFK.getRemoteIndex();
        if (oldRemoteIndex != null) {
            boolean copyWithinSameModel = this.getDesignPart() == table.getDesignPart();
            Object remoteKeyCopy = copyMap.get(oldRemoteIndex.getObjectID());
            if (remoteKeyCopy == null && oldRemoteIndex.isRemoteObject()) {
                remoteKeyCopy = copyMap.get(oldRemoteIndex.getRemoteObjectID());
            }
            if (copyWithinSameModel || remoteKeyCopy != null) {
                newFK = new FKIndexAssociation(table.getDesignPart());
                newFK.setBackup(this.isBackup());
                this.assignLocalID(newFK);
                KeyObject newRemoteKey = remoteKeyCopy != null ? (KeyObject)remoteKeyCopy : oldRemoteIndex;
                newFK.setKeyObject(newRemoteKey);
                KeyObject oldLocalIndex = oldFK.getLocalFKIndex();
                Index newLocalIndex = (Index)table.createIndexFK(newFK);
                for (Column oldColumn : oldLocalIndex.getElementsCollection()) {
                    FKElement newRefCol;
                    Object newCol = copyMap.get(oldColumn.getObjectID());
                    FKElement oldRefColumn = oldColumn.getReferencedColumn(oldFK);
                    if (remoteKeyCopy != null && oldRefColumn != null) {
                        newRefCol = copyMap.get(oldRefColumn.getObjectID());
                        if (newRefCol == null) {
                            newRefCol = copyMap.get(oldRefColumn.getRemoteObjectID());
                        }
                    } else {
                        newRefCol = oldRefColumn;
                    }
                    if (!(newCol instanceof Column) || !(newRefCol instanceof FKElement)) continue;
                    Column newColumn = (Column)newCol;
                    newColumn.addFKAssociation(newRefCol, newFK);
                    newLocalIndex.add(newColumn);
                }
                oldLocalIndex.copy(newLocalIndex);
                table.recreateFK(newFK, newRemoteKey, newLocalIndex.getObjectID(), null);
                oldFK.copy(newFK);
                if (copyWithinSameModel) {
                    String newname = FKUtilities.generateFKName((FKContainer)table, newFK.getRemoteTable(), newFK.getRemoteIndex());
                    newFK.setName(newname);
                }
                newFK.resetEdgeParams();
                if (copyMap != null) {
                    copyMap.put(oldFK.getObjectID(), newFK);
                }
            }
        }
        return newFK;
    }

    public FKArc copyArc(Table table, FKArc oldArc, Map copyMap) {
        FKArc newArc = null;
        if (copyMap == null) {
            return null;
        }
        return newArc;
    }

    public void backupTo(Table table) {
        Column column;
        Column old;
        int i;
        table.setBackup(true);
        super.copy(table);
        table.setObjectID(this.getObjectID());
        table.setTypeID(this.getTypeID());
        table.setScope(this.getScope());
        table.setBasedOnStructuredType(this.getBasedOnStructuredType());
        table.setAbbreviation(this.getAbbreviation());
        table.setOidIsPK(this.isOidIsPK());
        table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        table.setOnPrebuiltTable(this.isOnPrebuiltTable());
        table.setMaterializedQueryTable(this.isMaterializedQueryTable());
        table.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
        table.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
        table.setSyntaxProvider(this.getSyntaxProvider());
        table.setUserDefinedSQL(this.getUserDefinedSQL());
        table.setParsed(this.isParsed());
        table.setValidSQL(this.isValidSQL());
        table.setIncorrectSQL(this.isIncorrectSQL());
        table.setMinVolumes(this.getMinVolumes());
        table.setExpectedVolumes(this.getExpectedVolumes());
        table.setMaxVolumes(this.getMaxVolumes());
        table.setGrowthPercent(this.getGrowthPercent());
        table.setGrowthType(this.getGrowthType());
        table.setNormalForm(this.getNormalForm());
        table.setAdequatelyNormalized(this.getAdequatelyNormalized());
        table.setEngineerToRelation(this.isEngineerToRelation());
        table.setAllowColumnReorder(this.isAllowColumnReorder());
        table.setRemoteObjectID(this.getRemoteObjectID());
        table.setRemoteModelID(this.getRemoteModelID());
        table.setRemoteDesignID(this.getRemoteDesignID());
        table.setRemoteObjectRelativeStorageName(this.getRemoteObjectRelativeStorageName());
        table.setNameFixed(this.isNameFixed());
        this.copySourceStamp(table);
        table.setCreatedTime(this.getCreatedTime());
        table.setCreatedBy(this.getCreatedBy());
        if (!this.isBST()) {
            for (i = 0; i < this.getElements().length; ++i) {
                old = (Column)this.getElements()[i];
                column = new Column(table.getDesignPart());
                column.setDesign(table.getDesign());
                column.setContainer(table);
                column.setObjectID(old.getObjectID());
                table.add(column);
                old.copy(column);
                old.copySourceStamp(column);
                old.copyDepenDendentColumnDescriptors(column, true, null);
                column.setNameFixed(old.isNameFixed());
                column.setCreatedTime(old.getCreatedTime());
                column.setCreatedBy(old.getCreatedBy());
            }
        } else {
            for (i = 0; i < this.getElements().length; ++i) {
                old = (Column)this.getElements()[i];
                if (!old.isOid()) {
                    String id = old.getStructAttributeID();
                    if (id == null || "".equals(id)) continue;
                    Column column2 = (Column)table.getElementByStructAttributeID(id);
                    column2.setObjectID(old.getObjectID());
                    old.copy(column2);
                    old.copyDepenDendentColumnDescriptors(column2, true, null);
                    continue;
                }
                column = (Column)table.getOidElement();
                if (column == null) continue;
                column.setObjectID(old.getObjectID());
                old.copy(column);
                old.copyDepenDendentColumnDescriptors(column, true, null);
            }
        }
        KeyObject[] keys = this.getKeys();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            Index key = null;
            Index oldKey = (Index)keys[i2];
            if (oldKey.isFK()) continue;
            if (oldKey.isOidKey()) {
                key = (Index)table.getOidKey();
            }
            if (key == null) {
                key = (Index)table.createKeyObject();
            }
            if (oldKey.isOidKey() && key != null) {
                key.setOidKey(true);
            }
            key.setObjectID(oldKey.getObjectID());
            key.setIndexState(oldKey.getIndexState());
            oldKey.copy(key);
            oldKey.copySourceStamp(key);
            key.setContainerObject(table);
            key.setObjectID(oldKey.getObjectID());
            if (oldKey.isPK()) {
                key.getContainerWithKeyObject().setPK(key);
            }
            key.setNameFixed(oldKey.isNameFixed());
            key.setCreatedTime(oldKey.getCreatedTime());
            key.setCreatedBy(oldKey.getCreatedBy());
        }
        table.clearCheckConstraints();
        for (int i3 = 0; i3 < this.getCheckConstraints().size(); ++i3) {
            TableLevelConstraint oldTlc = (TableLevelConstraint)this.getCheckConstraints().get(i3);
            TableLevelConstraint tlc = table.createCheckConstraint(oldTlc.getName(), oldTlc.getRule());
            tlc.setNotes(oldTlc.getNotes());
            tlc.setComment(oldTlc.getComment());
            tlc.setCommentInRDBMS(oldTlc.getCommentInRDBMS());
            tlc.setGenerateInDDL(oldTlc.getGenerateInDDL());
            tlc.setID(oldTlc.getID());
            table.addCheckConstraint(tlc);
        }
        table.getValidTimeDimensions().clear();
        for (ValidTimeDimension oldVTD : this.getValidTimeDimensions()) {
            ValidTimeDimension backupVTD = new ValidTimeDimension(table);
            oldVTD.copy(backupVTD);
            backupVTD.setObjectID(oldVTD.getObjectID());
        }
        table.setSpatialTable(this.isSpatialTable());
        table.getSpatialDefinitions().clear();
        for (SpatialColumnDefObject spCol : this.getSpatialDefinitions()) {
            SpatialColumnDefObject t_spCol = new SpatialColumnDefObject(table);
            spCol.copyTo(t_spCol);
            t_spCol.setObjectID(spCol.getObjectID());
            table.addSpatialDefinition(t_spCol);
        }
        table.setBeforeDrop(this.getBeforeDrop());
        table.setBeforeCreate(this.getBeforeCreate());
        table.setAfterCreate(this.getAfterCreate());
        table.setEndOfScript(this.getEndOfScript());
        table.setShouldGenerateScript(this.getShouldGenerateScript());
        table.getColumnGroupsSet().clear();
        for (ColumnGroup cgOld : this.getColumnGroupsSet()) {
            ColumnGroup cgNew = table.createColumnGroup(cgOld.getName(), null);
            table.getColumnGroupsSet().add(cgNew);
            cgOld.copy(cgNew);
        }
        table.setRedactionPolicyName(this.getRedactionPolicyName());
        table.setRedactionPolicyDefaultExpression(this.getRedactionPolicyDefaultExpression());
        table.setRedactionPolicyEnabled(this.isRedactionPolicyEnabled());
        table.setRedactionPolicyGenerateInDDL(this.isRedactionPolicyGenerateInDDL());
        table.setExistDependencyConstraintName(this.getExistDependencyConstraintName());
        table.setExistDependencyGenerateInDDl(this.isExistDependencyGenerateInDDl());
        table.setExistDependencyGenerationLevel(this.getExistDependencyGenerationLevel());
        table.getAdditionalClassificationTypes().clear();
        for (String id : this.getAdditionalClassificationTypes()) {
            table.getAdditionalClassificationTypes().add(id);
        }
        this.copySQLNames(table);
        table.setORDSEnable(this.isORDSEnable());
        table.setORDSAuth(this.isORDSAuth());
        table.setORDSAlias(this.getORDSAlias());
    }

    public void backupFKeysTO(Table backupTable, DesignPartView dpv) {
        FKIndexAssociation[] fkeys = this.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            FKIndexAssociation fk = fkeys[i];
            if (fk.getRemoteIndex() == null) continue;
            FKIndexAssociation bfk = backupTable.addBackupFK(fk);
            fk.backupTo(bfk, dpv);
            bfk.setCreatedTime(fk.getCreatedTime());
            bfk.setCreatedBy(fk.getCreatedBy());
        }
    }

    public void restoreTo(Table table) {
        Column old;
        int i;
        super.copy(table);
        table.setObjectID(this.getObjectID());
        table.setTypeID(this.getTypeID());
        table.setScope(this.getScope());
        table.setBasedOnStructuredType(this.getBasedOnStructuredType());
        table.setAbbreviation(this.getAbbreviation());
        table.setOidIsPK(this.isOidIsPK());
        table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
        table.setOnPrebuiltTable(this.isOnPrebuiltTable());
        table.setMaterializedQueryTable(this.isMaterializedQueryTable());
        table.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
        table.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
        table.setSyntaxProvider(this.getSyntaxProvider());
        table.setUserDefinedSQL(this.getUserDefinedSQL());
        table.setParsed(this.isParsed());
        table.setValidSQL(this.isValidSQL());
        table.setIncorrectSQL(this.isIncorrectSQL());
        table.setMinVolumes(this.getMinVolumes());
        table.setExpectedVolumes(this.getExpectedVolumes());
        table.setMaxVolumes(this.getMaxVolumes());
        table.setGrowthPercent(this.getGrowthPercent());
        table.setGrowthType(this.getGrowthType());
        table.setNormalForm(this.getNormalForm());
        table.setAdequatelyNormalized(this.getAdequatelyNormalized());
        table.setEngineerToRelation(this.isEngineerToRelation());
        table.setAllowColumnReorder(this.isAllowColumnReorder());
        table.setRemoteObjectID(this.getRemoteObjectID());
        table.setRemoteModelID(this.getRemoteModelID());
        table.setRemoteDesignID(this.getRemoteDesignID());
        table.setRemoteObjectRelativeStorageName(this.getRemoteObjectRelativeStorageName());
        table.setNameFixed(this.isNameFixed());
        this.copySourceStamp(table);
        table.setCreatedTime(this.getCreatedTime());
        table.setCreatedBy(this.getCreatedBy());
        if (!this.isBST()) {
            for (i = 0; i < this.getElements().length; ++i) {
                old = (Column)this.getElements()[i];
                Column col = table.createColumn(old.getName(), old.getObjectID());
                old.copy(col);
                old.copySourceStamp(col);
                col.setCreatedTime(old.getCreatedTime());
                col.setCreatedBy(old.getCreatedBy());
                old.copyDepenDendentColumnDescriptors(col, true, null);
                col.setObjectID(old.getObjectID());
                col.setNameFixed(old.isNameFixed());
            }
        } else {
            for (i = 0; i < this.getElements().length; ++i) {
                old = (Column)this.getElements()[i];
                if (!old.isOid()) {
                    String id = old.getStructAttributeID();
                    if (id == null || "".equals(id)) continue;
                    Column column = (Column)table.getElementByStructAttributeID(id);
                    column.setObjectID(old.getObjectID());
                    old.copy(column);
                    old.copyDepenDendentColumnDescriptors(column, true, null);
                    continue;
                }
                Column column = (Column)table.getOidElement();
                if (column == null) continue;
                column.setObjectID(old.getObjectID());
                old.copy(column);
                old.copyDepenDendentColumnDescriptors(column, true, null);
            }
        }
        KeyObject[] keys = this.getKeys();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            KeyObject oldKey = keys[i2];
            if (oldKey.isFK() || oldKey.isOidKey()) continue;
            KeyObject key = table.createKeyObject(oldKey.getObjectID());
            if (oldKey instanceof Index) {
                key.setObjectID(oldKey.getObjectID());
                key.setIndexState(oldKey.getIndexState());
            }
            oldKey.copy(key);
            oldKey.copySourceStamp(key);
            key.setContainerObject(table);
            key.setObjectID(oldKey.getObjectID());
            key.setNameFixed(oldKey.isNameFixed());
            key.setCreatedTime(oldKey.getCreatedTime());
            key.setCreatedBy(oldKey.getCreatedBy());
        }
        table.clearCheckConstraints();
        for (int i3 = 0; i3 < this.getCheckConstraints().size(); ++i3) {
            TableLevelConstraint oldTlc = (TableLevelConstraint)this.getCheckConstraints().get(i3);
            TableLevelConstraint tlc = table.createCheckConstraint(oldTlc.getName(), oldTlc.getRule());
            tlc.setNotes(oldTlc.getNotes());
            tlc.setComment(oldTlc.getComment());
            tlc.setCommentInRDBMS(oldTlc.getCommentInRDBMS());
            tlc.setGenerateInDDL(oldTlc.getGenerateInDDL());
            tlc.setID(oldTlc.getID());
            table.addCheckConstraint(tlc);
        }
        table.getValidTimeDimensions().clear();
        for (ValidTimeDimension oldVTD : this.getValidTimeDimensions()) {
            ValidTimeDimension backupVTD = new ValidTimeDimension(table);
            oldVTD.copy(backupVTD);
            backupVTD.setObjectID(oldVTD.getObjectID());
        }
        table.setSpatialTable(this.isSpatialTable());
        table.getSpatialDefinitions().clear();
        for (SpatialColumnDefObject spCol : this.getSpatialDefinitions()) {
            SpatialColumnDefObject t_spCol = new SpatialColumnDefObject(table);
            spCol.copyTo(t_spCol);
            t_spCol.setObjectID(spCol.getObjectID());
            table.addSpatialDefinition(t_spCol);
        }
        table.setBeforeDrop(this.getBeforeDrop());
        table.setBeforeCreate(this.getBeforeCreate());
        table.setAfterCreate(this.getAfterCreate());
        table.setEndOfScript(this.getEndOfScript());
        table.setShouldGenerateScript(this.getShouldGenerateScript());
        table.getColumnGroupsSet().clear();
        for (ColumnGroup cgOld : this.getColumnGroupsSet()) {
            ColumnGroup cgNew = table.createColumnGroup(cgOld.getName(), null);
            table.getColumnGroupsSet().add(cgNew);
            cgOld.copy(cgNew);
        }
        table.setRedactionPolicyName(this.getRedactionPolicyName());
        table.setRedactionPolicyDefaultExpression(this.getRedactionPolicyDefaultExpression());
        table.setRedactionPolicyEnabled(this.isRedactionPolicyEnabled());
        table.setRedactionPolicyGenerateInDDL(this.isRedactionPolicyGenerateInDDL());
        table.setExistDependencyConstraintName(this.getExistDependencyConstraintName());
        table.setExistDependencyGenerateInDDl(this.isExistDependencyGenerateInDDl());
        table.setExistDependencyGenerationLevel(this.getExistDependencyGenerationLevel());
        table.getAdditionalClassificationTypes().clear();
        for (String id : this.getAdditionalClassificationTypes()) {
            table.getAdditionalClassificationTypes().add(id);
        }
        table.setORDSEnable(this.isORDSEnable());
        table.setORDSAuth(this.isORDSAuth());
        table.setORDSAlias(this.getORDSAlias());
        table.removeQueryObjectListeners();
        this.copySQLNames(table);
        table.addQueryObjectListeners();
    }

    @Override
    public void applyChangesTo(DesignObject anotherState) {
        if (anotherState instanceof Table) {
            TableLevelConstraint tlc;
            Table table = (Table)anotherState;
            table.setSchemaObject(this.getSchemaObject());
            super.applyChangesTo(anotherState);
            table.setObjectID(this.getObjectID());
            table.setTypeID(this.getTypeID());
            table.setScope(this.getScope());
            table.setBasedOnStructuredType(this.getBasedOnStructuredType());
            table.setAbbreviation(this.getAbbreviation());
            table.setOidIsPK(this.isOidIsPK());
            table.setAllowTypeSubstitution(this.isAllowTypeSubstitution());
            table.setOnPrebuiltTable(this.isOnPrebuiltTable());
            table.setMaterializedQueryTable(this.isMaterializedQueryTable());
            table.setIncludeSchemaNameInQuery(this.includeSchemaNameInQuery());
            table.setUseObjectsOnlyFrom(this.getUseObjectsOnlyFrom());
            table.setSyntaxProvider(this.getSyntaxProvider());
            table.setUserDefinedSQL(this.getUserDefinedSQL());
            table.setParsed(this.isParsed());
            table.setValidSQL(this.isValidSQL());
            table.setIncorrectSQL(this.isIncorrectSQL());
            table.setMinVolumes(this.getMinVolumes());
            table.setExpectedVolumes(this.getExpectedVolumes());
            table.setMaxVolumes(this.getMaxVolumes());
            table.setGrowthPercent(this.getGrowthPercent());
            table.setGrowthType(this.getGrowthType());
            table.setNormalForm(this.getNormalForm());
            table.setAdequatelyNormalized(this.getAdequatelyNormalized());
            table.setEngineerToRelation(this.isEngineerToRelation());
            table.setAllowColumnReorder(this.isAllowColumnReorder());
            table.setRemoteObjectID(this.getRemoteObjectID());
            table.setRemoteModelID(this.getRemoteModelID());
            table.setRemoteDesignID(this.getRemoteDesignID());
            table.setRemoteObjectRelativeStorageName(this.getRemoteObjectRelativeStorageName());
            table.setSpatialTable(this.isSpatialTable());
            table.getSpatialDefinitions().clear();
            table.setBeforeDrop(this.getBeforeDrop());
            table.setBeforeCreate(this.getBeforeCreate());
            table.setAfterCreate(this.getAfterCreate());
            table.setEndOfScript(this.getEndOfScript());
            table.setShouldGenerateScript(this.getShouldGenerateScript());
            List constraints = table.getCheckConstraints();
            for (int i = constraints.size() - 1; i >= 0; --i) {
                tlc = (TableLevelConstraint)constraints.get(i);
                TableLevelConstraint oldTlc = this.getCheckConstraintByID(tlc.getObjectID());
                if (oldTlc != null) {
                    tlc.setName(oldTlc.getName());
                    tlc.setRule(oldTlc.getRule());
                    tlc.setNotes(oldTlc.getNotes());
                    tlc.setComment(oldTlc.getComment());
                    tlc.setCommentInRDBMS(oldTlc.getCommentInRDBMS());
                    tlc.setGenerateInDDL(oldTlc.getGenerateInDDL());
                    continue;
                }
                tlc.remove();
            }
            for (TableLevelConstraint oldTlc : this.getCheckConstraints()) {
                tlc = table.getCheckConstraintByID(oldTlc.getObjectID());
                if (tlc != null) continue;
                tlc = table.createCheckConstraint(oldTlc.getName(), oldTlc.getRule());
                tlc.setNotes(oldTlc.getNotes());
                tlc.setComment(oldTlc.getComment());
                tlc.setCommentInRDBMS(oldTlc.getCommentInRDBMS());
                tlc.setGenerateInDDL(oldTlc.getGenerateInDDL());
                tlc.setID(oldTlc.getID());
                table.addCheckConstraint(tlc);
            }
            table.getColumnGroupsSet().clear();
            for (ColumnGroup cgOld : this.getColumnGroupsSet()) {
                ColumnGroup cgNew = table.createColumnGroup(cgOld.getName(), null);
                table.getColumnGroupsSet().add(cgNew);
                cgOld.copy(cgNew);
            }
            table.setRedactionPolicyName(this.getRedactionPolicyName());
            table.setRedactionPolicyDefaultExpression(this.getRedactionPolicyDefaultExpression());
            table.setRedactionPolicyEnabled(this.isRedactionPolicyEnabled());
            table.setRedactionPolicyGenerateInDDL(this.isRedactionPolicyGenerateInDDL());
            table.setExistDependencyConstraintName(this.getExistDependencyConstraintName());
            table.setExistDependencyGenerateInDDl(this.isExistDependencyGenerateInDDl());
            table.setExistDependencyGenerationLevel(this.getExistDependencyGenerationLevel());
            table.getAdditionalClassificationTypes().clear();
            for (String id : this.getAdditionalClassificationTypes()) {
                table.getAdditionalClassificationTypes().add(id);
            }
            table.setORDSEnable(this.isORDSEnable());
            table.setORDSAuth(this.isORDSAuth());
            table.setORDSAlias(this.getORDSAlias());
            table.removeQueryObjectListeners();
            this.copySQLNames(table);
            table.addQueryObjectListeners();
            this.removeQueryObjectListeners();
        }
    }

    public void applyValidTimeDimensions(Table table) {
        table.getValidTimeDimensions().clear();
        for (ValidTimeDimension oldVTD : this.getValidTimeDimensions()) {
            ValidTimeDimension vtd = table.createValidTimeDimension();
            oldVTD.copy(vtd);
            vtd.setObjectID(oldVTD.getObjectID());
        }
    }

    public void applySpatialColumndefinitions(Table table) {
        table.getSpatialDefinitions().clear();
        for (SpatialColumnDefObject spCol : this.getSpatialDefinitions()) {
            SpatialColumnDefObject t_spCol = new SpatialColumnDefObject(table);
            spCol.copyTo(t_spCol);
            t_spCol.setObjectID(spCol.getObjectID());
            table.addSpatialDefinition(t_spCol);
        }
    }

    @Override
    public void paste() {
        for (Object obj : this.getAppView().getCopiedObjects()) {
            if (obj == null || !(obj instanceof Column)) continue;
            Column column = this.createColumn();
            Column copied = (Column)obj;
            copied.copy(column);
        }
    }

    public Entity getEngEntity() {
        DesignObject obj;
        XtdMapping mapping;
        DesignObject obj2;
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        Entity ent = null;
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() == 1 && (obj2 = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null) {
            if (obj2 instanceof Entity) {
                return (Entity)obj2;
            }
            return null;
        }
        for (XtdMapping mapping2 : list) {
            if (mapping2.getInheritanceType() != 0 || (obj = mapping2.getObjectMappedTo(this)) == null || !(obj instanceof Entity)) continue;
            return (Entity)obj;
        }
        for (XtdMapping mapping2 : list) {
            if (mapping2.getInheritanceType() != 3 || (obj = mapping2.getObjectMappedTo(this)) == null || !(obj instanceof Entity)) continue;
            return (Entity)obj;
        }
        obj2 = this.getGenerator();
        if (obj2 instanceof Entity) {
            ent = (Entity)obj2;
        }
        return ent;
    }

    public List getMappingsToEntities() {
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        ArrayList<XtdMapping> temp = new ArrayList<XtdMapping>();
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        for (XtdMapping mapping : list) {
            DesignObject obj = mapping.getObjectMappedTo(this);
            if (obj == null || !(obj instanceof Entity)) continue;
            temp.add(mapping);
        }
        return temp;
    }

    public boolean hasMappingWithEntity(Entity entity) {
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        for (XtdMapping mapping : list) {
            DesignObject obj = mapping.getObjectMappedTo(this);
            if (obj == null || !(obj instanceof Entity) || obj != entity) continue;
            return true;
        }
        return false;
    }

    public Relation getEngRelation() {
        XtdMapping mapping;
        DesignObject obj;
        MappingCollector mw = this.getRMExtendedMap().getOrCreateCollector(this);
        Relation rel = null;
        List list = mw.getMappingsForDesignPart(this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0 && (obj = (mapping = (XtdMapping)list.get(0)).getObjectMappedTo(this)) != null && obj instanceof Relation) {
            return (Relation)obj;
        }
        DesignObject obj2 = this.getGenerator();
        if (obj2 != null && obj2 instanceof Relation) {
            return (Relation)obj2;
        }
        if (rel == null) {
            if (!"User generated".equalsIgnoreCase(this.getGeneratorID())) {
                rel = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectByID(this.getGeneratorID());
            }
            if (rel == null) {
                rel = (Relation)this.getDesign().getLogicalDesign().getRelationSet().getObjectGeneratedBy(this.getObjectID());
            }
        }
        return rel;
    }

    @Override
    protected void clearStructure() {
        this.removeAllFKAssociations();
        this.removeAllKeys();
        this.removeAll();
    }

    @Override
    protected void updateStructure() {
        block6: {
            block5: {
                TypeElement te;
                int i;
                if (!this.isBST()) break block5;
                StructuredType st = this.getBasedOnStructuredType();
                if ("XMLTYPE".equalsIgnoreCase(st.getName())) break block6;
                List stElems = st.getAllElements();
                ContainedObject[] coar = this.getElements();
                for (i = 0; i < coar.length; ++i) {
                    if (coar[i].isOid() || (te = this.findTypeElement(stElems, coar[i].getStructAttributeID())) != null) continue;
                    coar[i].remove();
                }
                this.addOidColumn();
                this.updateElements(stElems);
                for (i = 0; i < stElems.size(); ++i) {
                    te = (TypeElement)stElems.get(i);
                    ContainedObject co = this.getElementByStructAttributeID(te.getObjectID());
                    if (co == null) continue;
                    this.moveToIndex(co, i + 1);
                }
                break block6;
            }
            ContainedObject[] cols = this.getElements();
            for (int i = 0; i < cols.length; ++i) {
                Column col = (Column)cols[i];
                Datatype colDatatype = col.getDataType();
                if (!(colDatatype instanceof StructuredType) || col.isReference()) continue;
                StructuredType st = (StructuredType)colDatatype;
                List stElems = st.getAllElements();
                Object[] coar = col.getNestedObjects().toArray();
                for (int j = 0; j < coar.length; ++j) {
                    ContainedObject cob = (ContainedObject)coar[j];
                    TypeElement te = this.findTypeElement(stElems, cob.getStructAttributeID());
                    if (te != null) continue;
                    this.removeNestedCOFor(cob);
                    cob.remove();
                    this.nestedElements.remove(cob);
                }
                List telems = ((StructuredType)col.getDataType()).getAllElements();
                for (int j = 0; j < telems.size(); ++j) {
                    this.createColumnAndNestedColumns((TypeElement)telems.get(j), col);
                }
            }
        }
    }

    private TypeElement findTypeElement(List list, String id) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement te = (TypeElement)list.get(i);
            if (!te.getObjectID().equalsIgnoreCase(id)) continue;
            return te;
        }
        return null;
    }

    private void addOidColumn() {
        if (this.getElementsCollection().size() == 0) {
            Column column;
            if (this.isBackup()) {
                column = new Column(this.getDesignPart());
                column.setName("Oid");
            } else {
                column = this.createColumn("Oid");
            }
            column.setOid(true);
            column.setUse((short)3);
            column.setReference(true);
            column.setStructuredType(this.getBasedOnStructuredType());
            this.addColumn(column);
            column.setNullsAllowed(false);
            Index index = this.createIndex();
            index.setPK(true);
            index.add(column);
            index.setName(ApplyNamingStandards.createPK_Name(this.getName(), this.getDesign().getDesignLevelSettings().getNamingStandardRule(), this.getDesignPart().getName(), this.getAbbreviation()));
            index.setOidKey(true);
            this.setUserDefinedOid(true);
        }
    }

    private void updateElements(List telems) {
        for (int i = 0; i < telems.size(); ++i) {
            TypeElement te = (TypeElement)telems.get(i);
            Column column = (Column)this.getElementByStructAttributeID(te.getObjectID());
            if (column == null) {
                if (this.isBackup()) {
                    column = new Column(this.getDesignPart());
                    column.setName(te.getName());
                } else {
                    column = this.createColumn(te.getName());
                }
                column.setStructAttributeID(te.getObjectID());
                this.addColumn(column);
            }
            this.copyTEtoColumn(te, column);
            if (!(te.getType() instanceof StructuredType) || te.isReference()) continue;
            this.createNestedColumnsOnly(te, column);
        }
    }

    public void createColumnAndNestedColumns(TypeElement te, Column parent) {
        Column column = (Column)this.getElementByStructAttributeID(te.getObjectID(), parent);
        if (column == null) {
            column = new Column(this.getDesignPart());
            column.setName(te.getName());
            column.setStructAttributeID(te.getObjectID());
            column.setParentObject(parent);
            this.addColumn(column);
        }
        this.copyTEtoColumn(te, column);
        if (te.getType() instanceof StructuredType && !te.isReference()) {
            StructuredType st = (StructuredType)te.getType();
            TypeElement[] telems = st.getElements();
            for (int i = 0; i < telems.length; ++i) {
                TypeElement tel = telems[i];
                Column nested_column = (Column)this.getElementByStructAttributeID(tel.getObjectID(), column);
                if (nested_column == null) {
                    nested_column = new Column(this.getDesignPart());
                    nested_column.setName(te.getName());
                    nested_column.setStructAttributeID(tel.getObjectID());
                    nested_column.setParentObject(column);
                    this.addColumn(nested_column);
                }
                this.copyTEtoColumn(tel, nested_column);
                if (!(tel.getType() instanceof StructuredType) || tel.isReference()) continue;
                this.createNestedColumnsOnly(tel, nested_column);
            }
        }
    }

    public void createNestedColumnsOnly(TypeElement te, Column parent) {
        if (te.getType() instanceof StructuredType && !te.isReference()) {
            StructuredType st = (StructuredType)te.getType();
            TypeElement[] telems = st.getElements();
            for (int i = 0; i < telems.length; ++i) {
                TypeElement tel = telems[i];
                Column nested_column = (Column)this.getElementByStructAttributeID(tel.getObjectID(), parent);
                if (nested_column == null) {
                    nested_column = new Column(this.getDesignPart());
                    nested_column.setName(te.getName());
                    nested_column.setStructAttributeID(tel.getObjectID());
                    nested_column.setParentObject(parent);
                    this.addColumn(nested_column);
                }
                this.copyTEtoColumn(tel, nested_column);
                if (!(tel.getType() instanceof StructuredType) || tel.isReference()) continue;
                this.createNestedColumnsOnly(tel, nested_column);
            }
        } else {
            Column column = (Column)this.getElementByStructAttributeID(te.getObjectID(), parent);
            if (column == null) {
                column = new Column(this.getDesignPart());
                column.setName(te.getName());
                column.setStructAttributeID(te.getObjectID());
                column.setParentObject(parent);
                this.addColumn(column);
            }
            this.copyTEtoColumn(te, column);
        }
    }

    public void createNestedColumnsOnly(StructuredType st, Column parent) {
        Object[] coar = parent.getNestedObjects().toArray();
        if (st == null || parent.isReference() || parent.getUse() != 3) {
            for (int j = 0; j < coar.length; ++j) {
                ContainedObject cob = (ContainedObject)coar[j];
                this.removeNestedCOFor(cob);
                cob.remove();
                this.nestedElements.remove(cob);
            }
        } else {
            List stElems = st.getAllElements();
            for (int j = 0; j < coar.length; ++j) {
                ContainedObject cob = (ContainedObject)coar[j];
                TypeElement te = this.findTypeElement(stElems, cob.getStructAttributeID());
                if (te != null) continue;
                this.removeNestedCOFor(cob);
                cob.remove();
                this.nestedElements.remove(cob);
            }
            TypeElement[] telems = st.getElements();
            for (int i = 0; i < telems.length; ++i) {
                TypeElement tel = telems[i];
                Column nested_column = (Column)this.getElementByStructAttributeID(tel.getObjectID(), parent);
                if (nested_column == null) {
                    nested_column = new Column(this.getDesignPart());
                    nested_column.setStructAttributeID(tel.getObjectID());
                    nested_column.setParentObject(parent);
                    this.addColumn(nested_column);
                }
                this.copyTEtoColumn(tel, nested_column);
            }
        }
    }

    private void copyTEtoColumn(TypeElement te, Column column) {
        column.setName(te.getName());
        column.setNameHasQuotes(te.getNameHasQuotes());
        if (te.getType() instanceof LogicalDatatype) {
            column.setUse((short)1);
            column.setLogicalDatatype((LogicalDatatype)te.getType());
            column.setReference(false);
            String units = te.getUnits();
            if (units != null && !"".equals(units) && !te.getSize().equals("")) {
                column.setDataTypeParameter("size", te.getSize() + " " + units);
            } else {
                column.setDataTypeParameter("size", te.getSize());
            }
            column.setDataTypeParameter("precision", Integer.toString(te.getPrecision()));
            column.setDataTypeParameter("scale", Integer.toString(te.getScale()));
        } else if (te.getType() instanceof DistinctType) {
            column.setUse((short)2);
            column.setDistinctType((DistinctType)te.getType());
            column.setReference(false);
        } else if (te.getType() instanceof StructuredType) {
            column.setUse((short)3);
            column.setReference(te.isReference());
            column.setStructuredType((StructuredType)te.getType());
        } else if (te.getType() instanceof CollectionType) {
            column.setUse((short)4);
            column.setCollectionType((CollectionType)te.getType());
        } else if (te.getType() instanceof Domain) {
            Domain dom = (Domain)te.getType();
            column.setUse((short)0);
            column.setDomain(dom);
            column.setReference(false);
            column.setDataTypeParameter("size", dom.getSize());
            column.setDataTypeParameter("precision", dom.getPrecision());
            column.setDataTypeParameter("scale", dom.getScale());
        }
        column.setMandatory(te.isMandatory() || column.isMandatory());
    }

    public List getNonStructuredElements() {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column col : this.getElementsCollection()) {
            if (col.isOid() || col.isReference() || col.getDataType() instanceof StructuredType) continue;
            list.add(col);
        }
        return list;
    }

    public boolean isUserDefinedOid() {
        return this.userDefinedOid;
    }

    public void setUserDefinedOid(boolean userDefinedOid) {
        this.userDefinedOid = userDefinedOid;
    }

    public List getOidPKColumns() {
        Index pk = (Index)this.getPK();
        if (pk != null) {
            this.oidPKColumns.clear();
            Column oid = (Column)this.getOidElement();
            if (oid != null && pk.contains(oid)) {
                return this.oidPKColumns;
            }
            this.oidPKColumns.addAll(pk.getElementsCollection());
        }
        return this.oidPKColumns;
    }

    public void setOidPKColumns(List oidPKColumns) {
        this.oidPKColumns = oidPKColumns;
    }

    public List getAllPossibleElements() {
        ArrayList list = new ArrayList();
        list.addAll(this.getElementsCollection());
        if (this.hasTypeSubstitutionChildren() && this.getTypeSubstitution() == null) {
            list.addAll(this.getElementsFromSubTables());
        }
        return list;
    }

    private List getElementsFromSubTables() {
        ArrayList list = new ArrayList();
        if (this.hasTypeSubstitutionChildren()) {
            for (TypeSubstitution ts : this.getSubTypeSubstitutions()) {
                Table table = (Table)ts.getChildContainerObject();
                list.addAll(table.getElementsFromStructuredType(table.basedOnStructuredType));
                list.addAll(table.getElementsFromSubTables());
            }
        }
        return list;
    }

    private List getElementsFromStructuredType(StructuredType st) {
        ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
        if (st != null) {
            TypeElement[] elems = st.getElements();
            for (int i = 0; i < elems.length; ++i) {
                ContainedObject obj = this.getElementByStructAttributeID(elems[i].getObjectID());
                if (obj == null) continue;
                list.add(obj);
            }
        }
        return list;
    }

    public boolean isReferencedByFKs() {
        Iterator it = ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (fk.getRemoteTable() != this) continue;
            return true;
        }
        return false;
    }

    public List getAllNestedElements() {
        ArrayList<Column> list = new ArrayList<Column>();
        if (this.hasTypeSubstitutionChildren()) {
            for (TypeSubstitution ts : this.getSubTypeSubstitutions()) {
                Table table = (Table)ts.getChildContainerObject();
                ContainedObject[] selfElements = table.getElements();
                for (int i = 0; i < selfElements.length; ++i) {
                    Column col = (Column)selfElements[i];
                    if (!col.isAtomic() || list.contains(col)) continue;
                    list.add(col);
                }
                for (Column col : table.getNestedElements()) {
                    if (!col.isAtomic() || list.contains(col)) continue;
                    list.add(col);
                }
            }
        } else {
            ContainedObject[] selfElements = this.getElements();
            for (int i = 0; i < selfElements.length; ++i) {
                Column col = (Column)selfElements[i];
                if (!col.isAtomic() || list.contains(col)) continue;
                list.add(col);
            }
            for (Column col : this.getNestedElements()) {
                if (!col.isAtomic() || list.contains(col)) continue;
                list.add(col);
            }
        }
        return list;
    }

    public String getSplittedTableID() {
        return this.splittedTableID;
    }

    public void setSplittedTableID(String splittedTableID) {
        this.splittedTableID = splittedTableID;
    }

    public List getPossibleSplits() {
        ArrayList<Table> list = new ArrayList<Table>();
        Iterator it = ((TableSet)this.getParent()).iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (!table.getSplittedTableID().equalsIgnoreCase(this.getObjectID())) continue;
            list.add(table);
        }
        return list;
    }

    public XtdMapping getDeletedMapping() {
        List list = this.getRMExtendedMap().getDeletedMappingsForDesignPart(this, this.getDesign().getLogicalDesign().getObjectID());
        if (list.size() > 0) {
            XtdMapping mapping = (XtdMapping)list.get(0);
            return mapping;
        }
        return null;
    }

    @Override
    public KeyObject getIndexByID(String objectID) {
        Iterator indexesIterator = this.getKeySet().iterator();
        while (indexesIterator.hasNext()) {
            KeyObject index = (KeyObject)indexesIterator.next();
            if (!index.getObjectID().equals(objectID)) continue;
            return index;
        }
        return null;
    }

    public Index getIndexByName(String indexName) {
        KeyObject[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Index index = (Index)keys[i];
            if (!index.getName().equals(indexName)) continue;
            return index;
        }
        return null;
    }

    public Index getIndexByNameAndSchema(String schema, String indexName) {
        if (schema != null && indexName != null && !"".equals(schema)) {
            KeyObject[] keys = this.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                Index index = (Index)keys[i];
                if (!index.getName().equals(indexName) || !schema.equals(index.getSchema())) continue;
                return index;
            }
        }
        return null;
    }

    public boolean isSpatialTable() {
        return this.isSpatialTable;
    }

    public void setSpatialTable(boolean isSpatialTable) {
        this.isSpatialTable = isSpatialTable;
    }

    public List getSpatialDefinitions() {
        if (this.spatialDefinitions == null) {
            this.spatialDefinitions = new ArrayList();
        }
        return this.spatialDefinitions;
    }

    public void setSpatialDefinitions(List spatialDefinitions) {
        this.spatialDefinitions = spatialDefinitions;
    }

    public void addSpatialDefinition(SpatialColumnDefObject spObject) {
        if (!this.getSpatialDefinitions().contains(spObject)) {
            this.getSpatialDefinitions().add(spObject);
        }
    }

    public boolean isOidIsPK() {
        return this.oidIsPK;
    }

    public void setOidIsPK(boolean oidIsPK) {
        this.oidIsPK = oidIsPK;
    }

    public List getAllowedStrTypeInstances() {
        ArrayList list = new ArrayList();
        this.addStructuredSubTypeInstances(this, list);
        return list;
    }

    private void addStructuredSubTypeInstances(Table table, List list) {
        if (table.isBST()) {
            list.add(table.getBasedOnStructuredType());
            for (TypeSubstitution ts : table.getSubTypeSubstitutions()) {
                Table child = (Table)ts.getChildContainerObject();
                this.addStructuredSubTypeInstances(child, list);
            }
        }
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public FontObject getFontObject(String type) {
        for (FontObject next : this.editableFonts) {
            if (!type.equalsIgnoreCase(next.getType())) continue;
            return next;
        }
        return null;
    }

    public List getAllSubstitutionTables() {
        ArrayList<Table> list = new ArrayList<Table>();
        if (this.hasTypeSubstitutionChildren()) {
            for (TypeSubstitution ts : this.getSubTypeSubstitutions()) {
                Table table = (Table)ts.getChildContainerObject();
                list.add(table);
                list.addAll(table.getAllSubstitutionTables());
            }
        }
        return list;
    }

    public int getFKAssociationsCount() {
        return this.fkList.size();
    }

    public List getFKeysOnColumn(Column column) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        for (FKIndexAssociation fk : this.fkList) {
            if (!fk.getLocalFKIndex().contains(column)) continue;
            list.add(fk);
        }
        return list;
    }

    public ValidTimeDimension createValidTimeDimension() {
        return new ValidTimeDimension(this);
    }

    public void addValidTimeDimension(ValidTimeDimension validTimeDimension) {
        if (!this.validTimeDimensions.contains(validTimeDimension)) {
            this.validTimeDimensions.add(validTimeDimension);
            validTimeDimension.setTable(this);
        }
    }

    public void removeValidTimeDimension(ValidTimeDimension validTimeDimension) {
        if (this.validTimeDimensions.contains(validTimeDimension)) {
            this.validTimeDimensions.remove(validTimeDimension);
            validTimeDimension.remove();
        }
    }

    public List<ValidTimeDimension> getValidTimeDimensions() {
        return this.validTimeDimensions;
    }

    public ValidTimeDimension getValidTimeDimensionByID(String id) {
        for (ValidTimeDimension validTimeDimension : this.validTimeDimensions) {
            if (!validTimeDimension.getObjectID().equals(id)) continue;
            return validTimeDimension;
        }
        return null;
    }

    public boolean hasNoneTransferableFK() {
        FKIndexAssociation[] fkeys = this.getFKAssociations();
        for (int i = 0; i < fkeys.length; ++i) {
            if (fkeys[i].isTransferable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBedeleted() {
        if (this.getDesign().isRepositoryRelated()) {
            if (this.getDesignPart().isCheckedOutByMe()) {
                return this.getRepositoryOID() == null || !this.isReferencedByFKs();
            }
            return false;
        }
        return true;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void addColumnGroup(ColumnGroup columnGroup) {
        if (!this.getColumnGroupsSet().contains(columnGroup)) {
            this.getColumnGroupsSet().add(columnGroup);
        }
    }

    public void removeColumnGroup(ColumnGroup columnGroup) {
        this.getColumnGroupsSet().remove(columnGroup);
    }

    public List getColumnGroupsSet() {
        if (this.columnGroupsSet == null) {
            this.columnGroupsSet = new ArrayList<ColumnGroup>();
        }
        return this.columnGroupsSet;
    }

    public ColumnGroup createColumnGroup() {
        ColumnGroup columnGroup = new ColumnGroup(null);
        this.addColumnGroup(columnGroup);
        return columnGroup;
    }

    public ColumnGroup createColumnGroup(String name, String id) {
        ColumnGroup columnGroup = new ColumnGroup(null);
        if (id != null) {
            columnGroup.setObjectID(id);
        }
        if (name != null) {
            columnGroup.setName(name);
        }
        return columnGroup;
    }

    public ColumnGroup getColumnGroupByID(String id) {
        for (ColumnGroup cg : this.getColumnGroupsSet()) {
            if (!cg.getObjectID().equals(id)) continue;
            return cg;
        }
        return null;
    }

    public void applyIndexOrderFromList(List orderedIndexes) {
        this.getKeySet().applyOrderFromList(orderedIndexes);
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "table" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SpatialColumnDefObject createSpatialDefinition() {
        SpatialColumnDefObject spd = new SpatialColumnDefObject(this);
        this.getSpatialDefinitions().add(spd);
        return spd;
    }

    public void removeSpatialDefinition(SpatialColumnDefObject spdef) {
        this.getSpatialDefinitions().remove(spdef);
    }

    public SpatialColumnDefObject getSpatialDefinitionByID(String id) {
        for (SpatialColumnDefObject spd : this.getSpatialDefinitions()) {
            if (!spd.getObjectID().equals(id)) continue;
            return spd;
        }
        return null;
    }

    public Column getColumnByProperty(String propName, String value) {
        for (Column col : this.getElementsCollection()) {
            String pvalue = col.getProperty(propName);
            if (pvalue == null || !pvalue.equals(value)) continue;
            return col;
        }
        return null;
    }

    public Object[] getColumnsByProperty(String propName, String value) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (Column col : this.getElementsCollection()) {
            String pvalue = col.getProperty(propName);
            if (pvalue == null || !pvalue.equals(value)) continue;
            list.add(col);
        }
        return list.toArray();
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }

    public Index getUniqueIndex_PK_UK(Column[] columns) {
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (!index.isPK() && !index.isUnique() && !index.isUniquePlainIndex() || !index.isIndexForColumns(columns)) continue;
            return index;
        }
        return null;
    }

    public Index getUniqueIndex(Column[] columns) {
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (!index.isUniquePlainIndex() || !index.isIndexForColumns(columns)) continue;
            return index;
        }
        return null;
    }

    public List getIndexesWithRelationGeneratorID(String id) {
        ArrayList<Index> list = new ArrayList<Index>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.isFK() || !id.equals(index.getRelationGeneratorID())) continue;
            list.add(index);
        }
        return list;
    }

    public Index getIndex(Column[] columns) {
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.isPK() || index.isUnique() || index.isUniquePlainIndex() || index.isFK() || !index.isIndexForColumns(columns)) continue;
            return index;
        }
        return null;
    }

    public FKElement getEquivelentColumn(FKElement extColumn, String name) {
        return this.getEquivelentColumn(extColumn, name, true);
    }

    public void resetIdentityColumn() {
        KeyObject pk;
        Column column;
        Iterator it = this.getElementsCollection().iterator();
        ArrayList<Column> list = new ArrayList<Column>();
        while (it.hasNext()) {
            column = (Column)it.next();
            if (column.isIdentityColumn()) {
                return;
            }
            if (!column.isAutoIncrementColumn()) continue;
            list.add(column);
        }
        if (list.size() == 1) {
            column = (Column)list.get(0);
            if (column.isMandatory()) {
                column.setIdentityColumn(true);
                return;
            }
        } else if (list.size() > 1 && (pk = this.getPK()) != null && pk.getElementsCollection().size() == 1) {
            for (Column column2 : list) {
                if (!column2.isPKElement()) continue;
                column2.setIdentityColumn(true);
                return;
            }
        }
    }

    public RMExtendedMap getRMExtendedMap() {
        return ((RelationalDesign)this.getDesignPart()).getRMExtendedMap();
    }

    @Override
    public List getPK_UKList() {
        ArrayList<Index> list = new ArrayList<Index>();
        Index key = (Index)this.getPK();
        if (key != null) {
            list.add(key);
        }
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (!index.isUnique()) continue;
            list.add(index);
        }
        return list;
    }

    public List getIndexes_Plain_List() {
        ArrayList<Index> list = new ArrayList<Index>();
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (index.isUnique() || index.isPK() || index.isFK()) continue;
            list.add(index);
        }
        return list;
    }

    public boolean isAllowColumnReorder() {
        return this.allowColumnReorder;
    }

    public void setAllowColumnReorder(boolean alloColumnReorder) {
        this.allowColumnReorder = alloColumnReorder;
    }

    @Override
    public DesignObject getTempObject() {
        return new Table(this.getDesignPart());
    }

    public Column getDiscriminatorColumn() {
        for (Column col : this.getElementsCollection()) {
            if (!col.isDiscriminatorColumn()) continue;
            return col;
        }
        return null;
    }

    public Index getSurrogateKey() {
        Index ind = (Index)this.getPK();
        if (ind != null && ind.isSurrogateKey()) {
            return ind;
        }
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            ind = (Index)it.next();
            if (!ind.isSurrogateKey()) continue;
            return ind;
        }
        return null;
    }

    @Override
    public RelationalDesign getRelationalModel() {
        return (RelationalDesign)this.getDesignPart();
    }

    public Column getSurrogateColumn() {
        for (Column col : this.getElementsCollection()) {
            if (!col.isSurrogateColumn()) continue;
            return col;
        }
        return null;
    }

    @Override
    public List getColumnsDependinOn(FKIndexAssociation fk) {
        ArrayList<Column> list = null;
        for (Column col : this.getElementsCollection()) {
            if (fk != col.getDependOnForeignKey()) continue;
            if (list == null) {
                list = new ArrayList<Column>();
            }
            list.add(col);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isEngineerToRelation() {
        return this.engineerToRelation;
    }

    public void setEngineerToRelation(boolean engineerToRelation) {
        this.engineerToRelation = engineerToRelation;
    }

    public boolean shouldEngineerToRelation() {
        return this.isEngineerToRelation() && this.isMtoNjoinCandidate();
    }

    public String getRedactionPolicyName() {
        return this.redactionPolicyName;
    }

    public void setRedactionPolicyName(String redactionPolicyName) {
        this.redactionPolicyName = redactionPolicyName;
    }

    public String getRedactionPolicyDefaultExpression() {
        return this.redactionPolicyDefaultExpression;
    }

    public void setRedactionPolicyDefaultExpression(String redactionPolicyDefaultExpression) {
        this.redactionPolicyDefaultExpression = redactionPolicyDefaultExpression;
    }

    public boolean isRedactionPolicyEnabled() {
        return this.redactionPolicyEnabled;
    }

    public void setRedactionPolicyEnabled(boolean redactionPolicyEnabled) {
        this.redactionPolicyEnabled = redactionPolicyEnabled;
    }

    public boolean isRedactionPolicyGenerateInDDL() {
        return this.redactionPolicyGenerateInDDL;
    }

    public void setRedactionPolicyGenerateInDDL(boolean redactionPolicyGenerateInDDL) {
        this.redactionPolicyGenerateInDDL = redactionPolicyGenerateInDDL;
    }

    public boolean isExistDependencyGenerateInDDl() {
        return this.existDependencyGenerateInDDl;
    }

    public void setExistDependencyGenerateInDDl(boolean existDependencyGenerateInDDl) {
        this.existDependencyGenerateInDDl = existDependencyGenerateInDDl;
    }

    public String getExistDependencyGenerationLevel() {
        return this.existDependencyGenerationLevel;
    }

    public void setExistDependencyGenerationLevel(String existDependencyGenerationLevel) {
        this.existDependencyGenerationLevel = existDependencyGenerationLevel;
    }

    public String getExistDependencyConstraintName() {
        return this.existDependencyConstraintName;
    }

    public void setExistDependencyConstraintName(String existDependencyConstraintName) {
        this.existDependencyConstraintName = existDependencyConstraintName;
    }

    public String getValidTimeDimAsString() {
        String res = null;
        for (ValidTimeDimension v : this.getValidTimeDimensions()) {
            if (res == null) {
                res = v.getName();
                if (v.getStartTimeColumn() != null) {
                    res = res + " <" + v.getStartTimeColumn().getName();
                }
                if (v.getStartTimeColumn() == null) continue;
                res = res + " , " + v.getStartTimeColumn().getName() + ">";
                continue;
            }
            res = res + "\n" + v.getName();
            if (v.getStartTimeColumn() != null) {
                res = res + " <" + v.getStartTimeColumn().getName();
            }
            if (v.getStartTimeColumn() == null) continue;
            res = res + " , " + v.getStartTimeColumn().getName() + ">";
        }
        if (res == null) {
            res = "";
        }
        return res;
    }

    public Index getPKorUKWithName(String indexName) {
        if (indexName != null) {
            Iterator it = this.getKeySet().iterator();
            while (it.hasNext()) {
                Index key = (Index)it.next();
                if (!key.isPK() && !key.isUnique() || !indexName.equalsIgnoreCase(key.getName())) continue;
                return key;
            }
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        String tid = this.getTypeID();
        String tableIcon = "5".equalsIgnoreCase(tid) ? "TEMPORARY_TABLE_ICON" : ("6".equalsIgnoreCase(tid) ? "EXTERNAL_TABLE_ICON" : "TABLE_ICON");
        return GUIConfiguration.getInstance().getIcon(tableIcon, 16);
    }

    @Override
    public boolean setName(String name) {
        String oldName = this.getName();
        if (name != null && name.equals(oldName)) {
            return true;
        }
        boolean result = super.setName(name);
        if (result && this.isMaterializedQueryTable() && !this.design.isLoading() && !this.isBackup()) {
            this.updateSnapshotNames();
        }
        return result;
    }

    public boolean isMaterializedQueryTable() {
        return this.materializedQueryTable;
    }

    public void setMaterializedQueryTable(boolean materializedQueryTable) {
        if (this.materializedQueryTable != materializedQueryTable) {
            this.materializedQueryTable = materializedQueryTable;
            if (materializedQueryTable && !this.design.isLoading() && !this.isBackup()) {
                this.generateOracleSnapshots();
            }
        }
    }

    public boolean isOnPrebuiltTable() {
        return this.onPrebuiltTable;
    }

    public void setOnPrebuiltTable(boolean onPrebuiltTable) {
        if (this.onPrebuiltTable != onPrebuiltTable) {
            this.onPrebuiltTable = onPrebuiltTable;
            if (this.materializedQueryTable && !this.design.isLoading() && !this.isBackup()) {
                this.updateSnapshotsForPrebuilt();
            }
        }
    }

    @Override
    public String getUserDefinedSQL() {
        return this.userDefinedSQL;
    }

    @Override
    public void setUserDefinedSQL(String userDefinedSQL) {
        this.userDefinedSQL = userDefinedSQL;
    }

    @Override
    public String getLayoutSQL() {
        return "";
    }

    @Override
    public List getSQLNames() {
        if (this.sqlNames == null) {
            this.sqlNames = new ArrayList();
        }
        return this.sqlNames;
    }

    public List getUsedObjectsList() {
        return this.getSQLNames();
    }

    public void addUsedObject(SQLNameHelper helper) {
        this.getSQLNames().add(helper);
    }

    public SQLNameHelper createSQLNameHelper() {
        return new SQLNameHelper();
    }

    public SQLNameHelper getSQLNameHelperByID(String id) {
        if (id != null) {
            for (SQLNameHelper sh : this.getSQLNames()) {
                if (!id.equalsIgnoreCase(sh.getID())) continue;
                return sh;
            }
        }
        return null;
    }

    public boolean includeSchemaNameInQuery() {
        return this.includeSchemaNameInQuery;
    }

    public void setIncludeSchemaNameInQuery(boolean includeSchemaNameInQuery) {
        this.includeSchemaNameInQuery = includeSchemaNameInQuery;
    }

    @Override
    public boolean isValidSQL() {
        return this.validSQL;
    }

    @Override
    public void setValidSQL(boolean validSQL) {
        if (this.validSQL != validSQL) {
            this.validSQL = validSQL;
            this.setDirty(true);
        }
    }

    @Override
    public boolean isParsed() {
        if (!this.parsed) {
            return this.userDefinedSQL.length() == 0;
        }
        return this.parsed;
    }

    @Override
    public void setParsed(boolean parsed) {
        if (this.parsed != parsed) {
            this.parsed = parsed;
            this.setDirty(true);
        }
    }

    @Override
    public boolean isIncorrectSQL() {
        return this.incorrectSQL;
    }

    @Override
    public void setIncorrectSQL(boolean incorrectSQL) {
        if (this.incorrectSQL != incorrectSQL) {
            this.incorrectSQL = incorrectSQL;
            this.setDirty(true);
        }
    }

    public String getUseObjectsOnlyFrom() {
        return this.useObjectsOnlyFrom;
    }

    public void setUseObjectsOnlyFrom(String useObjectsOnlyFrom) {
        this.useObjectsOnlyFrom = useObjectsOnlyFrom;
    }

    @Override
    public String getSyntaxProvider() {
        return this.syntaxProvider;
    }

    @Override
    public void setSyntaxProvider(String syntaxProvider) {
        this.syntaxProvider = syntaxProvider;
    }

    public void validateSQL() {
        QueryBuilder queryBuilder = new QueryBuilder(true);
        PlainTextSQLBuilder plainTextSQLBuilder = new PlainTextSQLBuilder();
        plainTextSQLBuilder.setKeywordFormat(KeywordFormat.UpperCase);
        plainTextSQLBuilder.setQueryBuilder(queryBuilder);
        QBUtils.initProperties(this, queryBuilder, plainTextSQLBuilder, null, null, this.includeSchemaNameInQuery(), false);
        QBUtils.updateMetadata(this, queryBuilder, plainTextSQLBuilder, this.includeSchemaNameInQuery());
        boolean columnCountMismatch = false;
        if (!this.isBST()) {
            QBUtils.createTableColumns(this, queryBuilder);
            if (queryBuilder.getQueryStatistics().getOutputColumns().getCount() != this.getElementsCollection().size()) {
                columnCountMismatch = true;
            }
        }
        QBUtils.setTableSQL(this, queryBuilder, plainTextSQLBuilder, true);
        if (columnCountMismatch) {
            this.setIncorrectSQL(true);
        }
        this.setValidSQL(true);
        this.setParsed(true);
    }

    public void parseSQL(QueryBuilder queryBuilder) {
        QBUtils.initSQL(this, queryBuilder);
        boolean columnCountMismatch = false;
        if (!this.isBST()) {
            QBUtils.createTableColumns(this, queryBuilder);
            if (queryBuilder.getQueryStatistics().getOutputColumns().getCount() != this.getElementsCollection().size()) {
                columnCountMismatch = true;
            }
        }
        this.updateSQLNames(queryBuilder);
        if (columnCountMismatch) {
            this.setIncorrectSQL(true);
        }
        this.setValidSQL(true);
        this.setParsed(true);
    }

    public void copySQLNames(Table table) {
        table.getSQLNames().clear();
        for (SQLNameHelper sqlh : this.getSQLNames()) {
            table.addUsedObject(sqlh.clone());
        }
    }

    public void addQueryObjectListeners() {
        if (this.getUserDefinedSQL().length() > 0 && this.isParsed()) {
            for (SQLNameHelper helper : this.getSQLNames()) {
                DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
                if (desObj == null) continue;
                desObj.addObjectListener(this);
            }
        }
    }

    public void removeQueryObjectListeners() {
        for (SQLNameHelper helper : this.getSQLNames()) {
            DesignObject desObj = this.getDesign().getDesignObject(helper.getID());
            if (desObj == null) continue;
            desObj.removeObjectListener(this);
        }
    }

    private void generateOracleSnapshots() {
        for (StorageDesign storageDesign : this.getRelationalModel().getSorageDesigns()) {
            TableProxyOracle tableProxyOracle;
            if (!storageDesign.isOpen() || !(storageDesign instanceof StorageDesignOracle) || (tableProxyOracle = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(this.getObjectID())) == null) continue;
            tableProxyOracle.generateSnapshot();
        }
    }

    private void updateSnapshotsForPrebuilt() {
        for (StorageDesign storageDesign : this.getRelationalModel().getSorageDesigns()) {
            TableProxyOracle tableProxyOracle;
            if (!storageDesign.isOpen() || !(storageDesign instanceof StorageDesignOracle) || (tableProxyOracle = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(this.getObjectID())) == null) continue;
            tableProxyOracle.updateSnapshotForPrebuilt();
        }
    }

    private void updateSnapshotNames() {
        for (StorageDesign storageDesign : this.getRelationalModel().getSorageDesigns()) {
            TableProxyOracle tableProxyOracle;
            if (!storageDesign.isOpen() || !(storageDesign instanceof StorageDesignOracle) || (tableProxyOracle = (TableProxyOracle)storageDesign.getTableProxySet().getProxy(this.getObjectID())) == null) continue;
            tableProxyOracle.updateSnapshotName();
        }
    }

    @Override
    protected List<ModelIDObject> getDependentConstrainedObjects() {
        if (this.getKeySet().size() > 0) {
            ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
            Iterator it = this.getKeySet().iterator();
            while (it.hasNext()) {
                KeyObject key = (KeyObject)it.next();
                if (key.isFK()) {
                    list.add(key.getFKAssociation());
                    continue;
                }
                list.add(key);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List getConstraintsSupprtedByIndex(Index ind) {
        ArrayList<Index> list = null;
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            Index key = (Index)it.next();
            if (!key.isPK() && !key.isUnique() || ind == key || ind.getSupportedConstraint() != key && !ind.canSupportConstraint(ind, key, true)) continue;
            if (list == null) {
                list = new ArrayList<Index>();
            }
            list.add(key);
        }
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public FKArc getArcForForeignKeys(List fkeys) {
        FKArc arc2 = null;
        for (FKArc arc2 : this.getArcs()) {
            for (Object obj : fkeys) {
                if (!arc2.getFkeys().contains(obj)) continue;
                return arc2;
            }
        }
        return null;
    }

    @Override
    public Collection getElementsCollection() {
        return super.getElementsCollection();
    }

    public class ColumnGroup {
        public static final String TYPE_NAME = "ColumnGroup";
        String name = "";
        String objectId = "";
        String note = "";
        List<String> columns = null;

        public ColumnGroup(String name) {
            this.name = name;
            this.columns = new ArrayList<String>();
            this.objectId = new GUID().toString();
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setObjectID(String objectId) {
            this.objectId = objectId;
        }

        public String getObjectID() {
            return this.objectId;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public void setNote(String note) {
            this.note = note;
        }

        public String getNote() {
            return this.note;
        }

        public String getColumnRefs() {
            if (this.columns.size() > 0) {
                StringBuffer sb = new StringBuffer();
                boolean first = true;
                for (String id : this.columns) {
                    if (first) {
                        sb.append(id);
                        first = false;
                        continue;
                    }
                    sb.append(' ').append(id);
                }
                return sb.toString();
            }
            return "";
        }

        public void setColumnRefs(String refs) {
            if (refs != null) {
                this.columns.clear();
                String[] ids = refs.split(" ");
                for (int i = 0; i < ids.length; ++i) {
                    this.columns.add(ids[i]);
                }
            }
        }

        public void copy(ColumnGroup columnGroup, Map map) {
            columnGroup.setObjectID(this.getObjectID());
            columnGroup.setName(this.getName());
            columnGroup.setNote(this.getNote());
            columnGroup.getColumns().clear();
            if (map == null) {
                columnGroup.getColumns().addAll(this.getColumns());
            } else {
                List<String> tlist = columnGroup.getColumns();
                for (String col_id : this.getColumns()) {
                    Column col = (Column)map.get(col_id);
                    if (col == null) continue;
                    tlist.add(col.getObjectID());
                }
            }
        }

        public void copy(ColumnGroup columnGroup) {
            this.copy(columnGroup, null);
        }
    }

    public class DesignObjectPH_ShortName
    extends DesignObjectPlaceHolder {
        public DesignObjectPH_ShortName(DesignObject object) {
            super(object);
        }

        @Override
        public String toString() {
            return this.getDesignObject().getName();
        }
    }

    private class PendingFKAssociationRecreation {
        private String referencedTableId;
        private String referencedKeyId;
        private String referencedFKAssocId;
        private String deleteRule;
        private String name$;
        private String comments;
        private String notes;
        private String localIndexId = null;
        private String mandatory;
        private String transferable;

        PendingFKAssociationRecreation(String referencedTableId, String referencedKeyId, String referencedFKAssocId, String deleteRule, String name, String comments, String notes) {
            this.referencedTableId = referencedTableId;
            this.referencedKeyId = referencedKeyId;
            this.referencedFKAssocId = referencedFKAssocId;
            this.deleteRule = deleteRule;
            this.name$ = name;
            this.comments = comments;
            this.notes = notes;
        }

        PendingFKAssociationRecreation(String referencedTableId, String referencedKeyId, String referencedFKAssocId, String localIndexId, String deleteRule, String name, String comments, String notes, String mandatory, String transferable) {
            this(referencedTableId, referencedKeyId, referencedFKAssocId, deleteRule, name, comments, notes);
            this.localIndexId = localIndexId;
            this.mandatory = mandatory;
            this.transferable = transferable;
        }

        public void resolve() {
            Table refTable = (Table)Table.this.getDesign().getDesignObject(this.referencedTableId);
            if (refTable != null) {
                KeyObject index = refTable.getKeyObject(this.referencedKeyId);
                FKIndexAssociation fk = Table.this.recreateFK(index, this.referencedFKAssocId, this.localIndexId, this.deleteRule, this.name$, this.comments, this.notes);
                if (this.mandatory != null && "true".equalsIgnoreCase(this.mandatory)) {
                    fk.setMandatory(true);
                } else if ("".equals(this.mandatory)) {
                    fk.resetMandatoryUsingColumns();
                } else {
                    fk.setMandatory(false);
                }
                if (this.transferable != null && ("true".equalsIgnoreCase(this.transferable) || "".equals(this.transferable))) {
                    fk.setTransferable(true);
                } else {
                    fk.setTransferable(false);
                }
                fk.resetEdgeParams();
                if (Table.this.pendingFKassociation != null) {
                    Table.this.removePending(this);
                }
            }
        }
    }
}

